/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.spi.DatastoreRpc;
import java.util.HashMap;

public class DatastoreException
extends RuntimeException {
    private static final long serialVersionUID = 8170357898917041899L;
    private static final ImmutableMap<String, Code> REASON_TO_CODE;
    private static final ImmutableMap<Integer, Code> HTTP_TO_CODE;
    private final Code code;

    public DatastoreException(Code code, String message, Exception cause) {
        super((String)MoreObjects.firstNonNull((Object)message, (Object)code.description), cause);
        this.code = code;
    }

    public DatastoreException(Code code, String message) {
        this(code, message, null);
    }

    public Code code() {
        return this.code;
    }

    static DatastoreException translateAndThrow(RetryHelper.RetryHelperException ex) {
        if (ex.getCause() instanceof DatastoreRpc.DatastoreRpcException) {
            return DatastoreException.translateAndThrow((DatastoreRpc.DatastoreRpcException)ex.getCause());
        }
        if (ex instanceof RetryHelper.RetryInterruptedException) {
            RetryHelper.RetryInterruptedException.propagate();
        }
        throw new DatastoreException(Code.UNKNOWN, ex.getMessage(), (Exception)((Object)ex));
    }

    static DatastoreException translateAndThrow(DatastoreRpc.DatastoreRpcException exception) {
        String message = exception.getMessage();
        Code code = (Code)((Object)REASON_TO_CODE.get((Object)exception.reason()));
        if (code == null) {
            code = (Code)((Object)MoreObjects.firstNonNull((Object)HTTP_TO_CODE.get((Object)exception.httpStatus()), (Object)((Object)Code.UNKNOWN)));
        }
        throw code.translate(exception, message);
    }

    static DatastoreException throwInvalidRequest(String massage, Object ... params) {
        throw new DatastoreException(Code.FAILED_PRECONDITION, String.format(massage, params));
    }

    static DatastoreException propagateUserException(Exception ex) {
        throw new DatastoreException(Code.UNKNOWN, ex.getMessage(), ex);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<Integer, Code> httpCodes = new HashMap<Integer, Code>();
        for (Code code : Code.values()) {
            builder.put((Object)code.name(), (Object)code);
            httpCodes.put(code.httpStatus(), code);
        }
        REASON_TO_CODE = builder.build();
        HTTP_TO_CODE = ImmutableMap.copyOf(httpCodes);
    }

    public static enum Code {
        ABORTED(DatastoreRpc.DatastoreRpcException.Reason.ABORTED),
        DEADLINE_EXCEEDED(DatastoreRpc.DatastoreRpcException.Reason.DEADLINE_EXCEEDED),
        UNAVAILABLE(DatastoreRpc.DatastoreRpcException.Reason.UNAVAILABLE),
        FAILED_PRECONDITION(DatastoreRpc.DatastoreRpcException.Reason.FAILED_PRECONDITION),
        INVALID_ARGUMENT(DatastoreRpc.DatastoreRpcException.Reason.INVALID_ARGUMENT),
        PERMISSION_DENIED(DatastoreRpc.DatastoreRpcException.Reason.PERMISSION_DENIED),
        UNAUTHORIZED(false, "Unauthorized", 401),
        INTERNAL(DatastoreRpc.DatastoreRpcException.Reason.INTERNAL),
        RESOURCE_EXHAUSTED(DatastoreRpc.DatastoreRpcException.Reason.RESOURCE_EXHAUSTED),
        UNKNOWN(false, "Unknown failure", -1);

        private final boolean retryable;
        private final String description;
        private final int httpStatus;

        private Code(DatastoreRpc.DatastoreRpcException.Reason reason) {
            this(reason.retryable(), reason.description(), reason.httpStatus());
        }

        private Code(boolean retryable, String description, int httpStatus) {
            this.retryable = retryable;
            this.description = description;
            this.httpStatus = httpStatus;
        }

        public String description() {
            return this.description;
        }

        public int httpStatus() {
            return this.httpStatus;
        }

        public boolean retryable() {
            return this.retryable;
        }

        DatastoreException translate(DatastoreRpc.DatastoreRpcException exception, String message) {
            return new DatastoreException(this, message, exception);
        }
    }
}

