/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.datastore.DatastoreReader;
import com.google.gcloud.datastore.DatastoreWriter;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.IncompleteKey;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyFactory;
import com.google.gcloud.datastore.Transaction;
import com.google.gcloud.datastore.TransactionOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class DatastoreHelper {
    private DatastoreHelper() {
    }

    static Key allocateId(Datastore service, IncompleteKey key) {
        return service.allocateId(new IncompleteKey[]{key}).get(0);
    }

    static Entity get(DatastoreReader reader, Key key) {
        return (Entity)Iterators.getNext(reader.get(new Key[]{key}), null);
    }

    static Entity add(DatastoreWriter writer, FullEntity<?> entity) {
        return writer.add(new FullEntity[]{entity}).get(0);
    }

    static KeyFactory newKeyFactory(DatastoreOptions options) {
        return new KeyFactory(options.projectId(), options.namespace());
    }

    static List<Entity> fetch(DatastoreReader reader, Key ... keys) {
        Iterator<Entity> entities = reader.get(keys);
        HashMap map = Maps.newHashMapWithExpectedSize((int)keys.length);
        while (entities.hasNext()) {
            Entity entity = entities.next();
            map.put(entity.key(), entity);
        }
        ArrayList<Entity> list = new ArrayList<Entity>(keys.length);
        for (Key key : keys) {
            list.add((Entity)map.get(key));
        }
        return list;
    }

    static <T> T runInTransaction(Datastore datastore, Datastore.TransactionCallable<T> callable, TransactionOption ... options) {
        Transaction transaction = datastore.newTransaction(options);
        try {
            T value = callable.run(transaction);
            transaction.commit();
            T t = value;
            return t;
        }
        catch (Exception ex) {
            transaction.rollback();
            throw DatastoreException.propagateUserException(ex);
        }
        finally {
            if (transaction.active()) {
                transaction.rollback();
            }
        }
    }
}

