/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gcloud.BaseService;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.datastore.Batch;
import com.google.gcloud.datastore.BatchImpl;
import com.google.gcloud.datastore.BatchOption;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.DatastoreHelper;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.IncompleteKey;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyFactory;
import com.google.gcloud.datastore.Query;
import com.google.gcloud.datastore.QueryResults;
import com.google.gcloud.datastore.QueryResultsImpl;
import com.google.gcloud.datastore.Transaction;
import com.google.gcloud.datastore.TransactionImpl;
import com.google.gcloud.datastore.TransactionOption;
import com.google.gcloud.spi.DatastoreRpc;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;

final class DatastoreImpl
extends BaseService<DatastoreOptions>
implements Datastore {
    private static final ExceptionHandler.Interceptor EXCEPTION_HANDLER_INTERCEPTOR = new ExceptionHandler.Interceptor(){
        private static final long serialVersionUID = 6911242958397733203L;

        public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            if (exception instanceof DatastoreRpc.DatastoreRpcException) {
                boolean retryable = ((DatastoreRpc.DatastoreRpcException)exception).retryable();
                return retryable ? ExceptionHandler.Interceptor.RetryResult.RETRY : ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }
    };
    private static final ExceptionHandler EXCEPTION_HANDLER = ExceptionHandler.builder().abortOn(new Class[]{RuntimeException.class, DatastoreRpc.DatastoreRpcException.class}).interceptor(new ExceptionHandler.Interceptor[]{EXCEPTION_HANDLER_INTERCEPTOR}).build();
    private final DatastoreRpc datastoreRpc;
    private final RetryParams retryParams;

    DatastoreImpl(DatastoreOptions options) {
        super((ServiceOptions)options);
        this.datastoreRpc = options.datastoreRpc();
        this.retryParams = (RetryParams)MoreObjects.firstNonNull((Object)options.retryParams(), (Object)RetryParams.noRetries());
    }

    @Override
    public Batch newBatch(BatchOption ... options) {
        return new BatchImpl(this, options);
    }

    @Override
    public Transaction newTransaction(TransactionOption ... options) {
        return new TransactionImpl(this, options);
    }

    @Override
    public <T> T runInTransaction(Datastore.TransactionCallable<T> callable, TransactionOption ... options) {
        return DatastoreHelper.runInTransaction(this, callable, options);
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query) {
        return this.run(null, query);
    }

    <T> QueryResults<T> run(DatastoreV1.ReadOptions readOptionsPb, Query<T> query) {
        return new QueryResultsImpl<T>(this, readOptionsPb, query);
    }

    DatastoreV1.RunQueryResponse runQuery(final DatastoreV1.RunQueryRequest requestPb) {
        try {
            return (DatastoreV1.RunQueryResponse)RetryHelper.runWithRetries((Callable)new Callable<DatastoreV1.RunQueryResponse>(){

                @Override
                public DatastoreV1.RunQueryResponse call() throws DatastoreRpc.DatastoreRpcException {
                    return DatastoreImpl.this.datastoreRpc.runQuery(requestPb);
                }
            }, (RetryParams)this.retryParams, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    @Override
    public Key allocateId(IncompleteKey key) {
        return DatastoreHelper.allocateId(this, key);
    }

    @Override
    public List<Key> allocateId(IncompleteKey ... keys) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        DatastoreV1.AllocateIdsRequest.Builder requestPb = DatastoreV1.AllocateIdsRequest.newBuilder();
        for (IncompleteKey key : keys) {
            requestPb.addKey(this.trimNameOrId(key).toPb());
        }
        DatastoreV1.AllocateIdsResponse responsePb = this.allocateIds(requestPb.build());
        ImmutableList.Builder keyList = ImmutableList.builder();
        for (DatastoreV1.Key keyPb : responsePb.getKeyList()) {
            keyList.add((Object)Key.fromPb(keyPb));
        }
        return keyList.build();
    }

    DatastoreV1.AllocateIdsResponse allocateIds(final DatastoreV1.AllocateIdsRequest requestPb) {
        try {
            return (DatastoreV1.AllocateIdsResponse)RetryHelper.runWithRetries((Callable)new Callable<DatastoreV1.AllocateIdsResponse>(){

                @Override
                public DatastoreV1.AllocateIdsResponse call() throws DatastoreRpc.DatastoreRpcException {
                    return DatastoreImpl.this.datastoreRpc.allocateIds(requestPb);
                }
            }, (RetryParams)this.retryParams, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    private IncompleteKey trimNameOrId(IncompleteKey key) {
        if (key instanceof Key) {
            return IncompleteKey.builder(key).build();
        }
        return key;
    }

    @Override
    public Entity add(FullEntity<?> entity) {
        return DatastoreHelper.add(this, entity);
    }

    @Override
    public List<Entity> add(FullEntity<?> ... entities) {
        if (entities.length == 0) {
            return Collections.emptyList();
        }
        DatastoreV1.Mutation.Builder mutationPb = DatastoreV1.Mutation.newBuilder();
        LinkedHashMap completeEntities = new LinkedHashMap();
        for (FullEntity<Key> fullEntity : entities) {
            Entity completeEntity = null;
            if (fullEntity.key() instanceof Key) {
                completeEntity = Entity.convert(fullEntity);
            }
            if (completeEntity != null) {
                if (completeEntities.put(completeEntity.key(), completeEntity) != null) {
                    throw DatastoreException.throwInvalidRequest("Duplicate entity with the key %s", fullEntity.key());
                }
                mutationPb.addInsert(completeEntity.toPb());
                continue;
            }
            Preconditions.checkArgument((boolean)fullEntity.hasKey(), (String)"entity %s is missing a key", (Object[])new Object[]{fullEntity});
            mutationPb.addInsertAutoId(fullEntity.toPb());
        }
        DatastoreV1.CommitResponse commitResponse = this.commitMutation(mutationPb);
        Iterator allocatedKeys = commitResponse.getMutationResult().getInsertAutoIdKeyList().iterator();
        ImmutableList.Builder responseBuilder = ImmutableList.builder();
        for (FullEntity<?> entity : entities) {
            Entity completeEntity = (Entity)completeEntities.get(entity.key());
            if (completeEntity != null) {
                responseBuilder.add((Object)completeEntity);
                continue;
            }
            responseBuilder.add((Object)Entity.builder(Key.fromPb((DatastoreV1.Key)allocatedKeys.next()), entity).build());
        }
        return responseBuilder.build();
    }

    @Override
    public Entity get(Key key) {
        return DatastoreHelper.get(this, key);
    }

    @Override
    public Iterator<Entity> get(Key ... keys) {
        return this.get((DatastoreV1.ReadOptions)null, keys);
    }

    @Override
    public List<Entity> fetch(Key ... keys) {
        return DatastoreHelper.fetch(this, keys);
    }

    Iterator<Entity> get(DatastoreV1.ReadOptions readOptionsPb, Key ... keys) {
        if (keys.length == 0) {
            return Collections.emptyIterator();
        }
        DatastoreV1.LookupRequest.Builder requestPb = DatastoreV1.LookupRequest.newBuilder();
        if (readOptionsPb != null) {
            requestPb.setReadOptions(readOptionsPb);
        }
        for (Key k : Sets.newLinkedHashSet(Arrays.asList(keys))) {
            requestPb.addKey(k.toPb());
        }
        return new ResultsIterator(requestPb);
    }

    DatastoreV1.LookupResponse lookup(final DatastoreV1.LookupRequest requestPb) {
        try {
            return (DatastoreV1.LookupResponse)RetryHelper.runWithRetries((Callable)new Callable<DatastoreV1.LookupResponse>(){

                @Override
                public DatastoreV1.LookupResponse call() throws DatastoreRpc.DatastoreRpcException {
                    return DatastoreImpl.this.datastoreRpc.lookup(requestPb);
                }
            }, (RetryParams)this.retryParams, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    @Override
    @SafeVarargs
    public final void update(Entity ... entities) {
        if (entities.length > 0) {
            DatastoreV1.Mutation.Builder mutationPb = DatastoreV1.Mutation.newBuilder();
            LinkedHashMap dedupEntities = new LinkedHashMap();
            for (Entity entity : entities) {
                dedupEntities.put(entity.key(), entity);
            }
            for (Entity entity : dedupEntities.values()) {
                mutationPb.addUpdate(entity.toPb());
            }
            this.commitMutation(mutationPb);
        }
    }

    @Override
    @SafeVarargs
    public final void put(Entity ... entities) {
        if (entities.length > 0) {
            DatastoreV1.Mutation.Builder mutationPb = DatastoreV1.Mutation.newBuilder();
            LinkedHashMap dedupEntities = new LinkedHashMap();
            for (Entity entity : entities) {
                dedupEntities.put(entity.key(), entity);
            }
            for (Entity e : dedupEntities.values()) {
                mutationPb.addUpsert(e.toPb());
            }
            this.commitMutation(mutationPb);
        }
    }

    @Override
    public void delete(Key ... keys) {
        if (keys.length > 0) {
            DatastoreV1.Mutation.Builder mutationPb = DatastoreV1.Mutation.newBuilder();
            LinkedHashSet<Key> dedupKeys = new LinkedHashSet<Key>(Arrays.asList(keys));
            for (Key key : dedupKeys) {
                mutationPb.addDelete(key.toPb());
            }
            this.commitMutation(mutationPb);
        }
    }

    @Override
    public KeyFactory newKeyFactory() {
        return DatastoreHelper.newKeyFactory((DatastoreOptions)this.options());
    }

    private DatastoreV1.CommitResponse commitMutation(DatastoreV1.Mutation.Builder mutationPb) {
        if (((DatastoreOptions)this.options()).force()) {
            mutationPb.setForce(true);
        }
        DatastoreV1.CommitRequest.Builder requestPb = DatastoreV1.CommitRequest.newBuilder();
        requestPb.setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL);
        requestPb.setMutation(mutationPb);
        return this.commit(requestPb.build());
    }

    DatastoreV1.CommitResponse commit(final DatastoreV1.CommitRequest requestPb) {
        try {
            return (DatastoreV1.CommitResponse)RetryHelper.runWithRetries((Callable)new Callable<DatastoreV1.CommitResponse>(){

                @Override
                public DatastoreV1.CommitResponse call() throws DatastoreRpc.DatastoreRpcException {
                    return DatastoreImpl.this.datastoreRpc.commit(requestPb);
                }
            }, (RetryParams)this.retryParams, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    ByteString requestTransactionId(DatastoreV1.BeginTransactionRequest.Builder requestPb) {
        return this.beginTransaction(requestPb.build()).getTransaction();
    }

    DatastoreV1.BeginTransactionResponse beginTransaction(final DatastoreV1.BeginTransactionRequest requestPb) {
        try {
            return (DatastoreV1.BeginTransactionResponse)RetryHelper.runWithRetries((Callable)new Callable<DatastoreV1.BeginTransactionResponse>(){

                @Override
                public DatastoreV1.BeginTransactionResponse call() throws DatastoreRpc.DatastoreRpcException {
                    return DatastoreImpl.this.datastoreRpc.beginTransaction(requestPb);
                }
            }, (RetryParams)this.retryParams, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    void rollbackTransaction(ByteString transaction) {
        DatastoreV1.RollbackRequest.Builder requestPb = DatastoreV1.RollbackRequest.newBuilder();
        requestPb.setTransaction(transaction);
        this.rollback(requestPb.build());
    }

    void rollback(final DatastoreV1.RollbackRequest requestPb) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() throws DatastoreRpc.DatastoreRpcException {
                    DatastoreImpl.this.datastoreRpc.rollback(requestPb);
                    return null;
                }
            }, (RetryParams)this.retryParams, (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    final class ResultsIterator
    extends AbstractIterator<Entity> {
        private final DatastoreV1.LookupRequest.Builder requestPb;
        Iterator<DatastoreV1.EntityResult> iter;

        ResultsIterator(DatastoreV1.LookupRequest.Builder requestPb) {
            this.requestPb = requestPb;
            this.loadResults();
        }

        private void loadResults() {
            DatastoreV1.LookupResponse responsePb = DatastoreImpl.this.lookup(this.requestPb.build());
            this.iter = responsePb.getFoundList().iterator();
            this.requestPb.clearKey();
            if (responsePb.getDeferredCount() > 0) {
                this.requestPb.addAllKey((Iterable)responsePb.getDeferredList());
            }
        }

        protected Entity computeNext() {
            while (!this.iter.hasNext()) {
                if (this.requestPb.getKeyCount() == 0) {
                    return (Entity)this.endOfData();
                }
                this.loadResults();
            }
            return Entity.fromPb(this.iter.next().getEntity());
        }
    }
}

