/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.Validator;
import com.google.gcloud.spi.DatastoreRpc;
import com.google.gcloud.spi.DatastoreRpcFactory;
import com.google.gcloud.spi.DefaultDatastoreRpc;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class DatastoreOptions
extends ServiceOptions<DatastoreRpc, DatastoreOptions> {
    private static final long serialVersionUID = -8636602944160689193L;
    private static final String DATASET_ENV_NAME = "DATASTORE_DATASET";
    private static final String HOST_ENV_NAME = "DATASTORE_HOST";
    private static final String DATASTORE_SCOPE = "https://www.googleapis.com/auth/datastore";
    private static final String USERINFO_SCOPE = "https://www.googleapis.com/auth/userinfo.email";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/datastore", (Object)"https://www.googleapis.com/auth/userinfo.email");
    private final String namespace;
    private final boolean force;
    private final boolean normalizeDataset;
    private transient DatastoreRpc datastoreRpc;

    private DatastoreOptions(Builder builder) {
        super((ServiceOptions.Builder)builder);
        this.normalizeDataset = builder.normalizeDataset;
        this.namespace = builder.namespace != null ? builder.namespace : DatastoreOptions.defaultNamespace();
        this.force = builder.force;
    }

    private DatastoreOptions normalize() {
        if (!this.normalizeDataset) {
            return this;
        }
        Builder builder = this.toBuilder();
        builder.normalizeDataset(false);
        DatastoreV1.LookupRequest.Builder requestPb = DatastoreV1.LookupRequest.newBuilder();
        DatastoreV1.Key key = DatastoreV1.Key.newBuilder().addPathElement(DatastoreV1.Key.PathElement.newBuilder().setKind("__foo__").setName("bar")).build();
        requestPb.addKey(key);
        try {
            DatastoreV1.LookupResponse responsePb = this.datastoreRpc().lookup(requestPb.build());
            if (responsePb.getDeferredCount() > 0) {
                key = responsePb.getDeferred(0);
            } else {
                Iterator combinedIter = Iterables.concat((Iterable)responsePb.getMissingList(), (Iterable)responsePb.getFoundList()).iterator();
                key = ((DatastoreV1.EntityResult)combinedIter.next()).getEntity().getKey();
            }
            builder.projectId(key.getPartitionId().getDatasetId());
            return new DatastoreOptions(builder);
        }
        catch (DatastoreRpc.DatastoreRpcException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    protected String defaultHost() {
        String host = System.getProperty(HOST_ENV_NAME, System.getenv(HOST_ENV_NAME));
        return host != null ? host : super.defaultHost();
    }

    protected String defaultProject() {
        String projectId = System.getProperty(DATASET_ENV_NAME, System.getenv(DATASET_ENV_NAME));
        if (projectId == null) {
            projectId = DatastoreOptions.appEngineAppId();
        }
        return projectId != null ? projectId : super.defaultProject();
    }

    public String namespace() {
        return this.namespace;
    }

    private static String defaultNamespace() {
        try {
            Class<?> clazz = Class.forName("com.google.appengine.api.NamespaceManager");
            Method method = clazz.getMethod("get", new Class[0]);
            String namespace = (String)method.invoke(null, new Object[0]);
            return namespace == null || namespace.isEmpty() ? null : namespace;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public boolean force() {
        return this.force;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode() ^ Objects.hash(this.namespace, this.force, this.normalizeDataset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatastoreOptions)) {
            return false;
        }
        DatastoreOptions other = (DatastoreOptions)((Object)obj);
        return this.baseEquals(other) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.force, other.force) && Objects.equals(this.normalizeDataset, other.normalizeDataset);
    }

    DatastoreRpc datastoreRpc() {
        if (this.datastoreRpc != null) {
            return this.datastoreRpc;
        }
        if (this.serviceRpcFactory() != null) {
            this.datastoreRpc = (DatastoreRpc)this.serviceRpcFactory().create((ServiceOptions)this);
        } else {
            this.datastoreRpc = (DatastoreRpc)DatastoreOptions.createRpc((ServiceOptions)this, DatastoreRpcFactory.class);
            if (this.datastoreRpc == null) {
                this.datastoreRpc = new DefaultDatastoreRpc(this);
            }
        }
        return this.datastoreRpc;
    }

    public static DatastoreOptions defaultInstance() {
        return DatastoreOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<DatastoreRpc, DatastoreOptions, Builder> {
        private String namespace;
        private boolean force;
        private boolean normalizeDataset = true;

        private Builder() {
        }

        private Builder(DatastoreOptions options) {
            super((ServiceOptions)options);
            this.force = options.force;
            this.namespace = options.namespace;
            this.normalizeDataset = options.normalizeDataset;
        }

        public DatastoreOptions build() {
            DatastoreOptions options = new DatastoreOptions(this);
            return this.normalizeDataset ? options.normalize() : options;
        }

        public Builder namespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }

        public Builder force(boolean force) {
            this.force = force;
            return this;
        }

        Builder normalizeDataset(boolean normalizeDataset) {
            this.normalizeDataset = normalizeDataset;
            return this;
        }
    }
}

