/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.GqlQuery;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.ProjectionEntity;
import com.google.gcloud.datastore.Serializable;
import com.google.gcloud.datastore.StructuredQuery;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;

public abstract class Query<V>
extends Serializable<GeneratedMessage> {
    private static final long serialVersionUID = -2748141759901313101L;
    private final ResultType<V> resultType;
    private final String namespace;

    Query(ResultType<V> resultType, String namespace) {
        this.resultType = (ResultType)Preconditions.checkNotNull(resultType);
        this.namespace = namespace;
    }

    ResultType<V> type() {
        return this.resultType;
    }

    public String namespace() {
        return this.namespace;
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        toStringHelper.add("type", this.resultType);
        toStringHelper.add("namespace", (Object)this.namespace);
        toStringHelper.add("queryPb", (Object)super.toString());
        return toStringHelper.toString();
    }

    @Override
    protected Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return this.fromPb(this.resultType, this.namespace, bytesPb);
    }

    protected abstract Object fromPb(ResultType<V> var1, String var2, byte[] var3) throws InvalidProtocolBufferException;

    protected abstract void populatePb(DatastoreV1.RunQueryRequest.Builder var1);

    protected abstract Query<V> nextQuery(DatastoreV1.QueryResultBatch var1);

    public static GqlQuery.Builder<?> gqlQueryBuilder(String gql) {
        return Query.gqlQueryBuilder(ResultType.UNKNOWN, gql);
    }

    public static <V> GqlQuery.Builder<V> gqlQueryBuilder(ResultType<V> resultType, String gql) {
        return new GqlQuery.Builder<V>(resultType, gql);
    }

    public static StructuredQuery.EntityQueryBuilder entityQueryBuilder() {
        return new StructuredQuery.EntityQueryBuilder();
    }

    public static StructuredQuery.KeyQueryBuilder keyQueryBuilder() {
        return new StructuredQuery.KeyQueryBuilder();
    }

    public static StructuredQuery.ProjectionEntityQueryBuilder projectionEntityQueryBuilder() {
        return new StructuredQuery.ProjectionEntityQueryBuilder();
    }

    public static abstract class ResultType<V>
    implements java.io.Serializable {
        private static final long serialVersionUID = 2104157695425806623L;
        private static final Map<DatastoreV1.EntityResult.ResultType, ResultType<?>> PB_TO_INSTANCE = Maps.newEnumMap(DatastoreV1.EntityResult.ResultType.class);
        static final ResultType<?> UNKNOWN = new ResultType<Object>(null, Object.class){
            private static final long serialVersionUID = 1602329532153860907L;

            @Override
            protected Object convert(DatastoreV1.Entity entityPb) {
                if (entityPb.getPropertyCount() == 0) {
                    if (!entityPb.hasKey()) {
                        return null;
                    }
                    return Key.fromPb(entityPb.getKey());
                }
                return ProjectionEntity.fromPb(entityPb);
            }
        };
        public static final ResultType<Entity> ENTITY = new ResultType<Entity>(DatastoreV1.EntityResult.ResultType.FULL, Entity.class){
            private static final long serialVersionUID = 7712959777507168274L;

            @Override
            protected Entity convert(DatastoreV1.Entity entityPb) {
                return Entity.fromPb(entityPb);
            }
        };
        public static final ResultType<Key> KEY = new ResultType<Key>(DatastoreV1.EntityResult.ResultType.KEY_ONLY, Key.class){
            private static final long serialVersionUID = -8514289244104446252L;

            @Override
            protected Key convert(DatastoreV1.Entity entityPb) {
                return Key.fromPb(entityPb.getKey());
            }
        };
        public static final ResultType<ProjectionEntity> PROJECTION_ENTITY = new ResultType<ProjectionEntity>(DatastoreV1.EntityResult.ResultType.PROJECTION, ProjectionEntity.class){
            private static final long serialVersionUID = -7591409419690650246L;

            @Override
            protected ProjectionEntity convert(DatastoreV1.Entity entityPb) {
                return ProjectionEntity.fromPb(entityPb);
            }
        };
        private final Class<V> resultClass;
        private final DatastoreV1.EntityResult.ResultType queryType;

        private ResultType(DatastoreV1.EntityResult.ResultType queryType, Class<V> resultClass) {
            this.queryType = queryType;
            this.resultClass = resultClass;
            if (queryType != null) {
                PB_TO_INSTANCE.put(queryType, this);
            }
        }

        public Class<V> resultClass() {
            return this.resultClass;
        }

        public int hashCode() {
            return this.resultClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ResultType)) {
                return false;
            }
            ResultType other = (ResultType)obj;
            return this.resultClass.equals(other.resultClass);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("queryType", (Object)this.queryType);
            toStringHelper.add("resultClass", this.resultClass);
            return toStringHelper.toString();
        }

        boolean isAssignableFrom(ResultType<?> otherResultType) {
            return this.resultClass.isAssignableFrom(otherResultType.resultClass);
        }

        protected abstract V convert(DatastoreV1.Entity var1);

        static ResultType<?> fromPb(DatastoreV1.EntityResult.ResultType typePb) {
            return (ResultType)MoreObjects.firstNonNull(PB_TO_INSTANCE.get(typePb), UNKNOWN);
        }
    }
}

