/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;

abstract class Serializable<M extends GeneratedMessage>
implements java.io.Serializable {
    private static final long serialVersionUID = -5565522710061949199L;
    private transient byte[] bytesPb;

    Serializable() {
    }

    public String toString() {
        return this.toPb().toString();
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(this.toPb().toByteArray());
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.bytesPb = (byte[])input.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            Object object = this.fromPb(this.bytesPb);
            return object;
        }
        catch (InvalidProtocolBufferException ex) {
            StreamCorruptedException sce = new StreamCorruptedException("Failed to create object");
            sce.initCause(ex);
            throw sce;
        }
        finally {
            this.bytesPb = null;
        }
    }

    protected abstract M toPb();

    protected abstract Object fromPb(byte[] var1) throws InvalidProtocolBufferException;
}

