/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Pattern;

final class Validator {
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("([a-z\\d\\-]{1,100}~)?([a-z\\d][a-z\\d\\-\\.]{0,99}:)?([a-z\\d][a-z\\d\\-]{0,99})");
    private static final int MAX_NAMESPACE_LENGTH = 100;
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile(String.format("[0-9A-Za-z\\._\\-]{0,%d}", 100));

    private Validator() {
    }

    static String validateDatabase(String projectId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"projectId can't be empty or null");
        String string = String.valueOf(PROJECT_ID_PATTERN.pattern());
        Preconditions.checkArgument((boolean)PROJECT_ID_PATTERN.matcher(projectId).matches(), (Object)(string.length() != 0 ? "projectId must match the following pattern: ".concat(string) : new String("projectId must match the following pattern: ")));
        return projectId;
    }

    static String validateNamespace(String namespace) {
        if (namespace != null) {
            Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (Object)"namespace must not be an empty string");
            Preconditions.checkArgument((namespace.length() <= 100 ? 1 : 0) != 0, (Object)"namespace must not contain more than 100 characters");
            String string = String.valueOf(NAMESPACE_PATTERN.pattern());
            Preconditions.checkArgument((boolean)NAMESPACE_PATTERN.matcher(namespace).matches(), (Object)(string.length() != 0 ? "namespace must the following pattern: ".concat(string) : new String("namespace must the following pattern: ")));
        }
        return namespace;
    }

    static String validateKind(String kind) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)kind) ? 1 : 0) != 0, (Object)"kind must not be empty or null");
        return kind;
    }
}

