/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.spi;

import com.google.api.services.datastore.DatastoreV1;

public interface DatastoreRpc {
    public DatastoreV1.AllocateIdsResponse allocateIds(DatastoreV1.AllocateIdsRequest var1) throws DatastoreRpcException;

    public DatastoreV1.BeginTransactionResponse beginTransaction(DatastoreV1.BeginTransactionRequest var1) throws DatastoreRpcException;

    public DatastoreV1.CommitResponse commit(DatastoreV1.CommitRequest var1) throws DatastoreRpcException;

    public DatastoreV1.LookupResponse lookup(DatastoreV1.LookupRequest var1) throws DatastoreRpcException;

    public DatastoreV1.RollbackResponse rollback(DatastoreV1.RollbackRequest var1) throws DatastoreRpcException;

    public DatastoreV1.RunQueryResponse runQuery(DatastoreV1.RunQueryRequest var1) throws DatastoreRpcException;

    public static class DatastoreRpcException
    extends Exception {
        private final String reason;
        private final int httpStatus;
        private final boolean retryable;

        public DatastoreRpcException(Reason reason) {
            this(reason.name(), reason.httpStatus, reason.retryable, reason.description);
        }

        public DatastoreRpcException(String reason, int httpStatus, boolean retryable, String message) {
            super(message);
            this.reason = reason;
            this.httpStatus = httpStatus;
            this.retryable = retryable;
        }

        public String reason() {
            return this.reason;
        }

        public int httpStatus() {
            return this.httpStatus;
        }

        public boolean retryable() {
            return this.retryable;
        }

        public static enum Reason {
            ABORTED(true, "Request aborted", 409),
            DEADLINE_EXCEEDED(true, "Deadline exceeded", 403),
            FAILED_PRECONDITION(false, "Invalid request", 412),
            INTERNAL(false, "Server returned an error", 500),
            INVALID_ARGUMENT(false, "Request parameter has an invalid value", 400),
            PERMISSION_DENIED(false, "Unauthorized request", 403),
            RESOURCE_EXHAUSTED(false, "Quota exceeded", 402),
            UNAVAILABLE(true, "Could not reach service", 503);

            private final boolean retryable;
            private final String description;
            private final int httpStatus;

            private Reason(boolean retryable, String description, int httpStatus) {
                this.retryable = retryable;
                this.description = description;
                this.httpStatus = httpStatus;
            }

            public boolean retryable() {
                return this.retryable;
            }

            public String description() {
                return this.description;
            }

            public int httpStatus() {
                return this.httpStatus;
            }
        }
    }
}

