/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.spi;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreException;
import com.google.api.services.datastore.client.DatastoreFactory;
import com.google.api.services.datastore.client.DatastoreOptions;
import com.google.common.collect.ImmutableMap;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.spi.DatastoreRpc;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DefaultDatastoreRpc
implements DatastoreRpc {
    private final Datastore client;
    private static final ImmutableMap<String, DatastoreRpc.DatastoreRpcException.Reason> STR_TO_REASON;
    private static final ImmutableMap<Integer, DatastoreRpc.DatastoreRpcException.Reason> HTTP_STATUS_TO_REASON;

    public DefaultDatastoreRpc(DatastoreOptions options) {
        this.client = DatastoreFactory.get().create(new DatastoreOptions.Builder().dataset(options.projectId()).host(options.host()).initializer(options.httpRequestInitializer()).build());
    }

    private static DatastoreRpc.DatastoreRpcException translate(DatastoreException exception) {
        DatastoreRpc.DatastoreRpcException.Reason reason;
        String message = exception.getMessage();
        String reasonStr = "";
        if (message != null) {
            try {
                JSONObject json = new JSONObject(new JSONTokener(message));
                JSONObject error = json.getJSONObject("error").getJSONArray("errors").getJSONObject(0);
                reasonStr = error.getString("reason");
                message = error.getString("message");
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
        if ((reason = (DatastoreRpc.DatastoreRpcException.Reason)((Object)STR_TO_REASON.get((Object)reasonStr))) == null) {
            reason = (DatastoreRpc.DatastoreRpcException.Reason)((Object)HTTP_STATUS_TO_REASON.get((Object)exception.getCode()));
        }
        return reason != null ? new DatastoreRpc.DatastoreRpcException(reason) : new DatastoreRpc.DatastoreRpcException("Unknown", exception.getCode(), false, message);
    }

    @Override
    public DatastoreV1.AllocateIdsResponse allocateIds(DatastoreV1.AllocateIdsRequest request) throws DatastoreRpc.DatastoreRpcException {
        try {
            return this.client.allocateIds(request);
        }
        catch (DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.BeginTransactionResponse beginTransaction(DatastoreV1.BeginTransactionRequest request) throws DatastoreRpc.DatastoreRpcException {
        try {
            return this.client.beginTransaction(request);
        }
        catch (DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.CommitResponse commit(DatastoreV1.CommitRequest request) throws DatastoreRpc.DatastoreRpcException {
        try {
            return this.client.commit(request);
        }
        catch (DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.LookupResponse lookup(DatastoreV1.LookupRequest request) throws DatastoreRpc.DatastoreRpcException {
        try {
            return this.client.lookup(request);
        }
        catch (DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.RollbackResponse rollback(DatastoreV1.RollbackRequest request) throws DatastoreRpc.DatastoreRpcException {
        try {
            return this.client.rollback(request);
        }
        catch (DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.RunQueryResponse runQuery(DatastoreV1.RunQueryRequest request) throws DatastoreRpc.DatastoreRpcException {
        try {
            return this.client.runQuery(request);
        }
        catch (DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<Integer, DatastoreRpc.DatastoreRpcException.Reason> httpCodes = new HashMap<Integer, DatastoreRpc.DatastoreRpcException.Reason>();
        for (DatastoreRpc.DatastoreRpcException.Reason reason : DatastoreRpc.DatastoreRpcException.Reason.values()) {
            builder.put((Object)reason.name(), (Object)reason);
            httpCodes.put(reason.httpStatus(), reason);
        }
        STR_TO_REASON = builder.build();
        HTTP_STATUS_TO_REASON = ImmutableMap.copyOf(httpCodes);
    }
}

