/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.examples;

import com.google.common.base.Joiner;
import com.google.gcloud.resourcemanager.ProjectInfo;
import com.google.gcloud.resourcemanager.ResourceManager;
import com.google.gcloud.resourcemanager.ResourceManagerOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ResourceManagerExample {
    private static final String DEFAULT_ACTION = "list";
    private static final Map<String, ResourceManagerAction> ACTIONS = new HashMap<String, ResourceManagerAction>();

    private static String projectDetails(ProjectInfo project) {
        return "{projectId:" + project.projectId() + ", projectNumber:" + project.projectNumber() + ", createTimeMillis:" + project.createTimeMillis() + ", state:" + project.state() + ", labels:" + project.labels() + "}";
    }

    private static void addUsage(String actionName, ResourceManagerAction action, StringBuilder usage) {
        Object[] optionalParams;
        usage.append(actionName);
        Joiner joiner = Joiner.on((String)" ");
        Object[] requiredParams = action.getRequiredParams();
        if (requiredParams.length > 0) {
            usage.append(' ');
            joiner.appendTo(usage, requiredParams);
        }
        if ((optionalParams = action.getOptionalParams()).length > 0) {
            usage.append(" [");
            joiner.appendTo(usage, optionalParams);
            usage.append(']');
        }
    }

    public static void main(String ... args) {
        String actionName = args.length > 0 ? args[0].toLowerCase() : DEFAULT_ACTION;
        ResourceManagerAction action = ACTIONS.get(actionName);
        if (action == null) {
            StringBuilder actionAndParams = new StringBuilder();
            for (Map.Entry<String, ResourceManagerAction> entry : ACTIONS.entrySet()) {
                ResourceManagerExample.addUsage(entry.getKey(), entry.getValue(), actionAndParams);
                actionAndParams.append('|');
            }
            actionAndParams.setLength(actionAndParams.length() - 1);
            System.out.printf("Usage: %s [%s]%n", ResourceManagerExample.class.getSimpleName(), actionAndParams);
            return;
        }
        ResourceManager resourceManager = (ResourceManager)ResourceManagerOptions.defaultInstance().service();
        String[] stringArray = args = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        if (args.length < action.getRequiredParams().length) {
            StringBuilder usage = new StringBuilder();
            usage.append("Usage: ");
            ResourceManagerExample.addUsage(actionName, action, usage);
            System.out.println(usage);
        } else {
            action.run(resourceManager, args);
        }
    }

    static {
        ACTIONS.put("create", new CreateAction());
        ACTIONS.put("delete", new DeleteAction());
        ACTIONS.put("get", new GetAction());
        ACTIONS.put(DEFAULT_ACTION, new ListAction());
    }

    private static class ListAction
    implements ResourceManagerAction {
        private ListAction() {
        }

        @Override
        public void run(ResourceManager resourceManager, String ... args) {
            System.out.println("Projects you can view:");
            for (ProjectInfo project : resourceManager.list(new ResourceManager.ProjectListOption[0]).values()) {
                System.out.println(ResourceManagerExample.projectDetails(project));
            }
        }

        @Override
        public String[] getRequiredParams() {
            return new String[0];
        }

        @Override
        public String[] getOptionalParams() {
            return new String[0];
        }
    }

    private static class GetAction
    implements ResourceManagerAction {
        private GetAction() {
        }

        @Override
        public void run(ResourceManager resourceManager, String ... args) {
            String projectId = args[0];
            ProjectInfo project = resourceManager.get(projectId, new ResourceManager.ProjectGetOption[0]);
            if (project != null) {
                System.out.printf("Successfully got project '%s': %s.%n", projectId, ResourceManagerExample.projectDetails(project));
            } else {
                System.out.printf("Could not find project '%s'.%n", projectId);
            }
        }

        @Override
        public String[] getRequiredParams() {
            return new String[]{"project-id"};
        }

        @Override
        public String[] getOptionalParams() {
            return new String[0];
        }
    }

    private static class DeleteAction
    implements ResourceManagerAction {
        private DeleteAction() {
        }

        @Override
        public void run(ResourceManager resourceManager, String ... args) {
            String projectId = args[0];
            System.out.printf("Going to delete project \"%s\". Are you sure [y/N]: ", projectId);
            Scanner scanner = new Scanner(System.in);
            if (scanner.nextLine().toLowerCase().equals("y")) {
                resourceManager.delete(projectId);
                System.out.println("Successfully deleted project " + projectId + ".");
            } else {
                System.out.println("Will not delete project " + projectId + ".");
            }
            scanner.close();
        }

        @Override
        public String[] getRequiredParams() {
            return new String[]{"project-id"};
        }

        @Override
        public String[] getOptionalParams() {
            return new String[0];
        }
    }

    private static class CreateAction
    implements ResourceManagerAction {
        private CreateAction() {
        }

        @Override
        public void run(ResourceManager resourceManager, String ... args) {
            String projectId = args[0];
            HashMap<String, String> labels = new HashMap<String, String>();
            for (int i = 1; i < args.length; i += 2) {
                if (i + 1 < args.length) {
                    labels.put(args[i], args[i + 1]);
                    continue;
                }
                labels.put(args[i], "");
            }
            ProjectInfo project = resourceManager.create(ProjectInfo.builder((String)projectId).labels(labels).build());
            System.out.printf("Successfully created project '%s': %s.%n", projectId, ResourceManagerExample.projectDetails(project));
        }

        @Override
        public String[] getRequiredParams() {
            return new String[]{"project-id"};
        }

        @Override
        public String[] getOptionalParams() {
            return new String[]{"label-key-1", "label-value-1", "label-key-2", "label-value-2", "..."};
        }
    }

    private static interface ResourceManagerAction {
        public void run(ResourceManager var1, String ... var2);

        public String[] getRequiredParams();

        public String[] getOptionalParams();
    }
}

