/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.DimensionHelpers;
import com.google.googlejavaformat.java.Trees;
import com.google.googlejavaformat.java.TypeNameClassifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.Name;
import org.openjdk.source.tree.AnnotatedTypeTree;
import org.openjdk.source.tree.AnnotationTree;
import org.openjdk.source.tree.ArrayAccessTree;
import org.openjdk.source.tree.ArrayTypeTree;
import org.openjdk.source.tree.AssertTree;
import org.openjdk.source.tree.AssignmentTree;
import org.openjdk.source.tree.BinaryTree;
import org.openjdk.source.tree.BlockTree;
import org.openjdk.source.tree.BreakTree;
import org.openjdk.source.tree.CaseTree;
import org.openjdk.source.tree.CatchTree;
import org.openjdk.source.tree.ClassTree;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.tree.CompoundAssignmentTree;
import org.openjdk.source.tree.ConditionalExpressionTree;
import org.openjdk.source.tree.ContinueTree;
import org.openjdk.source.tree.DoWhileLoopTree;
import org.openjdk.source.tree.EmptyStatementTree;
import org.openjdk.source.tree.EnhancedForLoopTree;
import org.openjdk.source.tree.ExpressionStatementTree;
import org.openjdk.source.tree.ExpressionTree;
import org.openjdk.source.tree.ForLoopTree;
import org.openjdk.source.tree.IdentifierTree;
import org.openjdk.source.tree.IfTree;
import org.openjdk.source.tree.ImportTree;
import org.openjdk.source.tree.InstanceOfTree;
import org.openjdk.source.tree.IntersectionTypeTree;
import org.openjdk.source.tree.LabeledStatementTree;
import org.openjdk.source.tree.LambdaExpressionTree;
import org.openjdk.source.tree.LiteralTree;
import org.openjdk.source.tree.MemberReferenceTree;
import org.openjdk.source.tree.MemberSelectTree;
import org.openjdk.source.tree.MethodInvocationTree;
import org.openjdk.source.tree.MethodTree;
import org.openjdk.source.tree.ModifiersTree;
import org.openjdk.source.tree.NewArrayTree;
import org.openjdk.source.tree.NewClassTree;
import org.openjdk.source.tree.ParameterizedTypeTree;
import org.openjdk.source.tree.ParenthesizedTree;
import org.openjdk.source.tree.PrimitiveTypeTree;
import org.openjdk.source.tree.ReturnTree;
import org.openjdk.source.tree.StatementTree;
import org.openjdk.source.tree.SwitchTree;
import org.openjdk.source.tree.SynchronizedTree;
import org.openjdk.source.tree.ThrowTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.tree.TreeVisitor;
import org.openjdk.source.tree.TryTree;
import org.openjdk.source.tree.TypeCastTree;
import org.openjdk.source.tree.TypeParameterTree;
import org.openjdk.source.tree.UnaryTree;
import org.openjdk.source.tree.UnionTypeTree;
import org.openjdk.source.tree.VariableTree;
import org.openjdk.source.tree.WhileLoopTree;
import org.openjdk.source.tree.WildcardTree;
import org.openjdk.source.util.TreePath;
import org.openjdk.source.util.TreePathScanner;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeScanner;

public final class JavaInputAstVisitor
extends TreePathScanner<Void, Void> {
    private final OpsBuilder builder;
    private static final Indent.Const ZERO = Indent.Const.ZERO;
    private final int indentMultiplier;
    private final Indent.Const minusTwo;
    private final Indent.Const minusFour;
    private final Indent.Const plusTwo;
    private final Indent.Const plusFour;
    private static final ImmutableList<Op> EMPTY_LIST = ImmutableList.of();
    private static final int MAX_ITEM_LENGTH_FOR_FILLING = 10;
    private final Deque<Boolean> inExpression = new ArrayDeque<Boolean>(Arrays.asList(false));
    private static final Predicate<ExpressionTree> IS_ARRAY_VALUE = new Predicate<ExpressionTree>(){

        public boolean apply(ExpressionTree argument) {
            ExpressionTree expression = ((AssignmentTree)argument).getExpression();
            return expression instanceof NewArrayTree && ((NewArrayTree)expression).getType() == null;
        }
    };
    private static final Pattern FORMAT_SPECIFIER = Pattern.compile("%|\\{[0-9]\\}");

    private static final ImmutableList<Op> breakList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)Doc.Break.make(Doc.FillMode.UNIFIED, " ", ZERO, breakTag));
    }

    private static final ImmutableList<Op> breakFillList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)OpenOp.make(ZERO), (Object)Doc.Break.make(Doc.FillMode.INDEPENDENT, " ", ZERO, breakTag), (Object)CloseOp.make());
    }

    private static final ImmutableList<Op> forceBreakList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)Doc.Break.make(Doc.FillMode.FORCED, "", Indent.Const.ZERO, breakTag));
    }

    public JavaInputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        this.builder = builder;
        this.indentMultiplier = indentMultiplier;
        this.minusTwo = Indent.Const.make(-2, indentMultiplier);
        this.minusFour = Indent.Const.make(-4, indentMultiplier);
        this.plusTwo = Indent.Const.make(2, indentMultiplier);
        this.plusFour = Indent.Const.make(4, indentMultiplier);
    }

    private boolean inExpression() {
        return this.inExpression.peekLast();
    }

    public Void scan(Tree tree, Void unused) {
        this.inExpression.addLast(tree instanceof ExpressionTree || this.inExpression.peekLast() != false);
        int previous = this.builder.depth();
        try {
            super.scan(tree, null);
        }
        catch (FormattingError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new FormattingError(this.builder.diagnostic(Throwables.getStackTraceAsString((Throwable)t)));
        }
        finally {
            this.inExpression.removeLast();
        }
        this.builder.checkClosed(previous);
        return null;
    }

    public Void visitCompilationUnit(CompilationUnitTree node, Void unused) {
        boolean first = true;
        if (node.getPackageName() != null) {
            this.markForPartialFormat();
            this.visitPackage(node.getPackageName(), node.getPackageAnnotations());
            this.builder.forcedBreak();
            first = false;
        }
        if (!node.getImports().isEmpty()) {
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            for (ImportTree importDeclaration : node.getImports()) {
                this.markForPartialFormat();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                this.scan((Tree)importDeclaration, null);
                this.builder.forcedBreak();
            }
            first = false;
        }
        this.dropEmptyDeclarations();
        for (Tree type : node.getTypeDecls()) {
            if (type.getKind() == Tree.Kind.IMPORT) continue;
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.scan(type, null);
            this.builder.forcedBreak();
            first = false;
            this.dropEmptyDeclarations();
        }
        this.markForPartialFormat();
        return null;
    }

    private void dropEmptyDeclarations() {
        if (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
            while (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
                this.markForPartialFormat();
                this.token(";");
            }
        }
    }

    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            default: {
                throw new AssertionError(tree.getKind());
            }
        }
        return null;
    }

    public void visitAnnotationType(ClassTree node) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(node.getModifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(ZERO);
        this.token("@");
        this.token("interface");
        this.builder.breakOp(" ");
        this.visit(node.getSimpleName());
        this.builder.close();
        this.builder.close();
        if (node.getMembers() == null) {
            this.builder.open(this.plusFour);
            this.token(";");
            this.builder.close();
        } else {
            this.addBodyDeclarations(node.getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.builder.guessToken(";");
    }

    public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
        this.sync((Tree)node);
        this.visitDot((ExpressionTree)node);
        return null;
    }

    public Void visitNewArray(NewArrayTree node, Void unused) {
        if (node.getType() != null) {
            this.builder.open(this.plusFour);
            this.token("new");
            this.builder.space();
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getType(), DimensionHelpers.SortedDims.YES);
            Tree base = extractedDims.node;
            ArrayDeque<ExpressionTree> dimExpressions = new ArrayDeque<ExpressionTree>(node.getDimensions());
            ArrayDeque<List<AnnotationTree>> annotations = new ArrayDeque<List<AnnotationTree>>();
            annotations.add((List<AnnotationTree>)ImmutableList.copyOf((Collection)node.getAnnotations()));
            annotations.addAll(node.getDimAnnotations());
            annotations.addAll((Collection<List<AnnotationTree>>)extractedDims.dims);
            this.scan(base, null);
            this.builder.open(ZERO);
            this.maybeAddDims(dimExpressions, annotations);
            this.builder.close();
            this.builder.close();
        }
        if (node.getInitializers() != null) {
            if (node.getType() != null) {
                this.builder.space();
            }
            this.visitArrayInitializer(node.getInitializers());
        }
        return null;
    }

    public boolean visitArrayInitializer(List<? extends ExpressionTree> expressions) {
        if (expressions.isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            if (this.builder.peekToken().equals((Object)Optional.of((Object)","))) {
                this.token(",");
            }
            this.token("}", this.plusTwo);
        } else {
            int cols = this.argumentsAreTabular(expressions);
            if (cols != -1) {
                this.builder.open(this.plusTwo);
                this.token("{");
                this.builder.forcedBreak();
                boolean first = true;
                for (Iterable row : Iterables.partition(expressions, (int)cols)) {
                    if (!first) {
                        this.builder.forcedBreak();
                    }
                    this.builder.open(((ExpressionTree)row.iterator().next()).getKind() == Tree.Kind.NEW_ARRAY ? ZERO : this.plusFour);
                    boolean firstInRow = true;
                    for (ExpressionTree item : row) {
                        if (!firstInRow) {
                            this.token(",");
                            this.builder.breakToFill(" ");
                        }
                        this.scan((Tree)item, null);
                        firstInRow = false;
                    }
                    this.builder.guessToken(",");
                    this.builder.close();
                    first = false;
                }
                this.builder.breakOp(this.minusTwo);
                this.builder.close();
                this.token("}", this.plusTwo);
            } else {
                boolean shortItems;
                boolean inMemberValuePair = false;
                TreePath path = this.getCurrentPath();
                for (int i = 0; i < 2 && path != null; path = path.getParentPath(), ++i) {
                    if (path.getLeaf().getKind() != Tree.Kind.ANNOTATION) continue;
                    inMemberValuePair = true;
                    break;
                }
                boolean allowFilledElementsOnOwnLine = (shortItems = this.hasOnlyShortItems(expressions)) || !inMemberValuePair;
                this.builder.open(this.plusTwo);
                this.tokenBreakTrailingComment("{", this.plusTwo);
                boolean hasTrailingComma = this.hasTrailingToken(this.builder.getInput(), expressions, ",");
                this.builder.breakOp(hasTrailingComma ? Doc.FillMode.FORCED : Doc.FillMode.UNIFIED, "", ZERO);
                if (allowFilledElementsOnOwnLine) {
                    this.builder.open(ZERO);
                }
                boolean first = true;
                Doc.FillMode fillMode = shortItems ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
                for (ExpressionTree expressionTree : expressions) {
                    if (!first) {
                        this.token(",");
                        this.builder.breakOp(fillMode, " ", ZERO);
                    }
                    this.scan((Tree)expressionTree, null);
                    first = false;
                }
                this.builder.guessToken(",");
                if (allowFilledElementsOnOwnLine) {
                    this.builder.close();
                }
                this.builder.breakOp(this.minusTwo);
                this.builder.close();
                this.token("}", this.plusTwo);
            }
        }
        return false;
    }

    private boolean hasOnlyShortItems(List<? extends ExpressionTree> expressions) {
        for (ExpressionTree expressionTree : expressions) {
            int startPosition = Trees.getStartPosition((Tree)expressionTree);
            if (this.builder.actualSize(startPosition, Trees.getEndPosition((Tree)expressionTree, this.getCurrentPath()) - startPosition) < 10) continue;
            return false;
        }
        return true;
    }

    public Void visitArrayType(ArrayTypeTree node, Void unused) {
        this.sync((Tree)node);
        this.visitAnnotatedArrayType((Tree)node);
        return null;
    }

    private void visitAnnotatedArrayType(Tree node) {
        DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node, DimensionHelpers.SortedDims.YES);
        this.builder.open(this.plusFour);
        this.scan(extractedDims.node, null);
        ArrayDeque<List<AnnotationTree>> dims = new ArrayDeque<List<AnnotationTree>>((Collection<List<AnnotationTree>>)extractedDims.dims);
        this.maybeAddDims(dims);
        Verify.verify((boolean)dims.isEmpty());
        this.builder.close();
    }

    public Void visitAssert(AssertTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.token("assert");
        this.builder.space();
        this.builder.open(node.getDetail() == null ? ZERO : this.plusFour);
        this.scan((Tree)node.getCondition(), null);
        if (node.getDetail() != null) {
            this.builder.breakOp(" ");
            this.token(":");
            this.builder.space();
            this.scan((Tree)node.getDetail(), null);
        }
        this.builder.close();
        this.builder.close();
        this.token(";");
        return null;
    }

    public Void visitAssignment(AssignmentTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.splitToken(Trees.operatorName((ExpressionTree)node));
        this.builder.breakOp(" ");
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
        return null;
    }

    public Void visitBlock(BlockTree node, Void unused) {
        this.visitBlock(node, CollapseEmptyOrNot.NO, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        return null;
    }

    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.splitToken(Trees.operatorName((ExpressionTree)node));
        this.builder.breakOp(" ");
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
        return null;
    }

    public Void visitBreak(BreakTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.token("break");
        if (node.getLabel() != null) {
            this.builder.breakOp(" ");
            this.visit(node.getLabel());
        }
        this.builder.close();
        this.token(";");
        return null;
    }

    public Void visitTypeCast(TypeCastTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.token("(");
        this.scan(node.getType(), null);
        this.token(")");
        this.builder.breakOp(" ");
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
        return null;
    }

    public Void visitNewClass(NewClassTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        if (node.getEnclosingExpression() != null) {
            this.scan((Tree)node.getEnclosingExpression(), null);
            this.builder.breakOp();
            this.token(".");
        }
        this.token("new");
        this.builder.space();
        this.addTypeArguments(node.getTypeArguments(), this.plusFour);
        if (node.getClassBody() != null) {
            this.builder.addAll(this.visitModifiers(node.getClassBody().getModifiers(), Direction.HORIZONTAL, (Optional<Output.BreakTag>)Optional.absent()));
        }
        this.scan((Tree)node.getIdentifier(), null);
        this.addArguments(node.getArguments(), this.plusFour);
        this.builder.close();
        if (node.getClassBody() != null) {
            this.addBodyDeclarations(node.getClassBody().getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        return null;
    }

    public Void visitConditionalExpression(ConditionalExpressionTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getCondition(), null);
        this.builder.breakOp(" ");
        this.token("?");
        this.builder.space();
        this.scan((Tree)node.getTrueExpression(), null);
        this.builder.breakOp(" ");
        this.token(":");
        this.builder.space();
        this.scan((Tree)node.getFalseExpression(), null);
        this.builder.close();
        return null;
    }

    public Void visitContinue(ContinueTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.token("continue");
        if (node.getLabel() != null) {
            this.builder.breakOp(" ");
            this.visit(node.getLabel());
        }
        this.token(";");
        this.builder.close();
        return null;
    }

    public Void visitDoWhileLoop(DoWhileLoopTree node, Void unused) {
        this.sync((Tree)node);
        this.token("do");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.YES);
        if (node.getStatement().getKind() == Tree.Kind.BLOCK) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.token("while");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(node.getCondition()), null);
        this.token(")");
        this.token(";");
        return null;
    }

    public Void visitEmptyStatement(EmptyStatementTree node, Void unused) {
        this.sync((Tree)node);
        this.dropEmptyDeclarations();
        return null;
    }

    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(ZERO);
        this.visitToDeclare(DeclarationKind.NONE, Direction.HORIZONTAL, node.getVariable(), (Optional<ExpressionTree>)Optional.of((Object)node.getExpression()), ":", (Optional<String>)Optional.absent());
        this.builder.close();
        this.token(")");
        this.builder.close();
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    private void visitEnumConstantDeclaration(VariableTree enumConstant) {
        for (AnnotationTree annotation : enumConstant.getModifiers().getAnnotations()) {
            this.scan((Tree)annotation, null);
            this.builder.forcedBreak();
        }
        this.visit(enumConstant.getName());
        NewClassTree init = (NewClassTree)enumConstant.getInitializer();
        if (init.getArguments().isEmpty()) {
            this.builder.guessToken("(");
            this.builder.guessToken(")");
        } else {
            this.addArguments(init.getArguments(), this.plusFour);
        }
        if (init.getClassBody() != null) {
            this.addBodyDeclarations(init.getClassBody().getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
    }

    public boolean visitEnumDeclaration(ClassTree node) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(node.getModifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(this.plusFour);
        this.token("enum");
        this.builder.breakOp(" ");
        this.visit(node.getSimpleName());
        this.builder.close();
        this.builder.close();
        if (!node.getImplementsClause().isEmpty()) {
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            this.token("implements");
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            boolean first = true;
            for (Tree superInterfaceType : node.getImplementsClause()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan(superInterfaceType, null);
                first = false;
            }
            this.builder.close();
            this.builder.close();
            this.builder.close();
        }
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        ArrayList<JCTree.JCVariableDecl> enumConstants = new ArrayList<JCTree.JCVariableDecl>();
        ArrayList<Tree> members = new ArrayList<Tree>();
        for (Tree member : node.getMembers()) {
            if (member instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)member;
                if ((jCVariableDecl.mods.flags & 0x4000L) == 16384L) {
                    enumConstants.add(jCVariableDecl);
                    continue;
                }
            }
            members.add(member);
        }
        if (enumConstants.isEmpty() && members.isEmpty()) {
            this.builder.open(ZERO);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}");
            this.builder.close();
        } else {
            this.builder.open(this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.builder.forcedBreak();
            this.builder.open(ZERO);
            boolean first = true;
            for (VariableTree variableTree : enumConstants) {
                if (!first) {
                    this.token(",");
                    this.builder.forcedBreak();
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                }
                this.markForPartialFormat();
                this.visitEnumConstantDeclaration(variableTree);
                first = false;
            }
            if (((String)this.builder.peekToken().or((Object)"")).equals(",")) {
                this.token(",");
                this.builder.forcedBreak();
            }
            this.builder.close();
            this.builder.close();
            if (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
                this.builder.open(this.plusTwo);
                this.token(";");
                this.builder.forcedBreak();
                this.dropEmptyDeclarations();
                this.builder.close();
            }
            this.builder.open(ZERO);
            this.addBodyDeclarations(members, BracesOrNot.NO, FirstDeclarationsOrNot.NO);
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
            this.builder.close();
        }
        this.builder.guessToken(";");
        return false;
    }

    public Void visitMemberReference(MemberReferenceTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getQualifierExpression(), null);
        this.builder.breakOp();
        this.builder.op("::");
        this.addTypeArguments(node.getTypeArguments(), this.plusFour);
        switch (node.getMode()) {
            case INVOKE: {
                this.visit(node.getName());
                break;
            }
            case NEW: {
                this.token("new");
                break;
            }
            default: {
                throw new AssertionError(node.getMode());
            }
        }
        this.builder.close();
        return null;
    }

    public Void visitExpressionStatement(ExpressionStatementTree node, Void unused) {
        this.sync((Tree)node);
        this.scan((Tree)node.getExpression(), null);
        this.token(";");
        return null;
    }

    public Void visitVariable(VariableTree node, Void unused) {
        this.sync((Tree)node);
        this.visitVariables((List<VariableTree>)ImmutableList.of((Object)node), DeclarationKind.NONE, this.fieldAnnotationDirection(node.getModifiers()));
        return null;
    }

    void visitVariables(List<VariableTree> fragments, DeclarationKind declarationKind, Direction annotationDirection) {
        if (fragments.size() == 1) {
            VariableTree fragment = fragments.get(0);
            this.declareOne(declarationKind, annotationDirection, (Optional<ModifiersTree>)Optional.of((Object)fragment.getModifiers()), fragment.getType(), VarArgsOrNot.NO, (List<? extends AnnotationTree>)ImmutableList.of(), fragment.getName(), "", "=", (Optional<ExpressionTree>)Optional.fromNullable((Object)fragment.getInitializer()), (Optional<String>)Optional.of((Object)";"), (Optional<ExpressionTree>)Optional.absent(), (Optional<DimensionHelpers.TypeWithDims>)Optional.fromNullable((Object)this.variableFragmentDims(true, 0, fragment.getType())));
        } else {
            this.declareMany(fragments, annotationDirection);
        }
    }

    private DimensionHelpers.TypeWithDims variableFragmentDims(boolean first, int leadingDims, Tree type) {
        if (type == null) {
            return null;
        }
        if (first) {
            return DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.YES);
        }
        DimensionHelpers.TypeWithDims dims = DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.NO);
        return new DimensionHelpers.TypeWithDims(null, leadingDims > 0 ? dims.dims.subList(0, dims.dims.size() - leadingDims) : dims.dims);
    }

    public Void visitForLoop(ForLoopTree node, Void unused) {
        this.sync((Tree)node);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.open(node.getInitializer().size() <= 1 ? ZERO : this.plusFour);
        if (!node.getInitializer().isEmpty()) {
            if (((StatementTree)node.getInitializer().get(0)).getKind() == Tree.Kind.VARIABLE) {
                PeekingIterator it = Iterators.peekingIterator(node.getInitializer().iterator());
                this.visitVariables(this.variableFragments((PeekingIterator<? extends Tree>)it, (Tree)it.next()), DeclarationKind.NONE, Direction.HORIZONTAL);
            } else {
                boolean first = true;
                this.builder.open(ZERO);
                for (StatementTree t : node.getInitializer()) {
                    if (!first) {
                        this.token(",");
                        this.builder.breakOp(" ");
                    }
                    this.scan((Tree)((ExpressionStatementTree)t).getExpression(), null);
                    first = false;
                }
                this.token(";");
                this.builder.close();
            }
        } else {
            this.token(";");
        }
        this.builder.close();
        this.builder.breakOp(" ");
        if (node.getCondition() != null) {
            this.scan((Tree)node.getCondition(), null);
        }
        this.token(";");
        this.builder.breakOp(" ");
        if (!node.getUpdate().isEmpty()) {
            this.builder.open(node.getUpdate().size() <= 1 ? ZERO : this.plusFour);
            boolean firstUpdater = true;
            for (ExpressionStatementTree updater : node.getUpdate()) {
                if (!firstUpdater) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan((Tree)updater.getExpression(), null);
                firstUpdater = false;
            }
            this.builder.guessToken(";");
            this.builder.close();
        }
        this.builder.close();
        this.token(")");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    public Void visitIf(IfTree node, Void unused) {
        this.sync((Tree)node);
        ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        while (true) {
            expressions.add(node.getCondition());
            statements.add(node.getThenStatement());
            if (node.getElseStatement() == null || node.getElseStatement().getKind() != Tree.Kind.IF) break;
            node = (IfTree)node.getElseStatement();
        }
        this.builder.open(ZERO);
        boolean first = true;
        boolean followingBlock = false;
        int expressionsN = expressions.size();
        for (int i = 0; i < expressionsN; ++i) {
            if (!first) {
                if (followingBlock) {
                    this.builder.space();
                } else {
                    this.builder.forcedBreak();
                }
                this.token("else");
                this.builder.space();
            }
            this.token("if");
            this.builder.space();
            this.token("(");
            this.scan((Tree)Trees.skipParen((ExpressionTree)expressions.get(i)), null);
            this.token(")");
            boolean onlyClause = expressionsN == 1 && node.getElseStatement() == null;
            boolean trailingClauses = i < expressionsN - 1 || node.getElseStatement() != null;
            this.visitStatement((StatementTree)statements.get(i), CollapseEmptyOrNot.valueOf(onlyClause), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
            followingBlock = ((StatementTree)statements.get(i)).getKind() == Tree.Kind.BLOCK;
            first = false;
        }
        if (node.getElseStatement() != null) {
            if (followingBlock) {
                this.builder.space();
            } else {
                this.builder.forcedBreak();
            }
            this.token("else");
            this.visitStatement(node.getElseStatement(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return null;
    }

    public Void visitImport(ImportTree node, Void unused) {
        this.sync((Tree)node);
        this.token("import");
        this.builder.space();
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        this.visitName(node.getQualifiedIdentifier());
        this.token(";");
        this.dropEmptyDeclarations();
        return null;
    }

    public Void visitBinary(BinaryTree node, Void unused) {
        this.sync((Tree)node);
        ArrayList<ExpressionTree> operands = new ArrayList<ExpressionTree>();
        ArrayList<String> operators = new ArrayList<String>();
        JavaInputAstVisitor.walkInfix(Trees.precedence((ExpressionTree)node), (ExpressionTree)node, operands, operators);
        Doc.FillMode fillMode = this.hasOnlyShortItems(operands) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        this.builder.open(this.plusFour);
        this.scan((Tree)operands.get(0), null);
        int operatorsN = operators.size();
        for (int i = 0; i < operatorsN; ++i) {
            this.builder.breakOp(fillMode, " ", ZERO);
            this.builder.op((String)operators.get(i));
            this.builder.space();
            this.scan((Tree)operands.get(i + 1), null);
        }
        this.builder.close();
        return null;
    }

    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        this.scan(node.getType(), null);
        this.builder.close();
        this.builder.close();
        return null;
    }

    public Void visitIntersectionType(IntersectionTypeTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(this.plusFour);
        boolean first = true;
        for (Tree type : node.getBounds()) {
            if (!first) {
                this.builder.breakToFill(" ");
                this.token("&");
                this.builder.space();
            }
            this.scan(type, null);
            first = false;
        }
        this.builder.close();
        return null;
    }

    public Void visitLabeledStatement(LabeledStatementTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.visit(node.getLabel());
        this.token(":");
        this.builder.forcedBreak();
        this.builder.close();
        this.scan((Tree)node.getStatement(), null);
        return null;
    }

    public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
        this.sync((Tree)node);
        boolean statementBody = node.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT;
        boolean parens = this.builder.peekToken().equals((Object)Optional.of((Object)"("));
        this.builder.open(parens ? this.plusFour : ZERO);
        if (parens) {
            this.token("(");
        }
        boolean first = true;
        for (VariableTree parameter : node.getParameters()) {
            if (!first) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)parameter, null);
            first = false;
        }
        if (parens) {
            this.token(")");
        }
        this.builder.close();
        this.builder.space();
        this.builder.op("->");
        this.builder.open(statementBody ? ZERO : this.plusFour);
        if (statementBody) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        if (node.getBody().getKind() == Tree.Kind.BLOCK) {
            this.visitBlock((BlockTree)node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        } else {
            this.scan(node.getBody(), null);
        }
        this.builder.close();
        return null;
    }

    public Void visitAnnotation(AnnotationTree node, Void unused) {
        this.sync((Tree)node);
        if (this.visitSingleMemberAnnotation(node)) {
            return null;
        }
        this.builder.open(ZERO);
        this.token("@");
        this.scan(node.getAnnotationType(), null);
        if (!node.getArguments().isEmpty()) {
            this.builder.open(this.plusTwo);
            this.token("(");
            this.builder.breakOp();
            boolean first = true;
            boolean hasArrayInitializer = Iterables.any((Iterable)node.getArguments(), IS_ARRAY_VALUE);
            for (ExpressionTree argument : node.getArguments()) {
                if (!first) {
                    this.token(",");
                    if (hasArrayInitializer) {
                        this.builder.forcedBreak();
                    } else {
                        this.builder.breakOp(" ");
                    }
                }
                this.visitAnnotationArgument((AssignmentTree)argument);
                first = false;
            }
            this.builder.breakOp(Doc.FillMode.UNIFIED, "", this.minusTwo, (Optional<Output.BreakTag>)Optional.absent());
            this.builder.close();
            this.token(")", this.plusTwo);
            this.builder.close();
            return null;
        }
        if (this.builder.peekToken().equals((Object)Optional.of((Object)"("))) {
            this.token("(");
            this.token(")");
        }
        this.builder.close();
        return null;
    }

    public void visitAnnotationArgument(AssignmentTree node) {
        boolean isArrayInitializer = node.getExpression().getKind() == Tree.Kind.NEW_ARRAY;
        this.sync((Tree)node);
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.token("=");
        if (isArrayInitializer) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
    }

    public Void visitAnnotatedType(AnnotatedTypeTree node, Void unused) {
        this.sync((Tree)node);
        ExpressionTree base = node.getUnderlyingType();
        if (base instanceof MemberSelectTree) {
            MemberSelectTree selectTree = (MemberSelectTree)base;
            this.scan((Tree)selectTree.getExpression(), null);
            this.token(".");
            this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.NO);
            this.builder.breakToFill(" ");
            this.visit(selectTree.getIdentifier());
        } else if (base instanceof ArrayTypeTree) {
            this.visitAnnotatedArrayType((Tree)node);
        } else {
            this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.NO);
            this.builder.breakToFill(" ");
            this.scan((Tree)base, null);
        }
        return null;
    }

    public Void visitMethod(MethodTree node, Void unused) {
        String name;
        this.sync((Tree)node);
        List annotations = node.getModifiers().getAnnotations();
        Object returnTypeAnnotations = ImmutableList.of();
        if (!node.getTypeParameters().isEmpty() && !annotations.isEmpty()) {
            int typeParameterStart = Trees.getStartPosition((Tree)node.getTypeParameters().get(0));
            for (int i = 0; i < annotations.size(); ++i) {
                if (Trees.getStartPosition((Tree)annotations.get(i)) <= typeParameterStart) continue;
                returnTypeAnnotations = annotations.subList(i, annotations.size());
                annotations = annotations.subList(0, i);
                break;
            }
        }
        this.builder.addAll(this.visitModifiers(annotations, Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent()));
        Tree baseReturnType = null;
        ArrayDeque<List<AnnotationTree>> dims = null;
        if (node.getReturnType() != null) {
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getReturnType(), DimensionHelpers.SortedDims.YES);
            baseReturnType = extractedDims.node;
            dims = new ArrayDeque<List<AnnotationTree>>((Collection<List<AnnotationTree>>)extractedDims.dims);
        }
        this.builder.open(this.plusFour);
        Output.BreakTag breakBeforeName = this.genSym();
        Output.BreakTag breakBeforeType = this.genSym();
        this.builder.open(ZERO);
        boolean first = true;
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
            this.typeParametersRest(node.getTypeParameters(), this.plusFour);
            if (!returnTypeAnnotations.isEmpty()) {
                this.builder.breakToFill(" ");
                this.visitAnnotations((List<? extends AnnotationTree>)returnTypeAnnotations, BreakOrNot.NO, BreakOrNot.NO);
            }
            first = false;
        }
        boolean openedNameAndTypeScope = false;
        if (baseReturnType != null) {
            if (!first) {
                this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)breakBeforeType));
            } else {
                first = false;
            }
            if (!openedNameAndTypeScope) {
                this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
                openedNameAndTypeScope = true;
            }
            this.scan(baseReturnType, null);
            this.maybeAddDims(dims);
        }
        if (!first) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)breakBeforeName));
        } else {
            first = false;
        }
        if (!openedNameAndTypeScope) {
            this.builder.open(ZERO);
            openedNameAndTypeScope = true;
        }
        if ((name = node.getName().toString()).equals("<init>")) {
            name = (String)this.builder.peekToken().get();
        }
        this.token(name);
        this.token("(");
        this.builder.close();
        this.builder.close();
        this.builder.open(Indent.If.make(breakBeforeName, this.plusFour, ZERO));
        this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
        this.builder.open(ZERO);
        if (!node.getParameters().isEmpty() || node.getReceiverParameter() != null) {
            this.builder.breakToFill("");
            this.visitFormals((Optional<VariableTree>)Optional.fromNullable((Object)node.getReceiverParameter()), node.getParameters());
        }
        this.token(")");
        if (dims != null) {
            this.maybeAddDims(dims);
        }
        if (!node.getThrows().isEmpty()) {
            this.builder.breakToFill(" ");
            this.builder.open(this.plusFour);
            this.visitThrowsClause(node.getThrows());
            this.builder.close();
        }
        if (node.getDefaultValue() != null) {
            this.builder.space();
            this.token("default");
            if (node.getDefaultValue().getKind() == Tree.Kind.NEW_ARRAY) {
                this.builder.open(this.minusFour);
                this.builder.space();
                this.scan(node.getDefaultValue(), null);
                this.builder.close();
            } else {
                this.builder.open(ZERO);
                this.builder.breakToFill(" ");
                this.scan(node.getDefaultValue(), null);
                this.builder.close();
            }
        }
        this.builder.close();
        this.builder.close();
        this.builder.close();
        if (node.getBody() == null) {
            this.token(";");
        } else {
            this.builder.space();
            this.builder.token("{", Doc.Token.RealOrImaginary.REAL, this.plusTwo, (Optional<Indent>)Optional.of((Object)this.plusTwo));
        }
        this.builder.close();
        if (node.getBody() != null) {
            this.methodBody(node);
        }
        return null;
    }

    private void methodBody(MethodTree node) {
        if (node.getBody().getStatements().isEmpty()) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        } else {
            this.builder.open(this.plusTwo);
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            this.visitStatements(node.getBody().getStatements());
            this.builder.close();
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.markForPartialFormat();
        }
        this.token("}", this.plusTwo);
    }

    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
        this.sync((Tree)node);
        this.visitDot((ExpressionTree)node);
        return null;
    }

    public Void visitMemberSelect(MemberSelectTree node, Void unused) {
        this.sync((Tree)node);
        this.visitDot((ExpressionTree)node);
        return null;
    }

    public Void visitLiteral(LiteralTree node, Void unused) {
        this.sync((Tree)node);
        String sourceForNode = Trees.getSourceForNode((Tree)node, this.getCurrentPath());
        if (sourceForNode.startsWith("-")) {
            this.token("-");
            sourceForNode = sourceForNode.substring(1).trim();
        }
        this.token(sourceForNode);
        return null;
    }

    private void visitPackage(ExpressionTree packageName, List<? extends AnnotationTree> packageAnnotations) {
        if (!packageAnnotations.isEmpty()) {
            for (AnnotationTree annotationTree : packageAnnotations) {
                this.builder.forcedBreak();
                this.scan((Tree)annotationTree, null);
            }
            this.builder.forcedBreak();
        }
        this.builder.open(this.plusFour);
        this.token("package");
        this.builder.space();
        this.visitName((Tree)packageName);
        this.builder.close();
        this.token(";");
    }

    public Void visitParameterizedType(ParameterizedTypeTree node, Void unused) {
        this.sync((Tree)node);
        if (node.getTypeArguments().isEmpty()) {
            this.scan(node.getType(), null);
            this.token("<");
            this.token(">");
        } else {
            this.builder.open(this.plusFour);
            this.scan(node.getType(), null);
            this.token("<");
            this.builder.breakOp();
            this.builder.open(ZERO);
            boolean first = true;
            for (Tree typeArgument : node.getTypeArguments()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan(typeArgument, null);
                first = false;
            }
            this.builder.close();
            this.builder.close();
            this.token(">");
        }
        return null;
    }

    public Void visitParenthesized(ParenthesizedTree node, Void unused) {
        this.token("(");
        this.scan((Tree)node.getExpression(), null);
        this.token(")");
        return null;
    }

    public Void visitUnary(UnaryTree node, Void unused) {
        this.sync((Tree)node);
        String operatorName = Trees.operatorName((ExpressionTree)node);
        if (((JCTree)node).getTag().isPostUnaryOp()) {
            this.scan((Tree)node.getExpression(), null);
            this.splitToken(operatorName);
        } else {
            this.splitToken(operatorName);
            if (this.ambiguousUnaryOperator(node, operatorName)) {
                this.builder.space();
            }
            this.scan((Tree)node.getExpression(), null);
        }
        return null;
    }

    private void splitToken(String operatorName) {
        for (int i = 0; i < operatorName.length(); ++i) {
            this.token(String.valueOf(operatorName.charAt(i)));
        }
    }

    private boolean ambiguousUnaryOperator(UnaryTree node, String operatorName) {
        switch (node.getKind()) {
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!(node.getExpression() instanceof UnaryTree)) {
            return false;
        }
        JCTree.Tag tag = ((JCTree)node.getExpression()).getTag();
        if (tag.isPostUnaryOp()) {
            return false;
        }
        return Trees.operatorName((ExpressionTree)node).startsWith(operatorName);
    }

    public Void visitPrimitiveType(PrimitiveTypeTree node, Void unused) {
        this.sync((Tree)node);
        switch (node.getPrimitiveTypeKind()) {
            case BOOLEAN: {
                this.token("boolean");
                break;
            }
            case BYTE: {
                this.token("byte");
                break;
            }
            case SHORT: {
                this.token("short");
                break;
            }
            case INT: {
                this.token("int");
                break;
            }
            case LONG: {
                this.token("long");
                break;
            }
            case CHAR: {
                this.token("char");
                break;
            }
            case FLOAT: {
                this.token("float");
                break;
            }
            case DOUBLE: {
                this.token("double");
                break;
            }
            case VOID: {
                this.token("void");
                break;
            }
            default: {
                throw new AssertionError((Object)node.getPrimitiveTypeKind());
            }
        }
        return null;
    }

    public boolean visit(Name name) {
        this.token(name.toString());
        return false;
    }

    public Void visitReturn(ReturnTree node, Void unused) {
        this.sync((Tree)node);
        this.token("return");
        if (node.getExpression() != null) {
            this.builder.space();
            this.scan((Tree)node.getExpression(), null);
        }
        this.token(";");
        return null;
    }

    boolean visitSingleMemberAnnotation(AnnotationTree node) {
        if (node.getArguments().size() != 1) {
            return false;
        }
        ExpressionTree value = (ExpressionTree)Iterables.getOnlyElement((Iterable)node.getArguments());
        if (value.getKind() == Tree.Kind.ASSIGNMENT) {
            return false;
        }
        boolean isArrayInitializer = value.getKind() == Tree.Kind.NEW_ARRAY;
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.token("@");
        this.scan(node.getAnnotationType(), null);
        this.token("(");
        if (!isArrayInitializer) {
            this.builder.breakOp();
        }
        this.scan((Tree)value, null);
        this.builder.close();
        this.token(")");
        return true;
    }

    public Void visitCase(CaseTree node, Void unused) {
        this.sync((Tree)node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        if (node.getExpression() == null) {
            this.token("default", this.plusTwo);
            this.token(":");
        } else {
            this.token("case", this.plusTwo);
            this.builder.space();
            this.scan((Tree)node.getExpression(), null);
            this.token(":");
        }
        this.builder.open(this.plusTwo);
        try {
            this.inExpression.addLast(true);
            this.visitStatements(node.getStatements());
        }
        finally {
            this.inExpression.removeLast();
        }
        this.builder.close();
        return null;
    }

    public Void visitSwitch(SwitchTree node, Void unused) {
        this.sync((Tree)node);
        this.token("switch");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(node.getExpression()), null);
        this.token(")");
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.builder.open(this.plusTwo);
        boolean first = true;
        for (CaseTree caseTree : node.getCases()) {
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.scan((Tree)caseTree, null);
            first = false;
        }
        this.builder.close();
        this.builder.forcedBreak();
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.token("}", this.plusFour);
        return null;
    }

    public Void visitSynchronized(SynchronizedTree node, Void unused) {
        this.sync((Tree)node);
        this.token("synchronized");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.breakOp();
        this.scan((Tree)Trees.skipParen(node.getExpression()), null);
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.scan((Tree)node.getBlock(), null);
        return null;
    }

    public Void visitThrow(ThrowTree node, Void unused) {
        this.sync((Tree)node);
        this.token("throw");
        this.builder.space();
        this.scan((Tree)node.getExpression(), null);
        this.token(";");
        return null;
    }

    public Void visitTry(TryTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.token("try");
        this.builder.space();
        if (!node.getResources().isEmpty()) {
            this.token("(");
            this.builder.open(node.getResources().size() > 1 ? this.plusFour : ZERO);
            boolean first = true;
            for (Tree resource : node.getResources()) {
                if (!first) {
                    this.builder.forcedBreak();
                }
                VariableTree variableTree = (VariableTree)resource;
                this.declareOne(DeclarationKind.PARAMETER, this.fieldAnnotationDirection(variableTree.getModifiers()), (Optional<ModifiersTree>)Optional.of((Object)variableTree.getModifiers()), variableTree.getType(), VarArgsOrNot.NO, (List<? extends AnnotationTree>)ImmutableList.of(), variableTree.getName(), "", "=", (Optional<ExpressionTree>)Optional.fromNullable((Object)variableTree.getInitializer()), (Optional<String>)Optional.absent(), (Optional<ExpressionTree>)Optional.absent(), (Optional<DimensionHelpers.TypeWithDims>)Optional.absent());
                if (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
                    this.token(";");
                    this.builder.space();
                }
                first = false;
            }
            if (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
                this.token(";");
                this.builder.space();
            }
            this.token(")");
            this.builder.close();
            this.builder.space();
        }
        boolean trailingClauses = !node.getCatches().isEmpty() || node.getFinallyBlock() != null;
        this.visitBlock(node.getBlock(), CollapseEmptyOrNot.valueOf(!trailingClauses), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
        for (int i = 0; i < node.getCatches().size(); ++i) {
            CatchTree catchClause = (CatchTree)node.getCatches().get(i);
            trailingClauses = i < node.getCatches().size() - 1 || node.getFinallyBlock() != null;
            this.visitCatchClause(catchClause, AllowTrailingBlankLine.valueOf(trailingClauses));
        }
        if (node.getFinallyBlock() != null) {
            this.builder.space();
            this.token("finally");
            this.builder.space();
            this.visitBlock(node.getFinallyBlock(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return null;
    }

    public void visitClassDeclaration(ClassTree node) {
        this.sync((Tree)node);
        List<Op> breaks = this.visitModifiers(node.getModifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        boolean hasSuperclassType = node.getExtendsClause() != null;
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        this.builder.addAll(breaks);
        this.token(node.getKind() == Tree.Kind.INTERFACE ? "interface" : "class");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperclassType || hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        if (hasSuperclassType) {
            this.builder.breakToFill(" ");
            this.token("extends");
            this.builder.space();
            this.scan(node.getExtendsClause(), null);
        }
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.getImplementsClause().size() > 1 ? this.plusFour : ZERO);
            this.token(node.getKind() == Tree.Kind.INTERFACE ? "extends" : "implements");
            this.builder.space();
            boolean first = true;
            for (Tree superInterfaceType : node.getImplementsClause()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(superInterfaceType, null);
                first = false;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            this.addBodyDeclarations(node.getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    public Void visitTypeParameter(TypeParameterTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.YES);
        this.visit(node.getName());
        if (!node.getBounds().isEmpty()) {
            this.builder.space();
            this.token("extends");
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            boolean first = true;
            for (Tree typeBound : node.getBounds()) {
                if (!first) {
                    this.builder.breakToFill(" ");
                    this.token("&");
                    this.builder.space();
                }
                this.scan(typeBound, null);
                first = false;
            }
            this.builder.close();
            this.builder.close();
        }
        this.builder.close();
        return null;
    }

    public Void visitUnionType(UnionTypeTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into union types");
    }

    public Void visitWhileLoop(WhileLoopTree node, Void unused) {
        this.sync((Tree)node);
        this.token("while");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(node.getCondition()), null);
        this.token(")");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    public Void visitWildcard(WildcardTree node, Void unused) {
        this.sync((Tree)node);
        this.builder.open(ZERO);
        this.token("?");
        if (node.getBound() != null) {
            this.builder.open(this.plusFour);
            this.builder.space();
            this.token(node.getKind() == Tree.Kind.EXTENDS_WILDCARD ? "extends" : "super");
            this.builder.breakOp(" ");
            this.scan(node.getBound(), null);
            this.builder.close();
        }
        this.builder.close();
        return null;
    }

    void visitAnnotations(List<? extends AnnotationTree> annotations, BreakOrNot breakBefore, BreakOrNot breakAfter) {
        if (!annotations.isEmpty()) {
            if (breakBefore.isYes()) {
                this.builder.breakToFill(" ");
            }
            boolean first = true;
            for (AnnotationTree annotationTree : annotations) {
                if (!first) {
                    this.builder.breakToFill(" ");
                }
                this.scan((Tree)annotationTree, null);
                first = false;
            }
            if (breakAfter.isYes()) {
                this.builder.breakToFill(" ");
            }
        }
    }

    private void visitBlock(BlockTree node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlankLine, AllowTrailingBlankLine allowTrailingBlankLine) {
        this.sync((Tree)node);
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        if (collapseEmptyOrNot.isYes() && node.getStatements().isEmpty()) {
            if (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
                this.token(";");
            } else {
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
            }
        } else {
            this.builder.open(ZERO);
            this.builder.open(this.plusTwo);
            this.tokenBreakTrailingComment("{", this.plusTwo);
            if (allowLeadingBlankLine == AllowLeadingBlankLine.NO) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.visitStatements(node.getStatements());
            this.builder.close();
            this.builder.forcedBreak();
            this.builder.close();
            if (allowTrailingBlankLine == AllowTrailingBlankLine.NO) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.markForPartialFormat();
            this.token("}", this.plusTwo);
        }
    }

    private void visitStatement(StatementTree node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlank, AllowTrailingBlankLine allowTrailingBlank) {
        this.sync((Tree)node);
        switch (node.getKind()) {
            case BLOCK: {
                this.builder.space();
                this.visitBlock((BlockTree)node, collapseEmptyOrNot, allowLeadingBlank, allowTrailingBlank);
                break;
            }
            default: {
                this.builder.open(this.plusTwo);
                this.builder.breakOp(" ");
                this.scan((Tree)node, null);
                this.builder.close();
            }
        }
    }

    private void visitStatements(List<? extends StatementTree> statements) {
        boolean first = true;
        PeekingIterator it = Iterators.peekingIterator(statements.iterator());
        this.dropEmptyDeclarations();
        while (it.hasNext()) {
            StatementTree tree = (StatementTree)it.next();
            this.builder.forcedBreak();
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.markForPartialFormat();
            first = false;
            List<VariableTree> fragments = this.variableFragments((PeekingIterator<? extends Tree>)it, (Tree)tree);
            if (!fragments.isEmpty()) {
                this.visitVariables(fragments, DeclarationKind.NONE, this.canLocalHaveHorizontalAnnotations(fragments.get(0).getModifiers()));
                continue;
            }
            this.scan((Tree)tree, null);
        }
    }

    void visitAndBreakModifiers(ModifiersTree modifiers, Direction annotationDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        this.builder.addAll(this.visitModifiers(modifiers, annotationDirection, declarationAnnotationBreak));
    }

    public Void visitModifiers(ModifiersTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into modifiers");
    }

    private List<Op> visitModifiers(ModifiersTree modifiersTree, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        return this.visitModifiers(modifiersTree.getAnnotations(), annotationsDirection, declarationAnnotationBreak);
    }

    private List<Op> visitModifiers(List<? extends AnnotationTree> annotationTrees, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        ImmutableList<Op> trailingBreak;
        if (annotationTrees.isEmpty() && !this.nextIsModifier()) {
            return EMPTY_LIST;
        }
        ArrayDeque<? extends AnnotationTree> annotations = new ArrayDeque<AnnotationTree>(annotationTrees);
        this.builder.open(ZERO);
        boolean first = true;
        boolean lastWasAnnotation = false;
        while (!annotations.isEmpty() && !this.nextIsModifier()) {
            if (!first) {
                this.builder.addAll((List<Op>)(annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak)));
            }
            this.scan((Tree)annotations.removeFirst(), null);
            first = false;
            lastWasAnnotation = true;
        }
        this.builder.close();
        ImmutableList<Op> immutableList = trailingBreak = annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak);
        if (annotations.isEmpty() && !this.nextIsModifier()) {
            return trailingBreak;
        }
        if (lastWasAnnotation) {
            this.builder.addAll((List<Op>)trailingBreak);
        }
        this.builder.open(ZERO);
        first = true;
        while (this.nextIsModifier() || !annotations.isEmpty()) {
            if (!first) {
                this.builder.addAll((List<Op>)JavaInputAstVisitor.breakFillList((Optional<Output.BreakTag>)Optional.absent()));
            }
            if (this.nextIsModifier()) {
                this.token((String)this.builder.peekToken().get());
            } else {
                this.scan((Tree)annotations.removeFirst(), null);
                lastWasAnnotation = true;
            }
            first = false;
        }
        this.builder.close();
        return JavaInputAstVisitor.breakFillList((Optional<Output.BreakTag>)Optional.absent());
    }

    boolean nextIsModifier() {
        switch ((String)this.builder.peekToken().get()) {
            case "public": 
            case "protected": 
            case "private": 
            case "abstract": 
            case "static": 
            case "final": 
            case "transient": 
            case "volatile": 
            case "synchronized": 
            case "native": 
            case "strictfp": 
            case "default": {
                return true;
            }
        }
        return false;
    }

    public Void visitCatch(CatchTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into catch trees");
    }

    private void visitCatchClause(CatchTree node, AllowTrailingBlankLine allowTrailingBlankLine) {
        this.sync((Tree)node);
        this.builder.space();
        this.token("catch");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        VariableTree ex = node.getParameter();
        if (ex.getType().getKind() == Tree.Kind.UNION_TYPE) {
            this.builder.open(ZERO);
            this.visitUnionType(ex);
            this.builder.close();
        } else {
            this.builder.breakToFill();
            this.builder.open(ZERO);
            this.scan((Tree)ex, null);
            this.builder.close();
        }
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.visitBlock(node.getBlock(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, allowTrailingBlankLine);
    }

    private void visitUnionType(VariableTree declaration) {
        UnionTypeTree type = (UnionTypeTree)declaration.getType();
        this.builder.open(ZERO);
        this.sync((Tree)declaration);
        this.visitAndBreakModifiers(declaration.getModifiers(), Direction.HORIZONTAL, (Optional<Output.BreakTag>)Optional.absent());
        List union = type.getTypeAlternatives();
        boolean first = true;
        for (int i = 0; i < union.size() - 1; ++i) {
            if (!first) {
                this.builder.breakOp(" ");
                this.token("|");
                this.builder.space();
            } else {
                first = false;
            }
            this.scan((Tree)union.get(i), null);
        }
        this.builder.breakOp(" ");
        this.token("|");
        this.builder.space();
        Tree last = (Tree)union.get(union.size() - 1);
        this.declareOne(DeclarationKind.NONE, Direction.HORIZONTAL, (Optional<ModifiersTree>)Optional.absent(), last, VarArgsOrNot.NO, (List<? extends AnnotationTree>)ImmutableList.of(), declaration.getName(), "", "=", (Optional<ExpressionTree>)Optional.fromNullable((Object)declaration.getInitializer()), (Optional<String>)Optional.absent(), (Optional<ExpressionTree>)Optional.absent(), (Optional<DimensionHelpers.TypeWithDims>)Optional.absent());
        this.builder.close();
    }

    private static void walkInfix(int precedence, ExpressionTree expression, List<ExpressionTree> operands, List<String> operators) {
        if (expression instanceof BinaryTree) {
            BinaryTree binaryTree = (BinaryTree)expression;
            if (Trees.precedence((ExpressionTree)binaryTree) == precedence) {
                JavaInputAstVisitor.walkInfix(precedence, binaryTree.getLeftOperand(), operands, operators);
                operators.add(Trees.operatorName(expression));
                JavaInputAstVisitor.walkInfix(precedence, binaryTree.getRightOperand(), operands, operators);
            } else {
                operands.add(expression);
            }
        } else {
            operands.add(expression);
        }
    }

    private void visitFormals(Optional<VariableTree> receiver, List<? extends VariableTree> parameters) {
        if (!receiver.isPresent() && parameters.isEmpty()) {
            return;
        }
        this.builder.open(ZERO);
        boolean first = true;
        if (receiver.isPresent()) {
            this.declareOne(DeclarationKind.PARAMETER, Direction.HORIZONTAL, (Optional<ModifiersTree>)Optional.of((Object)((VariableTree)receiver.get()).getModifiers()), ((VariableTree)receiver.get()).getType(), VarArgsOrNot.NO, (List<? extends AnnotationTree>)ImmutableList.of(), ((VariableTree)receiver.get()).getName(), "", "", (Optional<ExpressionTree>)Optional.absent(), (Optional<String>)(!parameters.isEmpty() ? Optional.of((Object)",") : Optional.absent()), (Optional<ExpressionTree>)Optional.of((Object)((VariableTree)receiver.get()).getNameExpression()), (Optional<DimensionHelpers.TypeWithDims>)Optional.absent());
            first = false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            VariableTree parameter = parameters.get(i);
            if (!first) {
                this.builder.breakOp(" ");
            }
            this.visitToDeclare(DeclarationKind.PARAMETER, Direction.HORIZONTAL, parameter, (Optional<ExpressionTree>)Optional.absent(), "=", (Optional<String>)(i < parameters.size() - 1 ? Optional.of((Object)",") : Optional.absent()));
            first = false;
        }
        this.builder.close();
    }

    private void visitThrowsClause(List<? extends ExpressionTree> thrownExceptionTypes) {
        this.token("throws");
        this.builder.breakToFill(" ");
        boolean first = true;
        for (ExpressionTree expressionTree : thrownExceptionTypes) {
            if (!first) {
                this.token(",");
                this.builder.breakToFill(" ");
            }
            this.scan((Tree)expressionTree, null);
            first = false;
        }
    }

    public Void visitIdentifier(IdentifierTree node, Void unused) {
        this.sync((Tree)node);
        this.token(node.getName().toString());
        return null;
    }

    private void visitName(Tree node) {
        ArrayDeque<Name> stack = new ArrayDeque<Name>();
        while (node instanceof MemberSelectTree) {
            stack.addFirst(((MemberSelectTree)node).getIdentifier());
            node = ((MemberSelectTree)node).getExpression();
        }
        stack.addFirst(((IdentifierTree)node).getName());
        boolean first = true;
        for (Name name : stack) {
            if (!first) {
                this.token(".");
            }
            this.token(name.toString());
            first = false;
        }
    }

    private void visitToDeclare(DeclarationKind kind, Direction annotationsDirection, VariableTree node, Optional<ExpressionTree> initializer, String equals, Optional<String> trailing) {
        this.sync((Tree)node);
        boolean varargs = (((JCTree.JCVariableDecl)node).mods.flags & 0x400000000L) == 0x400000000L;
        Object varargsAnnotations = ImmutableList.of();
        Tree type = node.getType();
        if (varargs) {
            if (type instanceof AnnotatedTypeTree) {
                varargsAnnotations = ((AnnotatedTypeTree)type).getAnnotations();
                type = ((AnnotatedTypeTree)type).getUnderlyingType();
            }
            type = ((ArrayTypeTree)type).getType();
        }
        this.declareOne(kind, annotationsDirection, (Optional<ModifiersTree>)Optional.of((Object)node.getModifiers()), type, VarArgsOrNot.valueOf(varargs), (List<? extends AnnotationTree>)varargsAnnotations, node.getName(), "", equals, initializer, trailing, (Optional<ExpressionTree>)Optional.absent(), (Optional<DimensionHelpers.TypeWithDims>)Optional.absent());
    }

    private void typeParametersRest(List<? extends TypeParameterTree> typeParameters, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.builder.breakOp();
        this.builder.open(ZERO);
        boolean first = true;
        for (TypeParameterTree typeParameterTree : typeParameters) {
            if (!first) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)typeParameterTree, null);
            first = false;
        }
        this.token(">");
        this.builder.close();
        this.builder.close();
    }

    void visitDot(ExpressionTree node0) {
        ExpressionTree node = node0;
        ArrayDeque<ExpressionTree> stack = new ArrayDeque<ExpressionTree>();
        block12: do {
            stack.addFirst(node);
            if (node.getKind() == Tree.Kind.ARRAY_ACCESS) {
                node = this.getArrayBase(node);
            }
            switch (node.getKind()) {
                case MEMBER_SELECT: {
                    node = ((MemberSelectTree)node).getExpression();
                    break;
                }
                case METHOD_INVOCATION: {
                    node = this.getMethodReceiver((MethodInvocationTree)node);
                    break;
                }
                case IDENTIFIER: {
                    node = null;
                    break block12;
                }
                default: {
                    node = (ExpressionTree)stack.removeFirst();
                    break block12;
                }
            }
        } while (node != null);
        ArrayList<ExpressionTree> items = new ArrayList<ExpressionTree>(stack);
        boolean needDot = false;
        if (node != null) {
            if (node.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)node).getClassBody() != null) {
                this.builder.open(ZERO);
                this.scan((Tree)this.getArrayBase(node), null);
                this.token(".");
            } else {
                this.builder.open(this.plusFour);
                this.scan((Tree)this.getArrayBase(node), null);
                this.builder.breakOp();
                needDot = true;
            }
            this.formatArrayIndices(this.getArrayIndices(node));
            if (stack.isEmpty()) {
                this.builder.close();
                return;
            }
        }
        int prefixIndex = TypeNameClassifier.typePrefixLength(this.simpleNames(stack));
        int invocationCount = 0;
        int firstInvocationIndex = -1;
        for (int i = 0; i < items.size(); ++i) {
            ExpressionTree expression = (ExpressionTree)items.get(i);
            if (expression.getKind() != Tree.Kind.METHOD_INVOCATION) continue;
            if (i > 0 || node != null) {
                ++invocationCount;
            }
            if (firstInvocationIndex >= 0) continue;
            firstInvocationIndex = i;
        }
        if (invocationCount == 1) {
            prefixIndex = firstInvocationIndex;
        }
        if (prefixIndex == -1 && items.get(0) instanceof IdentifierTree) {
            switch (((IdentifierTree)items.get(0)).getName().toString()) {
                case "this": 
                case "super": {
                    prefixIndex = 1;
                    break;
                }
            }
        }
        if (prefixIndex > 0) {
            this.visitDotWithPrefix(items, needDot, prefixIndex);
        } else {
            this.visitRegularDot(items, needDot);
        }
        if (node != null) {
            this.builder.close();
        }
    }

    private void visitRegularDot(List<ExpressionTree> items, boolean needDot) {
        boolean trailingDereferences = items.size() > 1;
        boolean needDot0 = needDot;
        if (!needDot0) {
            this.builder.open(this.plusFour);
        }
        int minLength = this.indentMultiplier * 4;
        int length = needDot0 ? minLength : 0;
        for (ExpressionTree e : items) {
            if (needDot) {
                if (length > minLength) {
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO);
                }
                this.token(".");
                ++length;
            }
            if (!this.fillFirstArgument(e, items, trailingDereferences ? ZERO : this.minusFour)) {
                Output.BreakTag tyargTag = this.genSym();
                this.dotExpressionUpToArgs(e, (Optional<Output.BreakTag>)Optional.of((Object)tyargTag));
                Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
                this.dotExpressionArgsAndParen(e, tyargIndent, trailingDereferences || needDot ? this.plusFour : ZERO);
            }
            length += Trees.getLength((Tree)e, this.getCurrentPath());
            needDot = true;
        }
        if (!needDot0) {
            this.builder.close();
        }
    }

    private boolean fillFirstArgument(ExpressionTree e, List<ExpressionTree> items, Indent indent) {
        if (items.size() < 2) {
            return false;
        }
        if (e.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree methodInvocation = (MethodInvocationTree)e;
        Name name = Trees.getMethodName(methodInvocation);
        if (!(methodInvocation.getMethodSelect() instanceof IdentifierTree) || name.length() > 4 || !methodInvocation.getTypeArguments().isEmpty() || methodInvocation.getArguments().size() != 1) {
            return false;
        }
        this.builder.open(ZERO);
        this.builder.open(indent);
        this.visit(name);
        this.token("(");
        ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement((Iterable)methodInvocation.getArguments());
        this.scan((Tree)arg, null);
        this.builder.close();
        this.token(")");
        this.builder.close();
        return true;
    }

    private void visitDotWithPrefix(List<ExpressionTree> items, boolean needDot, int prefixIndex) {
        boolean trailingDereferences = prefixIndex >= 0 && prefixIndex < items.size() - 1;
        this.builder.open(this.plusFour);
        this.builder.open(trailingDereferences ? ZERO : ZERO);
        Output.BreakTag nameTag = this.genSym();
        for (int i = 0; i < items.size(); ++i) {
            ExpressionTree e = items.get(i);
            if (needDot) {
                Doc.FillMode fillMode = prefixIndex >= 0 && i <= prefixIndex ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
                this.builder.breakOp(fillMode, "", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)nameTag));
                this.token(".");
            }
            Output.BreakTag tyargTag = this.genSym();
            this.dotExpressionUpToArgs(e, (Optional<Output.BreakTag>)Optional.of((Object)tyargTag));
            if (prefixIndex >= 0 && i == prefixIndex) {
                this.builder.close();
            }
            Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
            Indent.If argsIndent = Indent.If.make(nameTag, this.plusFour, trailingDereferences ? this.plusFour : ZERO);
            this.dotExpressionArgsAndParen(e, tyargIndent, argsIndent);
            needDot = true;
        }
        this.builder.close();
    }

    private List<String> simpleNames(Deque<ExpressionTree> stack) {
        ImmutableList.Builder simpleNames = ImmutableList.builder();
        block5: for (ExpressionTree expression : stack) {
            boolean isArray = expression.getKind() == Tree.Kind.ARRAY_ACCESS;
            expression = this.getArrayBase(expression);
            switch (expression.getKind()) {
                case MEMBER_SELECT: {
                    simpleNames.add((Object)((MemberSelectTree)expression).getIdentifier().toString());
                    break;
                }
                case IDENTIFIER: {
                    simpleNames.add((Object)((IdentifierTree)expression).getName().toString());
                    break;
                }
                case METHOD_INVOCATION: {
                    simpleNames.add((Object)Trees.getMethodName((MethodInvocationTree)expression).toString());
                    break block5;
                }
                default: {
                    break block5;
                }
            }
            if (!isArray) continue;
            break;
        }
        return simpleNames.build();
    }

    private void dotExpressionUpToArgs(ExpressionTree expression, Optional<Output.BreakTag> tyargTag) {
        expression = this.getArrayBase(expression);
        switch (expression.getKind()) {
            case MEMBER_SELECT: {
                MemberSelectTree fieldAccess = (MemberSelectTree)expression;
                this.visit(fieldAccess.getIdentifier());
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)expression;
                if (!methodInvocation.getTypeArguments().isEmpty()) {
                    this.builder.open(this.plusFour);
                    this.addTypeArguments(methodInvocation.getTypeArguments(), ZERO);
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO, tyargTag);
                    this.builder.close();
                }
                this.visit(Trees.getMethodName(methodInvocation));
                break;
            }
            case IDENTIFIER: {
                this.visit(((IdentifierTree)expression).getName());
                break;
            }
            default: {
                this.scan((Tree)expression, null);
            }
        }
    }

    private ExpressionTree getArrayBase(ExpressionTree node) {
        while (node instanceof ArrayAccessTree) {
            node = ((ArrayAccessTree)node).getExpression();
        }
        return node;
    }

    private ExpressionTree getMethodReceiver(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        return select instanceof MemberSelectTree ? ((MemberSelectTree)select).getExpression() : null;
    }

    private void dotExpressionArgsAndParen(ExpressionTree expression, Indent tyargIndent, Indent indent) {
        Deque<ExpressionTree> indices = this.getArrayIndices(expression);
        expression = this.getArrayBase(expression);
        switch (expression.getKind()) {
            case METHOD_INVOCATION: {
                this.builder.open(tyargIndent);
                MethodInvocationTree methodInvocation = (MethodInvocationTree)expression;
                this.addArguments(methodInvocation.getArguments(), indent);
                this.builder.close();
                break;
            }
        }
        this.formatArrayIndices(indices);
    }

    private void formatArrayIndices(Deque<ExpressionTree> indices) {
        if (indices.isEmpty()) {
            return;
        }
        this.builder.open(ZERO);
        do {
            this.token("[");
            this.builder.breakToFill();
            this.scan((Tree)indices.removeLast(), null);
            this.token("]");
        } while (!indices.isEmpty());
        this.builder.close();
    }

    private Deque<ExpressionTree> getArrayIndices(ExpressionTree expression) {
        ArrayDeque<ExpressionTree> indices = new ArrayDeque<ExpressionTree>();
        while (expression instanceof ArrayAccessTree) {
            ArrayAccessTree array = (ArrayAccessTree)expression;
            indices.addLast(array.getIndex());
            expression = array.getExpression();
        }
        return indices;
    }

    void addTypeArguments(List<? extends Tree> typeArguments, Indent plusIndent) {
        if (typeArguments == null || typeArguments.isEmpty()) {
            return;
        }
        this.token("<");
        this.builder.open(plusIndent);
        boolean first = true;
        for (Tree tree : typeArguments) {
            if (!first) {
                this.token(",");
                this.builder.breakToFill(" ");
            }
            this.scan(tree, null);
            first = false;
        }
        this.builder.close();
        this.token(">");
    }

    void addArguments(List<? extends ExpressionTree> arguments, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.token("(");
        if (!arguments.isEmpty()) {
            if (arguments.size() % 2 == 0 && this.argumentsAreTabular(arguments) == 2) {
                this.builder.forcedBreak();
                this.builder.open(ZERO);
                boolean first = true;
                for (int i = 0; i < arguments.size() - 1; i += 2) {
                    ExpressionTree argument0 = arguments.get(i);
                    ExpressionTree argument1 = arguments.get(i + 1);
                    if (!first) {
                        this.token(",");
                        this.builder.forcedBreak();
                    }
                    this.builder.open(this.plusFour);
                    this.scan((Tree)argument0, null);
                    this.token(",");
                    this.builder.breakOp(" ");
                    this.scan((Tree)argument1, null);
                    this.builder.close();
                    first = false;
                }
                this.builder.close();
            } else if (this.isFormatMethod(arguments)) {
                this.builder.breakOp();
                this.builder.open(ZERO);
                this.scan((Tree)arguments.get(0), null);
                this.token(",");
                this.builder.breakOp(" ");
                this.builder.open(ZERO);
                this.argList(arguments.subList(1, arguments.size()));
                this.builder.close();
                this.builder.close();
            } else {
                this.builder.breakOp();
                this.argList(arguments);
            }
        }
        this.token(")");
        this.builder.close();
    }

    private void argList(List<? extends ExpressionTree> arguments) {
        this.builder.open(ZERO);
        boolean first = true;
        Doc.FillMode fillMode = this.hasOnlyShortItems(arguments) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        for (ExpressionTree expressionTree : arguments) {
            if (!first) {
                this.token(",");
                this.builder.breakOp(fillMode, " ", ZERO);
            }
            this.scan((Tree)expressionTree, null);
            first = false;
        }
        this.builder.close();
    }

    private boolean isFormatMethod(List<? extends ExpressionTree> arguments) {
        if (arguments.size() < 2) {
            return false;
        }
        return this.isStringConcat(arguments.get(0));
    }

    private boolean isStringConcat(ExpressionTree first) {
        final boolean[] stringLiteral = new boolean[]{true};
        final boolean[] formatString = new boolean[]{false};
        new TreeScanner(){

            public void scan(JCTree tree) {
                Object value;
                if (tree == null) {
                    return;
                }
                switch (tree.getKind()) {
                    case STRING_LITERAL: {
                        break;
                    }
                    case PLUS: {
                        super.scan(tree);
                        break;
                    }
                    default: {
                        stringLiteral[0] = false;
                    }
                }
                if (tree.getKind() == Tree.Kind.STRING_LITERAL && (value = ((LiteralTree)tree).getValue()) instanceof String && FORMAT_SPECIFIER.matcher(value.toString()).find()) {
                    formatString[0] = true;
                }
            }
        }.scan((JCTree)first);
        return stringLiteral[0] && formatString[0];
    }

    private int argumentsAreTabular(List<? extends ExpressionTree> arguments) {
        int i;
        if (arguments.isEmpty()) {
            return -1;
        }
        ArrayList<List<ExpressionTree>> rows = new ArrayList<List<ExpressionTree>>();
        PeekingIterator it = Iterators.peekingIterator(arguments.iterator());
        int start0 = this.actualColumn((ExpressionTree)it.peek());
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(it.next());
        while (it.hasNext() && this.actualColumn((ExpressionTree)it.peek()) > start0) {
            row.add(it.next());
        }
        if (!it.hasNext() || row.size() == 1) {
            return -1;
        }
        rows.add(row);
        while (it.hasNext()) {
            row = new ArrayList();
            int start = this.actualColumn((ExpressionTree)it.peek());
            if (start != start0) {
                return -1;
            }
            row.add(it.next());
            while (it.hasNext() && this.actualColumn((ExpressionTree)it.peek()) > start0) {
                row.add(it.next());
            }
            rows.add(row);
        }
        int size0 = ((List)rows.get(0)).size();
        if (!JavaInputAstVisitor.expressionsAreParallel(rows, 0, rows.size())) {
            return -1;
        }
        for (i = 1; i < size0; ++i) {
            if (JavaInputAstVisitor.expressionsAreParallel(rows, i, rows.size() / 2 + 1)) continue;
            return -1;
        }
        if (rows.size() == 2) {
            if (size0 == ((List)rows.get(1)).size()) {
                return size0;
            }
            return -1;
        }
        for (i = 1; i < rows.size() - 1; ++i) {
            if (size0 == ((List)rows.get(i)).size()) continue;
            return -1;
        }
        if (size0 < ((List)Iterables.getLast(rows)).size()) {
            return -1;
        }
        return size0;
    }

    private Integer actualColumn(ExpressionTree expression) {
        ImmutableMap<Integer, Integer> positionToColumnMap = this.builder.getInput().getPositionToColumnMap();
        return (Integer)positionToColumnMap.get(this.builder.actualStartColumn(Trees.getStartPosition((Tree)expression)));
    }

    private static boolean expressionsAreParallel(List<List<ExpressionTree>> rows, int column, int atLeastM) {
        HashMultiset nodeTypes = HashMultiset.create();
        for (List<ExpressionTree> row : rows) {
            if (column >= row.size()) continue;
            nodeTypes.add((Object)row.get(column).getKind());
        }
        for (Multiset.Entry nodeType : nodeTypes.entrySet()) {
            if (nodeType.getCount() < atLeastM) continue;
            return true;
        }
        return false;
    }

    int declareOne(DeclarationKind kind, Direction annotationsDirection, Optional<ModifiersTree> modifiers, Tree type, VarArgsOrNot isVarargs, List<? extends AnnotationTree> varargsAnnotations, Name name, String op, String equals, Optional<ExpressionTree> initializer, Optional<String> trailing, Optional<ExpressionTree> receiverExpression, Optional<DimensionHelpers.TypeWithDims> typeWithDims) {
        boolean isField;
        Output.BreakTag typeBreak = this.genSym();
        Output.BreakTag verticalAnnotationBreak = this.genSym();
        boolean bl = isField = kind == DeclarationKind.FIELD;
        if (isField) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
        }
        ArrayDeque<List<AnnotationTree>> dims = new ArrayDeque<List<AnnotationTree>>((Collection<List<AnnotationTree>>)(typeWithDims.isPresent() ? ((DimensionHelpers.TypeWithDims)typeWithDims.get()).dims : Collections.emptyList()));
        int baseDims = 0;
        this.builder.open(kind == DeclarationKind.PARAMETER && modifiers.isPresent() && !((ModifiersTree)modifiers.get()).getAnnotations().isEmpty() ? this.plusFour : ZERO);
        if (modifiers.isPresent()) {
            this.visitAndBreakModifiers((ModifiersTree)modifiers.get(), annotationsDirection, (Optional<Output.BreakTag>)Optional.of((Object)verticalAnnotationBreak));
        }
        this.builder.open(type != null ? this.plusFour : ZERO);
        this.builder.open(ZERO);
        this.builder.open(ZERO);
        if (typeWithDims.isPresent() && ((DimensionHelpers.TypeWithDims)typeWithDims.get()).node != null) {
            this.scan(((DimensionHelpers.TypeWithDims)typeWithDims.get()).node, null);
            int totalDims = dims.size();
            this.builder.open(this.plusFour);
            this.maybeAddDims(dims);
            this.builder.close();
            baseDims = totalDims - dims.size();
        } else {
            this.scan(type, null);
        }
        if (isVarargs.isYes()) {
            this.visitAnnotations(varargsAnnotations, BreakOrNot.YES, BreakOrNot.YES);
            this.builder.op("...");
        }
        this.builder.close();
        if (type != null) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)typeBreak));
        }
        this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
        if (receiverExpression.isPresent()) {
            this.scan((Tree)receiverExpression.get(), null);
        } else {
            this.visit(name);
        }
        this.builder.op(op);
        this.maybeAddDims(dims);
        this.builder.close();
        this.builder.close();
        if (initializer.isPresent()) {
            this.builder.space();
            this.token(equals);
            if (((ExpressionTree)initializer.get()).getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)initializer.get()).getType() == null) {
                this.builder.open(this.minusFour);
                this.builder.space();
                ((ExpressionTree)initializer.get()).accept((TreeVisitor)this, null);
                this.builder.close();
            } else {
                this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
                this.builder.breakToFill(" ");
                this.scan((Tree)initializer.get(), null);
                this.builder.close();
            }
        }
        if (trailing.isPresent() && this.builder.peekToken().equals(trailing)) {
            this.builder.guessToken((String)trailing.get());
        }
        this.builder.close();
        this.builder.close();
        if (isField) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
        }
        return baseDims;
    }

    private void maybeAddDims(Deque<List<AnnotationTree>> annotations) {
        this.maybeAddDims(new ArrayDeque<ExpressionTree>(), annotations);
    }

    private void maybeAddDims(Deque<ExpressionTree> dimExpressions, Deque<List<AnnotationTree>> annotations) {
        boolean lastWasAnnotation = false;
        block8: while (this.builder.peekToken().isPresent()) {
            switch ((String)this.builder.peekToken().get()) {
                case "@": {
                    if (annotations.isEmpty()) {
                        return;
                    }
                    List<AnnotationTree> dimAnnotations = annotations.removeFirst();
                    if (dimAnnotations.isEmpty()) continue block8;
                    this.builder.breakToFill(" ");
                    this.visitAnnotations(dimAnnotations, BreakOrNot.NO, BreakOrNot.NO);
                    lastWasAnnotation = true;
                    continue block8;
                }
                case "[": {
                    if (lastWasAnnotation) {
                        this.builder.breakToFill(" ");
                    } else {
                        this.builder.breakToFill();
                    }
                    this.token("[");
                    if (!((String)this.builder.peekToken().get()).equals("]")) {
                        this.scan((Tree)dimExpressions.removeFirst(), null);
                    }
                    this.token("]");
                    lastWasAnnotation = false;
                    continue block8;
                }
            }
            return;
        }
    }

    private void declareMany(List<VariableTree> fragments, Direction annotationDirection) {
        this.builder.open(ZERO);
        ModifiersTree modifiers = fragments.get(0).getModifiers();
        Tree type = fragments.get(0).getType();
        this.visitAndBreakModifiers(modifiers, annotationDirection, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(this.plusFour);
        this.builder.open(ZERO);
        DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.YES);
        ArrayDeque<List<AnnotationTree>> dims = new ArrayDeque<List<AnnotationTree>>((Collection<List<AnnotationTree>>)extractedDims.dims);
        this.scan(extractedDims.node, null);
        int baseDims = dims.size();
        this.maybeAddDims(dims);
        baseDims -= dims.size();
        boolean first = true;
        for (VariableTree fragment : fragments) {
            if (!first) {
                this.token(",");
            }
            DimensionHelpers.TypeWithDims fragmentDims = this.variableFragmentDims(first, baseDims, fragment.getType());
            dims = new ArrayDeque<List<AnnotationTree>>((Collection<List<AnnotationTree>>)fragmentDims.dims);
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            this.maybeAddDims(dims);
            this.visit(fragment.getName());
            this.maybeAddDims(dims);
            ExpressionTree initializer = fragment.getInitializer();
            if (initializer != null) {
                this.builder.space();
                this.token("=");
                this.builder.open(this.plusFour);
                this.builder.breakOp(" ");
                this.scan((Tree)initializer, null);
                this.builder.close();
            }
            this.builder.close();
            if (first) {
                this.builder.close();
            }
            first = false;
        }
        this.builder.close();
        this.token(";");
        this.builder.close();
    }

    void addBodyDeclarations(List<? extends Tree> bodyDeclarations, BracesOrNot braces, FirstDeclarationsOrNot first0) {
        if (bodyDeclarations.isEmpty()) {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.builder.open(ZERO);
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        } else {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.open(ZERO);
            }
            this.builder.open(this.plusTwo);
            boolean first = first0.isYes();
            boolean lastOneGotBlankLineBefore = false;
            PeekingIterator it = Iterators.peekingIterator(bodyDeclarations.iterator());
            while (it.hasNext()) {
                boolean thisOneGetsBlankLineBefore;
                Tree bodyDeclaration = (Tree)it.next();
                this.dropEmptyDeclarations();
                this.builder.forcedBreak();
                boolean bl = thisOneGetsBlankLineBefore = bodyDeclaration.getKind() != Tree.Kind.VARIABLE || this.hasJavaDoc(bodyDeclaration);
                if (first) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                } else if (!first && (thisOneGetsBlankLineBefore || lastOneGotBlankLineBefore)) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
                }
                this.markForPartialFormat();
                if (bodyDeclaration.getKind() == Tree.Kind.VARIABLE) {
                    this.visitVariables(this.variableFragments((PeekingIterator<? extends Tree>)it, bodyDeclaration), DeclarationKind.FIELD, this.fieldAnnotationDirection(((VariableTree)bodyDeclaration).getModifiers()));
                } else {
                    this.scan(bodyDeclaration, null);
                }
                first = false;
                lastOneGotBlankLineBefore = thisOneGetsBlankLineBefore;
            }
            this.dropEmptyDeclarations();
            this.builder.forcedBreak();
            this.builder.close();
            this.builder.forcedBreak();
            this.markForPartialFormat();
            if (braces.isYes()) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        }
    }

    private List<VariableTree> variableFragments(PeekingIterator<? extends Tree> it, Tree first) {
        ArrayList<VariableTree> fragments = new ArrayList<VariableTree>();
        if (first.getKind() == Tree.Kind.VARIABLE) {
            int start = Trees.getStartPosition(first);
            fragments.add((VariableTree)first);
            while (it.hasNext() && ((Tree)it.peek()).getKind() == Tree.Kind.VARIABLE && Trees.getStartPosition((Tree)it.peek()) == start) {
                fragments.add((VariableTree)it.next());
            }
        }
        return fragments;
    }

    private boolean hasJavaDoc(Tree bodyDeclaration) {
        int position = ((JCTree)bodyDeclaration).getStartPosition();
        Input.Token token = (Input.Token)this.builder.getInput().getPositionTokenMap().get((Comparable)Integer.valueOf(position));
        if (token != null) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (!tok.getText().startsWith("/**")) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<? extends Input.Token> getNextToken(Input input, int position) {
        return Optional.fromNullable((Object)input.getPositionTokenMap().get((Comparable)Integer.valueOf(position)));
    }

    private boolean hasTrailingToken(Input input, List<? extends Tree> nodes, String token) {
        if (nodes.isEmpty()) {
            return false;
        }
        Tree lastNode = (Tree)Iterables.getLast(nodes);
        Optional<? extends Input.Token> nextToken = JavaInputAstVisitor.getNextToken(input, Trees.getEndPosition(lastNode, this.getCurrentPath()));
        return nextToken.isPresent() && ((Input.Token)nextToken.get()).getTok().getText().equals(token);
    }

    private Direction canLocalHaveHorizontalAnnotations(ModifiersTree modifiers) {
        int markerAnnotations = 0;
        for (AnnotationTree annotation : modifiers.getAnnotations()) {
            if (!annotation.getArguments().isEmpty()) continue;
            ++markerAnnotations;
        }
        return markerAnnotations <= 1 && markerAnnotations == modifiers.getAnnotations().size() ? Direction.HORIZONTAL : Direction.VERTICAL;
    }

    private Direction fieldAnnotationDirection(ModifiersTree modifiers) {
        for (AnnotationTree annotation : modifiers.getAnnotations()) {
            if (annotation.getArguments().isEmpty()) continue;
            return Direction.VERTICAL;
        }
        return Direction.HORIZONTAL;
    }

    final void token(String token) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, ZERO, (Optional<Indent>)Optional.absent());
    }

    final void token(String token, Indent plusIndentCommentsBefore) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, plusIndentCommentsBefore, (Optional<Indent>)Optional.absent());
    }

    final void tokenBreakTrailingComment(String token, Indent breakAndIndentTrailingComment) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, ZERO, (Optional<Indent>)Optional.of((Object)breakAndIndentTrailingComment));
    }

    private void markForPartialFormat() {
        if (!this.inExpression()) {
            this.builder.markForPartialFormat();
        }
    }

    final void sync(Tree node) {
        this.builder.sync(((JCTree)node).getStartPosition());
    }

    final Output.BreakTag genSym() {
        return new Output.BreakTag();
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("builder", (Object)this.builder).toString();
    }

    static enum DeclarationKind {
        NONE,
        FIELD,
        PARAMETER;

    }

    static enum FirstDeclarationsOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum ReceiverParameter {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum VarArgsOrNot {
        YES,
        NO;


        static VarArgsOrNot valueOf(boolean b) {
            return b ? YES : NO;
        }

        boolean isYes() {
            return this == YES;
        }
    }

    static enum DimensionsOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum BracesOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum AllowTrailingBlankLine {
        YES,
        NO;


        static AllowTrailingBlankLine valueOf(boolean b) {
            return b ? YES : NO;
        }
    }

    static enum AllowLeadingBlankLine {
        YES,
        NO;


        static AllowLeadingBlankLine valueOf(boolean b) {
            return b ? YES : NO;
        }
    }

    static enum CollapseEmptyOrNot {
        YES,
        NO;


        static CollapseEmptyOrNot valueOf(boolean b) {
            return b ? YES : NO;
        }

        boolean isYes() {
            return this == YES;
        }
    }

    static enum BreakOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum Direction {
        VERTICAL,
        HORIZONTAL;


        boolean isVertical() {
            return this == VERTICAL;
        }
    }
}

