/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;

class ClosureRewriteClass
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType GOOG_CLASS_TARGET_INVALID = DiagnosticType.error("JSC_GOOG_CLASS_TARGET_INVALID", "Unsupported class definition expression.");
    static final DiagnosticType GOOG_CLASS_SUPER_CLASS_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_SUPER_CLASS_NOT_VALID", "The super class must be null or a valid name reference");
    static final DiagnosticType GOOG_CLASS_DESCRIPTOR_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_DESCRIPTOR_NOT_VALID", "The class descriptor must be an object literal");
    static final DiagnosticType GOOG_CLASS_CONSTRUCTOR_MISING = DiagnosticType.error("JSC_GOOG_CLASS_CONSTRUCTOR_MISING", "The constructor expression is missing for the class descriptor");
    static final DiagnosticType GOOG_CLASS_STATICS_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_STATICS_NOT_VALID", "The class statics descriptor must be an object or function literal");
    static final DiagnosticType GOOG_CLASS_UNEXPECTED_PARAMS = DiagnosticType.error("JSC_GOOG_CLASS_UNEXPECTED_PARAMS", "The class definition has too many arguments.");
    private final AbstractCompiler compiler;

    public ClosureRewriteClass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process(this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isCall() && this.isGoogDefineClass(n) && !this.validateUsage(n)) {
            this.compiler.report(JSError.make(n, GOOG_CLASS_TARGET_INVALID, new String[0]));
        }
        this.maybeRewriteClassDefinition(n);
    }

    private boolean validateUsage(Node n) {
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 38: {
                return true;
            }
            case 86: {
                return n == parent.getLastChild() && parent.getParent().isExprResult();
            }
            case 154: {
                return this.isContainedInGoogDefineClass(parent);
            }
        }
        return false;
    }

    private boolean isContainedInGoogDefineClass(Node n) {
        while (n != null) {
            if ((n = n.getParent()).isCall()) {
                if (!this.isGoogDefineClass(n)) continue;
                return true;
            }
            if (n.isObjectLit() || n.isStringKey()) continue;
            break;
        }
        return false;
    }

    private void maybeRewriteClassDefinition(Node n) {
        if (n.isVar()) {
            Node target = n.getFirstChild();
            Node value = target.getFirstChild();
            this.maybeRewriteClassDefinition(n, target, value);
        } else if (NodeUtil.isExprAssign(n)) {
            Node assign = n.getFirstChild();
            Node target = assign.getFirstChild();
            Node value = assign.getLastChild();
            this.maybeRewriteClassDefinition(n, target, value);
        }
    }

    private void maybeRewriteClassDefinition(Node n, Node target, Node value) {
        if (this.isGoogDefineClass(value)) {
            ClassDefinition def;
            if (!target.isQualifiedName()) {
                this.compiler.report(JSError.make(n, GOOG_CLASS_TARGET_INVALID, new String[0]));
            }
            if ((def = this.extractClassDefinition(target, value)) != null) {
                value.detachFromParent();
                target.detachFromParent();
                this.rewriteGoogDefineClass(n, def);
            }
        }
    }

    private ClassDefinition extractClassDefinition(Node targetName, Node callNode) {
        Node description;
        Node superClass = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (superClass == null || !superClass.isNull() && !superClass.isQualifiedName()) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_SUPER_CLASS_NOT_VALID, new String[0]));
            return null;
        }
        if (NodeUtil.isNullOrUndefined(superClass)) {
            superClass = null;
        }
        if ((description = NodeUtil.getArgumentForCallOrNew(callNode, 1)) == null || !description.isObjectLit() || !this.validateObjLit(description)) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount > 2) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node constructor = this.extractProperty(description, "constructor");
        if (constructor == null) {
            this.compiler.report(JSError.make(description, GOOG_CLASS_CONSTRUCTOR_MISING, new String[0]));
            return null;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(constructor);
        Node classModifier = null;
        Node statics = null;
        Node staticsProp = this.extractProperty(description, "statics");
        if (staticsProp != null) {
            if (staticsProp.isObjectLit() && this.validateObjLit(staticsProp)) {
                statics = staticsProp;
            } else if (staticsProp.isFunction()) {
                classModifier = staticsProp;
            } else {
                this.compiler.report(JSError.make(staticsProp, GOOG_CLASS_STATICS_NOT_VALID, new String[0]));
                return null;
            }
        }
        if (statics == null) {
            statics = IR.objectlit(new Node[0]);
        }
        this.maybeDetach(constructor.getParent());
        this.maybeDetach(statics.getParent());
        if (classModifier != null) {
            this.maybeDetach(classModifier.getParent());
        }
        ClassDefinition def = new ClassDefinition(targetName, this.maybeDetach(superClass), new MemberDefinition(info, null, this.maybeDetach(constructor)), this.objectLitToList(this.maybeDetach(statics)), this.objectLitToList(description), this.maybeDetach(classModifier));
        return def;
    }

    private Node maybeDetach(Node node) {
        if (node != null && node.getParent() != null) {
            node.detachFromParent();
        }
        return node;
    }

    private boolean validateObjLit(Node objlit) {
        for (Node key : objlit.children()) {
            if (key.isStringKey() && !key.isQuotedString()) continue;
            return false;
        }
        return true;
    }

    private Node extractProperty(Node objlit, String keyName) {
        for (Node keyNode : objlit.children()) {
            if (!keyNode.getString().equals(keyName)) continue;
            return keyNode.isStringKey() ? keyNode.getFirstChild() : null;
        }
        return null;
    }

    private List<MemberDefinition> objectLitToList(Node objlit) {
        ArrayList result = Lists.newArrayList();
        for (Node keyNode : objlit.children()) {
            result.add(new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.removeFirstChild()));
        }
        objlit.detachChildren();
        return result;
    }

    private void rewriteGoogDefineClass(Node exprRoot, ClassDefinition cls) {
        Node block = IR.block();
        if (exprRoot.isVar()) {
            block.addChildToBack(IR.var(cls.name.cloneTree(), cls.constructor.value).srcref(exprRoot).setJSDocInfo(cls.constructor.info));
        } else {
            block.addChildToBack(this.fixupSrcref(IR.exprResult(IR.assign(cls.name.cloneTree(), cls.constructor.value).srcref(exprRoot).setJSDocInfo(cls.constructor.info).srcref(exprRoot))).setJSDocInfo(cls.constructor.info));
        }
        if (cls.superClass != null) {
            block.addChildToBack(this.fixupSrcref(IR.exprResult(IR.call(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), "goog.inherits").srcrefTree(cls.superClass), cls.name.cloneTree(), cls.superClass.cloneTree()).srcref(cls.superClass))));
        }
        for (MemberDefinition def : cls.staticProps) {
            block.addChildToBack(this.fixupSrcref(IR.exprResult(this.fixupSrcref(IR.assign(IR.getprop(cls.name.cloneTree(), IR.string(def.name.getString()).srcref(def.name)).srcref(def.name), def.value)).setJSDocInfo(def.info))));
            this.maybeRewriteClassDefinition(block.getLastChild());
        }
        for (MemberDefinition def : cls.props) {
            block.addChildToBack(this.fixupSrcref(IR.exprResult(this.fixupSrcref(IR.assign(IR.getprop(this.fixupSrcref(IR.getprop(cls.name.cloneTree(), IR.string("prototype").srcref(def.name))), IR.string(def.name.getString()).srcref(def.name)).srcref(def.name), def.value)).setJSDocInfo(def.info))));
            this.maybeRewriteClassDefinition(block.getLastChild());
        }
        if (cls.classModifier != null) {
            block.addChildToBack(IR.exprResult(this.fixupFreeCall(IR.call(cls.classModifier, cls.name.cloneTree()).srcref(cls.classModifier))).srcref(cls.classModifier));
        }
        exprRoot.getParent().replaceChild(exprRoot, block);
        this.compiler.reportCodeChange();
    }

    private Node fixupSrcref(Node node) {
        node.srcref(node.getFirstChild());
        return node;
    }

    private Node fixupFreeCall(Node call) {
        Preconditions.checkState((boolean)call.isCall());
        call.putBooleanProp(50, true);
        return call;
    }

    private boolean isGoogDefineClass(Node value) {
        if (value != null && value.isCall()) {
            String targetName = value.getFirstChild().getQualifiedName();
            return "goog.defineClass".equals(targetName) || "goog.labs.classdef.defineClass".equals(targetName);
        }
        return false;
    }

    private final class ClassDefinition {
        final Node name;
        final Node superClass;
        final MemberDefinition constructor;
        final List<MemberDefinition> staticProps;
        final List<MemberDefinition> props;
        final Node classModifier;

        ClassDefinition(Node name, Node superClass, MemberDefinition constructor, List<MemberDefinition> staticProps, List<MemberDefinition> props, Node classModifier) {
            this.name = name;
            this.superClass = superClass;
            this.constructor = constructor;
            this.staticProps = staticProps;
            this.props = props;
            this.classModifier = classModifier;
        }
    }

    private static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }
    }
}

