/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FindExportableNodes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

class GenerateExports
implements CompilerPass {
    private static final String PROTOTYPE_PROPERTY = "prototype";
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;
    private final boolean allowNonGlobalExports;

    GenerateExports(AbstractCompiler compiler, boolean allowNonGlobalExports, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        Preconditions.checkNotNull((Object)exportSymbolFunction);
        Preconditions.checkNotNull((Object)exportPropertyFunction);
        this.compiler = compiler;
        this.allowNonGlobalExports = allowNonGlobalExports;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        FindExportableNodes findExportableNodes = new FindExportableNodes(this.compiler, this.allowNonGlobalExports);
        NodeTraversal.traverse(this.compiler, root, findExportableNodes);
        LinkedHashMap<String, FindExportableNodes.GenerateNodeContext> exports = findExportableNodes.getExports();
        for (Map.Entry entry : exports.entrySet()) {
            String export = (String)entry.getKey();
            FindExportableNodes.GenerateNodeContext context = (FindExportableNodes.GenerateNodeContext)entry.getValue();
            if (context.getMode() == FindExportableNodes.Mode.EXPORT) {
                this.addExportMethod(exports, export, context);
                continue;
            }
            if (context.getMode() != FindExportableNodes.Mode.EXTERN) continue;
            this.addExtern(export);
        }
    }

    private Node qualifiedNameNode(String qname) {
        return NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), qname);
    }

    private void addExtern(String export) {
        Node propstmt = IR.exprResult(IR.getprop(this.qualifiedNameNode("Object.prototype"), IR.string(export)));
        this.getSynthesizedExternsRoot().addChildToBack(propstmt);
        this.compiler.reportCodeChange();
    }

    private void addExportMethod(Map<String, FindExportableNodes.GenerateNodeContext> exports, String export, FindExportableNodes.GenerateNodeContext context) {
        Node call;
        CodingConvention convention = this.compiler.getCodingConvention();
        String parent = null;
        String grandparent = null;
        Node node = context.getNode().getFirstChild();
        if (node.isGetProp()) {
            Node parentNode = node.getFirstChild();
            parent = parentNode.getQualifiedName();
            if (parentNode.isGetProp() && parentNode.getLastChild().getString().equals(PROTOTYPE_PROPERTY)) {
                grandparent = parentNode.getFirstChild().getQualifiedName();
            }
        }
        boolean useExportSymbol = true;
        if (grandparent != null && exports.containsKey(grandparent)) {
            useExportSymbol = false;
        } else if (parent != null && exports.containsKey(parent)) {
            useExportSymbol = false;
        }
        if (useExportSymbol) {
            call = IR.call(NodeUtil.newQualifiedNameNode(convention, this.exportSymbolFunction, context.getNode(), export), IR.string(export), NodeUtil.newQualifiedNameNode(convention, export, context.getNode(), export));
        } else {
            String property = this.getPropertyName(node);
            call = IR.call(NodeUtil.newQualifiedNameNode(convention, this.exportPropertyFunction, context.getNode(), this.exportPropertyFunction), NodeUtil.newQualifiedNameNode(convention, parent, context.getNode(), this.exportPropertyFunction), IR.string(property), NodeUtil.newQualifiedNameNode(convention, export, context.getNode(), this.exportPropertyFunction));
        }
        Node expression = IR.exprResult(call);
        this.annotate(expression);
        this.addStatement(context, expression);
        this.compiler.reportCodeChange();
    }

    private void addStatement(FindExportableNodes.GenerateNodeContext context, Node stmt) {
        Node next;
        Node n;
        CodingConvention convention = this.compiler.getCodingConvention();
        Node exprRoot = n = context.getNode();
        while (!NodeUtil.isStatementBlock(exprRoot.getParent())) {
            exprRoot = exprRoot.getParent();
        }
        while ((next = exprRoot.getNext()) != null && NodeUtil.isExprCall(next) && convention.getClassesDefinedByCall(next.getFirstChild()) != null) {
            exprRoot = next;
        }
        Node block = exprRoot.getParent();
        block.addChildAfter(stmt, exprRoot);
    }

    private void annotate(Node node) {
        NodeTraversal.traverse(this.compiler, node, new PrepareAst.PrepareAnnotations());
    }

    private String getPropertyName(Node node) {
        Preconditions.checkArgument((boolean)node.isGetProp());
        return node.getLastChild().getString();
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }
}

