/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ModuleImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadPatternElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import java.util.List;

public class ParseTreeVisitor {
    protected void visitAny(ParseTree tree) {
        if (tree == null) {
            return;
        }
        switch (tree.type) {
            case ARGUMENT_LIST: {
                this.visit(tree.asArgumentList());
                break;
            }
            case ARRAY_LITERAL_EXPRESSION: {
                this.visit(tree.asArrayLiteralExpression());
                break;
            }
            case ARRAY_PATTERN: {
                this.visit(tree.asArrayPattern());
                break;
            }
            case BINARY_OPERATOR: {
                this.visit(tree.asBinaryOperator());
                break;
            }
            case BLOCK: {
                this.visit(tree.asBlock());
                break;
            }
            case BREAK_STATEMENT: {
                this.visit(tree.asBreakStatement());
                break;
            }
            case CALL_EXPRESSION: {
                this.visit(tree.asCallExpression());
                break;
            }
            case CASE_CLAUSE: {
                this.visit(tree.asCaseClause());
                break;
            }
            case CATCH: {
                this.visit(tree.asCatch());
                break;
            }
            case CLASS_DECLARATION: {
                this.visit(tree.asClassDeclaration());
                break;
            }
            case COMMA_EXPRESSION: {
                this.visit(tree.asCommaExpression());
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                this.visit(tree.asConditionalExpression());
                break;
            }
            case CONTINUE_STATEMENT: {
                this.visit(tree.asContinueStatement());
                break;
            }
            case DEBUGGER_STATEMENT: {
                this.visit(tree.asDebuggerStatement());
                break;
            }
            case DEFAULT_CLAUSE: {
                this.visit(tree.asDefaultClause());
                break;
            }
            case DEFAULT_PARAMETER: {
                this.visit(tree.asDefaultParameter());
                break;
            }
            case DO_WHILE_STATEMENT: {
                this.visit(tree.asDoWhileStatement());
                break;
            }
            case EMPTY_STATEMENT: {
                this.visit(tree.asEmptyStatement());
                break;
            }
            case EXPORT_DECLARATION: {
                this.visit(tree.asExportDeclaration());
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.visit(tree.asExpressionStatement());
                break;
            }
            case FINALLY: {
                this.visit(tree.asFinally());
                break;
            }
            case FOR_OF_STATEMENT: {
                this.visit(tree.asForOfStatement());
                break;
            }
            case FOR_IN_STATEMENT: {
                this.visit(tree.asForInStatement());
                break;
            }
            case FOR_STATEMENT: {
                this.visit(tree.asForStatement());
                break;
            }
            case FORMAL_PARAMETER_LIST: {
                this.visit(tree.asFormalParameterList());
                break;
            }
            case FUNCTION_DECLARATION: {
                this.visit(tree.asFunctionDeclaration());
                break;
            }
            case GET_ACCESSOR: {
                this.visit(tree.asGetAccessor());
                break;
            }
            case IDENTIFIER_EXPRESSION: {
                this.visit(tree.asIdentifierExpression());
                break;
            }
            case IF_STATEMENT: {
                this.visit(tree.asIfStatement());
                break;
            }
            case IMPORT_DECLARATION: {
                this.visit(tree.asImportDeclaration());
                break;
            }
            case IMPORT_SPECIFIER: {
                this.visit(tree.asImportSpecifier());
                break;
            }
            case LABELLED_STATEMENT: {
                this.visit(tree.asLabelledStatement());
                break;
            }
            case LITERAL_EXPRESSION: {
                this.visit(tree.asLiteralExpression());
                break;
            }
            case MEMBER_EXPRESSION: {
                this.visit(tree.asMemberExpression());
                break;
            }
            case MEMBER_LOOKUP_EXPRESSION: {
                this.visit(tree.asMemberLookupExpression());
                break;
            }
            case MISSING_PRIMARY_EXPRESSION: {
                this.visit(tree.asMissingPrimaryExpression());
                break;
            }
            case MODULE_IMPORT: {
                this.visit(tree.asModuleImport());
                break;
            }
            case NEW_EXPRESSION: {
                this.visit(tree.asNewExpression());
                break;
            }
            case OBJECT_LITERAL_EXPRESSION: {
                this.visit(tree.asObjectLiteralExpression());
                break;
            }
            case OBJECT_PATTERN: {
                this.visit(tree.asObjectPattern());
                break;
            }
            case OBJECT_PATTERN_FIELD: {
                this.visit(tree.asObjectPatternField());
                break;
            }
            case PAREN_EXPRESSION: {
                this.visit(tree.asParenExpression());
                break;
            }
            case POSTFIX_EXPRESSION: {
                this.visit(tree.asPostfixExpression());
                break;
            }
            case PROGRAM: {
                this.visit(tree.asProgram());
                break;
            }
            case PROPERTY_NAME_ASSIGNMENT: {
                this.visit(tree.asPropertyNameAssignment());
                break;
            }
            case REST_PARAMETER: {
                this.visit(tree.asRestParameter());
                break;
            }
            case RETURN_STATEMENT: {
                this.visit(tree.asReturnStatement());
                break;
            }
            case SET_ACCESSOR: {
                this.visit(tree.asSetAccessor());
                break;
            }
            case SPREAD_EXPRESSION: {
                this.visit(tree.asSpreadExpression());
                break;
            }
            case SPREAD_PATTERN_ELEMENT: {
                this.visit(tree.asSpreadPatternElement());
                break;
            }
            case SUPER_EXPRESSION: {
                this.visit(tree.asSuperExpression());
                break;
            }
            case SWITCH_STATEMENT: {
                this.visit(tree.asSwitchStatement());
                break;
            }
            case THIS_EXPRESSION: {
                this.visit(tree.asThisExpression());
                break;
            }
            case THROW_STATEMENT: {
                this.visit(tree.asThrowStatement());
                break;
            }
            case TRY_STATEMENT: {
                this.visit(tree.asTryStatement());
                break;
            }
            case UNARY_EXPRESSION: {
                this.visit(tree.asUnaryExpression());
                break;
            }
            case VARIABLE_DECLARATION: {
                this.visit(tree.asVariableDeclaration());
                break;
            }
            case VARIABLE_DECLARATION_LIST: {
                this.visit(tree.asVariableDeclarationList());
                break;
            }
            case VARIABLE_STATEMENT: {
                this.visit(tree.asVariableStatement());
                break;
            }
            case WHILE_STATEMENT: {
                this.visit(tree.asWhileStatement());
                break;
            }
            case WITH_STATEMENT: {
                this.visit(tree.asWithStatement());
                break;
            }
            case YIELD_EXPRESSION: {
                this.visit(tree.asYieldStatement());
                break;
            }
            case NULL: {
                this.visit(tree.asNull());
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented");
            }
        }
    }

    protected void visitList(List<? extends ParseTree> list) {
        for (ParseTree parseTree : list) {
            this.visitAny(parseTree);
        }
    }

    protected void visit(ArgumentListTree tree) {
        this.visitList((List<? extends ParseTree>)tree.arguments);
    }

    protected void visit(ArrayLiteralExpressionTree tree) {
        this.visitList((List<? extends ParseTree>)tree.elements);
    }

    protected void visit(ArrayPatternTree tree) {
        for (ParseTree element : tree.elements) {
            this.visitAny(element);
        }
    }

    protected void visit(BinaryOperatorTree tree) {
        this.visitAny(tree.left);
        this.visitAny(tree.right);
    }

    protected void visit(BlockTree tree) {
        this.visitList((List<? extends ParseTree>)tree.statements);
    }

    protected void visit(BreakStatementTree tree) {
    }

    protected void visit(CallExpressionTree tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.arguments);
    }

    protected void visit(CaseClauseTree tree) {
        this.visitAny(tree.expression);
        this.visitList((List<? extends ParseTree>)tree.statements);
    }

    protected void visit(CatchTree tree) {
        this.visitAny(tree.catchBody);
    }

    protected void visit(ClassDeclarationTree tree) {
        this.visitAny(tree.superClass);
        this.visitList((List<? extends ParseTree>)tree.elements);
    }

    protected void visit(CommaExpressionTree tree) {
        this.visitList((List<? extends ParseTree>)tree.expressions);
    }

    protected void visit(ConditionalExpressionTree tree) {
        this.visitAny(tree.condition);
        this.visitAny(tree.left);
        this.visitAny(tree.right);
    }

    protected void visit(ContinueStatementTree tree) {
    }

    protected void visit(DebuggerStatementTree tree) {
    }

    protected void visit(DefaultClauseTree tree) {
        this.visitList((List<? extends ParseTree>)tree.statements);
    }

    protected void visit(DefaultParameterTree tree) {
        this.visitAny(tree.identifier);
        this.visitAny(tree.expression);
    }

    protected void visit(DoWhileStatementTree tree) {
        this.visitAny(tree.body);
        this.visitAny(tree.condition);
    }

    protected void visit(EmptyStatementTree tree) {
    }

    protected void visit(ExportDeclarationTree tree) {
        this.visitAny(tree.declaration);
    }

    protected void visit(ExpressionStatementTree tree) {
        this.visitAny(tree.expression);
    }

    protected void visit(FinallyTree tree) {
        this.visitAny(tree.block);
    }

    protected void visit(ForOfStatementTree tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.collection);
        this.visitAny(tree.body);
    }

    protected void visit(ForInStatementTree tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.collection);
        this.visitAny(tree.body);
    }

    protected void visit(ForStatementTree tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.condition);
        this.visitAny(tree.increment);
        this.visitAny(tree.body);
    }

    protected void visit(FormalParameterListTree tree) {
    }

    protected void visit(FunctionDeclarationTree tree) {
        this.visitAny(tree.formalParameterList);
        this.visitAny(tree.functionBody);
    }

    protected void visit(GetAccessorTree tree) {
        this.visitAny(tree.body);
    }

    protected void visit(IdentifierExpressionTree tree) {
    }

    protected void visit(IfStatementTree tree) {
        this.visitAny(tree.condition);
        this.visitAny(tree.ifClause);
        this.visitAny(tree.elseClause);
    }

    protected void visit(ImportDeclarationTree tree) {
        this.visitList((List<? extends ParseTree>)tree.importSpecifierList);
    }

    protected void visit(ImportSpecifierTree tree) {
    }

    protected void visit(LabelledStatementTree tree) {
        this.visitAny(tree.statement);
    }

    protected void visit(LiteralExpressionTree tree) {
    }

    protected void visit(MemberExpressionTree tree) {
        this.visitAny(tree.operand);
    }

    protected void visit(MemberLookupExpressionTree tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.memberExpression);
    }

    protected void visit(MissingPrimaryExpressionTree tree) {
    }

    protected void visit(ModuleImportTree tree) {
    }

    protected void visit(NewExpressionTree tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.arguments);
    }

    protected void visit(NullTree tree) {
    }

    protected void visit(ObjectLiteralExpressionTree tree) {
        this.visitList((List<? extends ParseTree>)tree.propertyNameAndValues);
    }

    protected void visit(ObjectPatternTree tree) {
        this.visitList((List<? extends ParseTree>)tree.fields);
    }

    protected void visit(ObjectPatternFieldTree tree) {
        this.visitAny(tree.element);
    }

    protected void visit(ParenExpressionTree tree) {
        this.visitAny(tree.expression);
    }

    protected void visit(PostfixExpressionTree tree) {
        this.visitAny(tree.operand);
    }

    protected void visit(ProgramTree tree) {
        this.visitList((List<? extends ParseTree>)tree.sourceElements);
    }

    protected void visit(PropertyNameAssignmentTree tree) {
        this.visitAny(tree.value);
    }

    protected void visit(RestParameterTree tree) {
    }

    protected void visit(ReturnStatementTree tree) {
        this.visitAny(tree.expression);
    }

    protected void visit(SetAccessorTree tree) {
        this.visitAny(tree.body);
    }

    protected void visit(SpreadExpressionTree tree) {
        this.visitAny(tree.expression);
    }

    protected void visit(SpreadPatternElementTree tree) {
        this.visitAny(tree.lvalue);
    }

    protected void visit(SuperExpressionTree tree) {
    }

    protected void visit(SwitchStatementTree tree) {
        this.visitAny(tree.expression);
        this.visitList((List<? extends ParseTree>)tree.caseClauses);
    }

    protected void visit(ThisExpressionTree tree) {
    }

    protected void visit(ThrowStatementTree tree) {
        this.visitAny(tree.value);
    }

    protected void visit(TryStatementTree tree) {
        this.visitAny(tree.body);
        this.visitAny(tree.catchBlock);
        this.visitAny(tree.finallyBlock);
    }

    protected void visit(UnaryExpressionTree tree) {
        this.visitAny(tree.operand);
    }

    protected void visit(VariableDeclarationTree tree) {
        this.visitAny(tree.lvalue);
        this.visitAny(tree.initializer);
    }

    protected void visit(VariableDeclarationListTree tree) {
        this.visitList((List<? extends ParseTree>)tree.declarations);
    }

    protected void visit(VariableStatementTree tree) {
        this.visitAny(tree.declarations);
    }

    protected void visit(WhileStatementTree tree) {
        this.visitAny(tree.condition);
        this.visitAny(tree.body);
    }

    protected void visit(WithStatementTree tree) {
        this.visitAny(tree.expression);
        this.visitAny(tree.body);
    }

    protected void visit(YieldExpressionTree tree) {
        this.visitAny(tree.expression);
    }
}

