/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HttpRequestInitializerPipeline
implements HttpRequestInitializer {
    protected final List<HttpRequestInitializer> initializers;

    public HttpRequestInitializerPipeline(List<HttpRequestInitializer> existing) {
        this.initializers = new ArrayList<HttpRequestInitializer>(existing);
    }

    public HttpRequestInitializerPipeline(HttpRequestInitializer ... initializers) {
        this.initializers = Arrays.asList(initializers);
    }

    public void initialize(HttpRequest httpRequest) throws IOException {
        for (HttpRequestInitializer initializer : this.initializers) {
            initializer.initialize(httpRequest);
        }
    }
}

