/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients;

import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.maps.clients.ApiErrorResponseJson;
import java.io.IOException;

class RateLimitedBackOffRequired
implements HttpBackOffUnsuccessfulResponseHandler.BackOffRequired {
    protected static final String QUOTA_EXCEEDED_REASON = "quotaExceeded";
    private JsonFactory jsonFactory;

    public RateLimitedBackOffRequired() {
        this.jsonFactory = new GsonFactory();
    }

    public RateLimitedBackOffRequired(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public boolean isRequired(HttpResponse httpResponse) {
        try {
            JsonObjectParser jsonParser = this.jsonFactory.createJsonObjectParser();
            ApiErrorResponseJson apiError = (ApiErrorResponseJson)jsonParser.parseAndClose(httpResponse.getContent(), httpResponse.getContentCharset(), ApiErrorResponseJson.class);
            return apiError != null && apiError.error != null && apiError.error.errors != null && apiError.error.errors.size() == 1 && QUOTA_EXCEEDED_REASON.equals(apiError.error.errors.get((int)0).reason);
        }
        catch (IOException e) {
            return false;
        }
    }
}

