/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonGeometryCollection;
import com.google.api.services.mapsengine.model.GeoJsonLineString;
import com.google.api.services.mapsengine.model.GeoJsonMultiLineString;
import com.google.api.services.mapsengine.model.GeoJsonMultiPoint;
import com.google.api.services.mapsengine.model.GeoJsonMultiPolygon;
import com.google.api.services.mapsengine.model.GeoJsonPoint;
import com.google.api.services.mapsengine.model.GeoJsonPolygon;
import com.google.maps.clients.mapsengine.geojson.GeometryCollection;
import com.google.maps.clients.mapsengine.geojson.LineString;
import com.google.maps.clients.mapsengine.geojson.MultiLineString;
import com.google.maps.clients.mapsengine.geojson.MultiPoint;
import com.google.maps.clients.mapsengine.geojson.MultiPolygon;
import com.google.maps.clients.mapsengine.geojson.Point;
import com.google.maps.clients.mapsengine.geojson.Polygon;
import java.util.Map;

public abstract class Geometry {
    public static final String FEATURE_TYPE = "Feature";

    public abstract Feature asFeature(Map<String, Object> var1);

    public static Geometry fromGeoJson(GeoJsonGeometry geoJsonGeometry) {
        Feature shellFeature = new Feature();
        shellFeature.setGeometry(geoJsonGeometry);
        if (geoJsonGeometry instanceof GeoJsonPoint) {
            return new Point(shellFeature);
        }
        if (geoJsonGeometry instanceof GeoJsonMultiPoint) {
            return new MultiPoint(shellFeature);
        }
        if (geoJsonGeometry instanceof GeoJsonLineString) {
            return new LineString(shellFeature);
        }
        if (geoJsonGeometry instanceof GeoJsonMultiLineString) {
            return new MultiLineString(shellFeature);
        }
        if (geoJsonGeometry instanceof GeoJsonPolygon) {
            return new Polygon(shellFeature);
        }
        if (geoJsonGeometry instanceof GeoJsonMultiPolygon) {
            return new MultiPolygon(shellFeature);
        }
        if (geoJsonGeometry instanceof GeoJsonGeometryCollection) {
            return new GeometryCollection(shellFeature);
        }
        throw new IllegalArgumentException("Geometry type is not known: " + geoJsonGeometry.getType());
    }
}

