/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonGeometryCollection;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeometryCollection
extends Geometry {
    private final List<Geometry> geometries;

    public GeometryCollection(List<Geometry> geometries) {
        this.geometries = geometries;
    }

    public GeometryCollection(Feature feature) {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonGeometryCollection)) {
            throw new IllegalArgumentException("Feature is not a GeometryCollection: " + geometry.getType());
        }
        GeoJsonGeometryCollection geometryCollection = (GeoJsonGeometryCollection)geometry;
        List jsonGeometries = geometryCollection.getGeometries();
        this.geometries = new ArrayList<Geometry>(jsonGeometries.size());
        for (GeoJsonGeometry jsonGeometry : jsonGeometries) {
            this.geometries.add(Geometry.fromGeoJson(jsonGeometry));
        }
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        ArrayList<GeoJsonGeometry> geoJsonGeometries = new ArrayList<GeoJsonGeometry>(this.geometries.size());
        for (Geometry geometry : this.geometries) {
            geoJsonGeometries.add(geometry.asFeature(properties).getGeometry());
        }
        GeoJsonGeometryCollection geoJsonCollection = new GeoJsonGeometryCollection();
        geoJsonCollection.setGeometries(geoJsonGeometries);
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setGeometry((GeoJsonGeometry)geoJsonCollection);
        feature.setProperties(properties);
        return feature;
    }

    public List<Geometry> getGeometries() {
        return this.geometries;
    }
}

