/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonLineString;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import com.google.maps.clients.mapsengine.geojson.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LineString
extends Geometry {
    protected final List<Point> points;

    public LineString(List<Point> points) {
        this.points = points;
    }

    public LineString(Feature feature) {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonLineString)) {
            throw new IllegalArgumentException("Feature is not a LineString: " + geometry.getType());
        }
        GeoJsonLineString lineString = (GeoJsonLineString)geometry;
        List rawPoints = lineString.getCoordinates();
        this.points = LineString.fromRawPoints(rawPoints).getPoints();
    }

    static LineString fromRawPoints(List<List<Double>> rawPoints) {
        ArrayList<Point> points = new ArrayList<Point>(rawPoints.size());
        for (List<Double> rawPoint : rawPoints) {
            points.add(new Point(rawPoint));
        }
        return new LineString(points);
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        ArrayList<List<Double>> coords = new ArrayList<List<Double>>(this.points.size());
        for (Point p : this.points) {
            coords.add(p.toCoordinates());
        }
        GeoJsonLineString geometry = new GeoJsonLineString();
        geometry.setCoordinates(coords);
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setProperties(properties);
        feature.setGeometry((GeoJsonGeometry)geometry);
        return feature;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    List<List<Double>> toCoordinates() {
        ArrayList<List<Double>> coords = new ArrayList<List<Double>>(this.points.size());
        for (Point p : this.points) {
            coords.add(p.toCoordinates());
        }
        return coords;
    }
}

