/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonMultiLineString;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import com.google.maps.clients.mapsengine.geojson.LineString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiLineString
extends Geometry {
    protected final List<LineString> lineStrings;

    public MultiLineString(List<LineString> lines) {
        this.lineStrings = lines;
    }

    public MultiLineString(Feature feature) throws IllegalArgumentException {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonMultiLineString)) {
            throw new IllegalArgumentException("Feature is not a MultiLineString: " + geometry.getType());
        }
        GeoJsonMultiLineString multiLineString = (GeoJsonMultiLineString)geometry;
        List rawPoints = multiLineString.getCoordinates();
        this.lineStrings = new ArrayList<LineString>();
        for (List rawLineStringPoints : rawPoints) {
            this.lineStrings.add(LineString.fromRawPoints(rawLineStringPoints));
        }
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        ArrayList<List<List<Double>>> coords = new ArrayList<List<List<Double>>>(this.lineStrings.size());
        for (LineString line : this.lineStrings) {
            coords.add(line.toCoordinates());
        }
        GeoJsonMultiLineString geometry = new GeoJsonMultiLineString();
        geometry.setCoordinates(coords);
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setProperties(properties);
        feature.setGeometry((GeoJsonGeometry)geometry);
        return feature;
    }

    public List<LineString> getLines() {
        return this.lineStrings;
    }
}

