/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonPolygon;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import com.google.maps.clients.mapsengine.geojson.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Polygon
extends Geometry {
    protected List<List<Point>> points;

    private Polygon() {
    }

    public Polygon(Feature feature) {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonPolygon)) {
            throw new IllegalArgumentException("Feature is not a Polygon: " + geometry.getType());
        }
        GeoJsonPolygon polygon = (GeoJsonPolygon)geometry;
        List rawPoints = polygon.getCoordinates();
        this.points = Polygon.fromRawPoints((List<List<List<Double>>>)rawPoints).points;
    }

    public static Polygon createSimplePolygon(List<Point> points) {
        Polygon poly = new Polygon();
        poly.points = Collections.singletonList(points);
        return poly;
    }

    public static Polygon createMultiRingPolygon(List<List<Point>> points) {
        Polygon poly = new Polygon();
        poly.points = points;
        return poly;
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        GeoJsonPolygon geometry = new GeoJsonPolygon();
        geometry.setCoordinates(this.toRawPoints());
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setProperties(properties);
        feature.setGeometry((GeoJsonGeometry)geometry);
        return feature;
    }

    static Polygon fromRawPoints(List<List<List<Double>>> rawPoints) {
        ArrayList<List<Point>> niceRingPoints = new ArrayList<List<Point>>(rawPoints.size());
        for (List<List<Double>> rawRingPoints : rawPoints) {
            ArrayList<Point> nicePoints = new ArrayList<Point>(rawRingPoints.size());
            for (List<Double> rawCoords : rawRingPoints) {
                nicePoints.add(new Point(rawCoords));
            }
            niceRingPoints.add(nicePoints);
        }
        return Polygon.createMultiRingPolygon(niceRingPoints);
    }

    List<List<List<Double>>> toRawPoints() {
        ArrayList<List<List<Double>>> coords = new ArrayList<List<List<Double>>>(this.points.size());
        for (List<Point> ring : this.points) {
            ArrayList<List<Double>> ringCoords = new ArrayList<List<Double>>(ring.size());
            for (Point point : ring) {
                ringCoords.add(point.toCoordinates());
            }
            coords.add(ringCoords);
        }
        return coords;
    }

    public List<List<Point>> getPoints() {
        return this.points;
    }
}

