/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.example;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.Profile;
import java.util.Arrays;

public class RoutingExampleTC {
    public static void main(String[] args) {
        String relDir = args.length == 1 ? args[0] : "";
        GraphHopper hopper = RoutingExampleTC.createGraphHopperInstance(relDir + "core/files/andorra.osm.pbf");
        RoutingExampleTC.routeWithTurnCosts(hopper);
        RoutingExampleTC.routeWithTurnCostsAndCurbsides(hopper);
        RoutingExampleTC.routeWithTurnCostsAndOtherUTurnCosts(hopper);
    }

    public static void routeWithTurnCosts(GraphHopper hopper) {
        GHRequest req = new GHRequest(42.50822, 1.533966, 42.506899, 1.525372).setProfile("car");
        RoutingExampleTC.route(hopper, req, 1038, 63000);
    }

    public static void routeWithTurnCostsAndCurbsides(GraphHopper hopper) {
        GHRequest req = new GHRequest(42.50822, 1.533966, 42.506899, 1.525372).setCurbsides(Arrays.asList("any", "right")).setProfile("car");
        RoutingExampleTC.route(hopper, req, 1729, 112000);
    }

    public static void routeWithTurnCostsAndOtherUTurnCosts(GraphHopper hopper) {
        GHRequest req = new GHRequest(42.50822, 1.533966, 42.506899, 1.525372).setCurbsides(Arrays.asList("any", "right")).putHint("ch.disable", (Object)true).setProfile("car");
        RoutingExampleTC.route(hopper, req.putHint("u_turn_costs", (Object)10), 1370, 100000);
        RoutingExampleTC.route(hopper, req.putHint("u_turn_costs", (Object)15), 1370, 105000);
    }

    private static void route(GraphHopper hopper, GHRequest req, int expectedDistance, int expectedTime) {
        GHResponse rsp = hopper.route(req);
        if (rsp.hasErrors()) {
            throw new RuntimeException(rsp.getErrors().toString());
        }
        ResponsePath path = rsp.getBest();
        assert (Math.abs((double)expectedDistance - path.getDistance()) < 1.0) : "unexpected distance : " + path.getDistance() + " vs. " + expectedDistance;
        assert (Math.abs((long)expectedTime - path.getTime()) < 1000L) : "unexpected time : " + path.getTime() + " vs. " + expectedTime;
    }

    static GraphHopper createGraphHopperInstance(String ghLoc) {
        GraphHopper hopper = new GraphHopper();
        hopper.setOSMFile(ghLoc);
        hopper.setGraphHopperLocation("target/routing-tc-graph-cache");
        Profile profile = new Profile("car").setVehicle("car").setWeighting("fastest").setTurnCosts(true).putHint("u_turn_costs", (Object)40);
        hopper.setProfiles(new Profile[]{profile});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile(profile.getName())});
        hopper.importOrLoad();
        return hopper;
    }
}

