/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import java.util.List;

public class InputParameter {
    final String name;
    final Object value;

    public InputParameter(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueForGraphqlQuery() {
        return this.getValueForGraphqlQuery(this.value);
    }

    private String getValueForGraphqlQuery(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return this.getStringValue((String)val);
        }
        if (val instanceof List) {
            return this.getListValue((List)val);
        }
        return val.toString();
    }

    private String getStringValue(String str) {
        return "\\\"" + str.replace("\"", "\\\"") + "\\\"";
    }

    private String getListValue(List<?> lst) {
        if (lst == null) {
            return null;
        }
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < lst.size(); ++index) {
            Object obj = lst.get(index);
            result.append(this.getValueForGraphqlQuery(obj));
            if (index >= lst.size() - 1) continue;
            result.append(",");
        }
        return result.append("]").toString();
    }
}

