/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLReactiveWebSocketHandler;
import com.graphql_java_generator.client.OAuthTokenExtractor;
import com.graphql_java_generator.client.QueryExecutor;
import com.graphql_java_generator.client.QueryExecutorImpl;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.SubscriptionClientReactiveImpl;
import com.graphql_java_generator.client.request.AbstractGraphQLRequest;
import com.graphql_java_generator.client.response.JsonResponseWrapper;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class QueryExecutorSpringReactiveImpl
implements QueryExecutor {
    private static Logger logger = LoggerFactory.getLogger(QueryExecutorSpringReactiveImpl.class);
    String graphqlEndpoint;
    String graphqlSubscriptionEndpoint;
    ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction;
    OAuthTokenExtractor oAuthTokenExtractor;
    WebClient webClient;
    WebSocketClient webSocketClient;
    ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public QueryExecutorSpringReactiveImpl(String graphqlEndpoint, @Autowired(required=false) String graphqlSubscriptionEndpoint, WebClient webClient, @Autowired(required=false) WebSocketClient webSocketClient, @Autowired(required=false) ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction, @Autowired(required=false) OAuthTokenExtractor oAuthTokenExtractor) {
        this.graphqlEndpoint = graphqlEndpoint;
        this.graphqlSubscriptionEndpoint = graphqlSubscriptionEndpoint;
        this.webClient = webClient;
        this.webSocketClient = webSocketClient;
        this.serverOAuth2AuthorizedClientExchangeFilterFunction = serverOAuth2AuthorizedClientExchangeFilterFunction;
        this.oAuthTokenExtractor = oAuthTokenExtractor;
    }

    @Override
    public <R> R execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, Class<R> dataResponseType) throws GraphQLRequestExecutionException {
        if (graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may not be called for subscriptions");
        }
        String jsonRequest = graphQLRequest.buildRequest(parameters);
        try {
            logger.trace(GRAPHQL_MARKER, "Executing GraphQL request: {}", (Object)jsonRequest);
            JsonResponseWrapper responseJson = (JsonResponseWrapper)this.webClient.post().contentType(MediaType.APPLICATION_JSON).body((Publisher)Mono.just((Object)jsonRequest), String.class).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(JsonResponseWrapper.class).block();
            return QueryExecutorImpl.parseDataFromGraphQLServerResponse(this.objectMapper, responseJson, dataResponseType);
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException("Error when executing query <" + jsonRequest + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public <R, T> SubscriptionClient execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, SubscriptionCallback<T> subscriptionCallback, String subscriptionName, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        if (!graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may be called only for subscriptions");
        }
        if (graphQLRequest.getSubscription().getFields().size() != 1) {
            throw new GraphQLRequestExecutionException("This method may be called only for one subscription at a time, but there was " + graphQLRequest.getSubscription().getFields().size() + " subscriptions in this GraphQLRequest");
        }
        if (!graphQLRequest.getSubscription().getFields().get(0).getName().equals(subscriptionName)) {
            throw new GraphQLRequestExecutionException("The subscription provided in the GraphQLRequest is " + graphQLRequest.getSubscription().getFields().get(0).getName() + " but it should be " + subscriptionName);
        }
        HttpHeaders headers = new HttpHeaders();
        if (this.serverOAuth2AuthorizedClientExchangeFilterFunction != null && this.oAuthTokenExtractor != null) {
            String authorizationHeaderValue = this.oAuthTokenExtractor.getAuthorizationHeaderValue();
            logger.debug("Got this OAuth token (authorization header value): {}", (Object)authorizationHeaderValue);
            headers.add("Authorization", authorizationHeaderValue);
        } else {
            logger.debug("No serverOAuth2AuthorizedClientExchangeFilterFunction or no oAuthTokenExtractor where provided. No OAuth token is provided.");
        }
        String request = graphQLRequest.buildRequest(parameters);
        logger.debug(GRAPHQL_MARKER, "Executing GraphQL subscription '{}' with request {}", (Object)subscriptionName, (Object)request);
        GraphQLReactiveWebSocketHandler<R, T> webSocketHandler = new GraphQLReactiveWebSocketHandler<R, T>(request, subscriptionName, subscriptionCallback, subscriptionType, messageType);
        logger.trace(GRAPHQL_MARKER, "Before execution of GraphQL subscription '{}' with request {}", (Object)subscriptionName, (Object)request);
        Disposable disposable = this.webSocketClient.execute(this.getWebSocketURI(), headers, webSocketHandler).subscribeOn(Schedulers.single()).subscribe();
        logger.trace(GRAPHQL_MARKER, "After execution of GraphQL subscription '{}' with request {}", (Object)subscriptionName, (Object)request);
        return new SubscriptionClientReactiveImpl(disposable, webSocketHandler.getSession());
    }

    public URI getWebSocketURI() throws GraphQLRequestExecutionException {
        String endpoint;
        String string = endpoint = this.graphqlSubscriptionEndpoint != null ? this.graphqlSubscriptionEndpoint : this.graphqlEndpoint;
        if (endpoint.startsWith("http:") || endpoint.startsWith("https:")) {
            try {
                return new URI("ws" + endpoint.substring(4));
            }
            catch (URISyntaxException e) {
                throw new GraphQLRequestExecutionException("Error when trying to determine the Web Socket endpoint for GraphQL endpoint " + endpoint, e);
            }
        }
        throw new GraphQLRequestExecutionException("non managed protocol for endpoint " + endpoint + ". This method manages only http and https");
    }
}

