/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.QueryExecutor;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.SubscriptionClientImpl;
import com.graphql_java_generator.client.SubscriptionClientWebSocket;
import com.graphql_java_generator.client.request.AbstractGraphQLRequest;
import com.graphql_java_generator.client.response.Error;
import com.graphql_java_generator.client.response.JsonResponseWrapper;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class QueryExecutorImpl
implements QueryExecutor {
    private static Logger logger;
    Client client;
    String graphqlEndpoint;
    ObjectMapper objectMapper;
    WebTarget webTarget;

    public QueryExecutorImpl(String graphqlEndpoint) {
        this(graphqlEndpoint, ClientBuilder.newClient(), new ObjectMapper());
        this.graphqlEndpoint = graphqlEndpoint;
    }

    public QueryExecutorImpl(String graphqlEndpoint, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        if (graphqlEndpoint.startsWith("http:")) {
            throw new IllegalArgumentException("This GraphQL endpoint is an http one. Please use the relevant Query/Mutation/Subscription constructor (without the SSLContext and HostnameVerifier parameters)");
        }
        this.client = ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier(hostnameVerifier).build();
        this.graphqlEndpoint = graphqlEndpoint;
        this.objectMapper = new ObjectMapper();
        this.webTarget = this.client.target(graphqlEndpoint);
    }

    @Deprecated
    public QueryExecutorImpl(String graphqlEndpoint, Client client, ObjectMapper objectMapper) {
        this.client = client;
        this.graphqlEndpoint = graphqlEndpoint;
        this.objectMapper = objectMapper;
        this.webTarget = client.target(graphqlEndpoint);
    }

    @Override
    public <R extends GraphQLRequestObject> R execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, Class<R> dataResponseType) throws GraphQLRequestExecutionException {
        if (graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may not be called for subscriptions");
        }
        String jsonRequest = graphQLRequest.buildRequest(parameters);
        try {
            logger.trace(GRAPHQL_MARKER, "Executing GraphQL request: {}", (Object)jsonRequest);
            Invocation.Builder invocationBuilder = this.webTarget.request(new String[]{"application/json"});
            invocationBuilder.header("Accept", (Object)"application/json");
            JsonResponseWrapper response = (JsonResponseWrapper)invocationBuilder.post(Entity.entity((Object)jsonRequest, (String)"application/json"), JsonResponseWrapper.class);
            return QueryExecutorImpl.parseDataFromGraphQLServerResponse(this.objectMapper, response, dataResponseType);
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException("Error when executing query <" + jsonRequest + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public <R, T> SubscriptionClient execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, SubscriptionCallback<T> subscriptionCallback, String subscriptionName, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        if (!graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may be called only for subscriptions");
        }
        if (graphQLRequest.getSubscription().getFields().size() != 1) {
            throw new GraphQLRequestExecutionException("This method may be called only for one subscription at a time, but there was " + graphQLRequest.getSubscription().getFields().size() + " subscriptions in this GraphQLRequest");
        }
        if (!graphQLRequest.getSubscription().getFields().get(0).getName().equals(subscriptionName)) {
            throw new GraphQLRequestExecutionException("The subscription provided in the GraphQLRequest is " + graphQLRequest.getSubscription().getFields().get(0).getName() + " but it should be " + subscriptionName);
        }
        String request = graphQLRequest.buildRequest(parameters);
        logger.trace(GRAPHQL_MARKER, "Executing GraphQL subscription '{}' with request {}", (Object)subscriptionName, (Object)request);
        boolean trustAll = System.getProperty("com.graphql-java-generator.websocket.nosslcheck") != null;
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(trustAll);
        HttpClient httpClient = new HttpClient((SslContextFactory)sslContextFactory);
        WebSocketClient client = new WebSocketClient(httpClient);
        SubscriptionClientWebSocket<R, T> subscriptionClientWebSocket = new SubscriptionClientWebSocket<R, T>(request, subscriptionName, subscriptionCallback, subscriptionType, messageType);
        URI uri = this.getWebSocketURI();
        try {
            client.start();
            ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
            client.connect(subscriptionClientWebSocket, uri, clientUpgradeRequest);
            logger.debug("Connecting to {}", (Object)uri);
        }
        catch (Exception e) {
            String msg = "Error while opening the Web Socket connection to " + uri;
            logger.error(msg);
            throw new GraphQLRequestExecutionException(msg, e);
        }
        return new SubscriptionClientImpl(client);
    }

    URI getWebSocketURI() throws GraphQLRequestExecutionException {
        if (this.graphqlEndpoint.startsWith("http:") || this.graphqlEndpoint.startsWith("https:")) {
            try {
                return new URI("ws" + this.graphqlEndpoint.substring(4));
            }
            catch (URISyntaxException e) {
                throw new GraphQLRequestExecutionException("Error when trying to determine the Web Socket endpoint for GraphQL endpoint " + this.graphqlEndpoint, e);
            }
        }
        throw new GraphQLRequestExecutionException("non managed protocol for endpoint " + this.graphqlEndpoint + ". This method manages only http and https");
    }

    static <T extends GraphQLRequestObject> T parseDataFromGraphQLServerResponse(ObjectMapper objectMapper, JsonResponseWrapper response, Class<T> valueType) throws GraphQLRequestExecutionException, JsonProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace("Response data: {}", (Object)objectMapper.writeValueAsString((Object)response.data));
            logger.trace("Response errors: {}", (Object)objectMapper.writeValueAsString(response.errors));
        }
        if (response.errors == null || response.errors.size() == 0) {
            GraphQLRequestObject ret = (GraphQLRequestObject)objectMapper.treeToValue((TreeNode)response.data, valueType);
            ret.setExtensions(response.extensions);
            return (T)ret;
        }
        int nbErrors = 0;
        String agregatedMessage = null;
        for (Error error : response.errors) {
            String msg = error.toString();
            ++nbErrors;
            logger.error(GRAPHQL_MARKER, msg);
            if (agregatedMessage == null) {
                agregatedMessage = msg;
                continue;
            }
            agregatedMessage = agregatedMessage + ", ";
            agregatedMessage = agregatedMessage + msg;
        }
        if (nbErrors == 0) {
            throw new GraphQLRequestExecutionException("An unknown error occured");
        }
        throw new GraphQLRequestExecutionException(nbErrors + " errors occured: " + agregatedMessage);
    }

    static {
        GRAPHQL_QUERY_MARKER.add(GRAPHQL_MARKER);
        GRAPHQL_MUTATION_MARKER.add(GRAPHQL_MARKER);
        GRAPHQL_SUBSCRIPTION_MARKER.add(GRAPHQL_MARKER);
        logger = LoggerFactory.getLogger(QueryExecutorImpl.class);
    }
}

