/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLConfiguration;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.request.Fragment;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.QueryField;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractGraphQLRequest {
    static GraphQLConfiguration staticConfiguration = null;
    GraphQLConfiguration instanceConfiguration = null;
    QueryField query = null;
    QueryField mutation = null;
    QueryField subscription = null;
    List<Fragment> fragments = new ArrayList<Fragment>();
    final String graphQLRequest;
    RequestType requestType;
    final String queryName;
    protected final String packageName;

    public AbstractGraphQLRequest(String graphQLRequest, RequestType requestType, String queryName, InputParameter ... inputParams) throws GraphQLRequestPreparationException {
        QueryField field;
        if (requestType == null) {
            throw new NullPointerException("requestType is mandatory, but a null value has been provided");
        }
        if (queryName == null) {
            throw new NullPointerException("queryName is mandatory, but a null value has been provided");
        }
        this.requestType = requestType;
        this.queryName = queryName;
        this.graphQLRequest = graphQLRequest;
        this.packageName = this.getGraphQLClassesPackageName();
        switch (requestType) {
            case query: {
                this.query = this.getQueryContext();
                field = new QueryField(this.query.clazz, queryName);
                this.query.fields.add(field);
                break;
            }
            case mutation: {
                this.mutation = this.getMutationContext();
                field = new QueryField(this.mutation.clazz, queryName);
                this.mutation.fields.add(field);
                break;
            }
            case subscription: {
                this.subscription = this.getSubscriptionContext();
                field = new QueryField(this.subscription.clazz, queryName);
                this.subscription.fields.add(field);
                break;
            }
            default: {
                throw new GraphQLRequestPreparationException("Non managed request type '" + (Object)((Object)requestType) + " while reading the GraphQL request: " + graphQLRequest);
            }
        }
        field.inputParameters = Arrays.asList(inputParams);
        QueryTokenizer qt = new QueryTokenizer(this.graphQLRequest);
        if (qt.hasMoreTokens()) {
            String token = qt.nextToken();
            if (!"{".equals(token)) {
                throw new GraphQLRequestPreparationException("The Partial GraphQL Request should start by a '{', but it doesn't: " + graphQLRequest);
            }
            field.readTokenizerForResponseDefinition(qt);
        }
        this.finishRequestPreparation();
    }

    public AbstractGraphQLRequest(String graphQLRequest) throws GraphQLRequestPreparationException {
        this.queryName = null;
        this.graphQLRequest = graphQLRequest;
        this.packageName = this.getGraphQLClassesPackageName();
        this.requestType = RequestType.query;
        QueryTokenizer qt = new QueryTokenizer(this.graphQLRequest);
        block17: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case "fragment": {
                    this.fragments.add(new Fragment(qt, this.packageName, false, null));
                    continue block17;
                }
                case "query": 
                case "mutation": 
                case "subscription": {
                    this.requestType = RequestType.valueOf(token);
                    continue block17;
                }
                case "{": {
                    switch (this.requestType) {
                        case query: {
                            this.query = this.getQueryContext();
                            this.query.readTokenizerForResponseDefinition(qt);
                            continue block17;
                        }
                        case mutation: {
                            this.mutation = this.getMutationContext();
                            this.mutation.readTokenizerForResponseDefinition(qt);
                            continue block17;
                        }
                        case subscription: {
                            this.subscription = this.getSubscriptionContext();
                            this.subscription.readTokenizerForResponseDefinition(qt);
                            continue block17;
                        }
                    }
                    throw new GraphQLRequestPreparationException("Non managed request type '" + (Object)((Object)this.requestType) + " while reading the GraphQL request: " + graphQLRequest);
                }
            }
            throw new GraphQLRequestPreparationException("Unknown token '" + token + " while reading the GraphQL request: " + graphQLRequest);
        }
        if (this.query == null && this.mutation == null) {
            throw new GraphQLRequestPreparationException("No response definition found");
        }
        this.finishRequestPreparation();
    }

    public <T extends GraphQLRequestObject> T exec(Class<T> t, Map<String, Object> params) throws GraphQLRequestExecutionException {
        if (this.instanceConfiguration != null) {
            return this.instanceConfiguration.getQueryExecutor().execute(this, params, t);
        }
        if (staticConfiguration != null) {
            return staticConfiguration.getQueryExecutor().execute(this, params, t);
        }
        throw new GraphQLRequestExecutionException("The GraphQLRequestConfiguration has not been set in the GraphQLRequest. Please set either the GraphQL instance configuration or the GraphQL static configuration before executing a GraphQL request");
    }

    public <R, T> SubscriptionClient exec(Map<String, Object> params, SubscriptionCallback<T> subscriptionCallback, String subscriptionName, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        if (this.instanceConfiguration != null) {
            return this.instanceConfiguration.getQueryExecutor().execute(this, params, subscriptionCallback, subscriptionName, subscriptionType, messageType);
        }
        if (staticConfiguration != null) {
            return staticConfiguration.getQueryExecutor().execute(this, params, subscriptionCallback, subscriptionName, subscriptionType, messageType);
        }
        throw new GraphQLRequestExecutionException("The GraphQLRequestConfiguration has not been set in the GraphQLRequest. Please set either the GraphQL instance configuration or the GraphQL static configuration before executing a GraphQL request");
    }

    private void addTypenameFields() throws GraphQLRequestPreparationException {
        if (this.query != null) {
            this.query.addTypenameFields();
        }
        if (this.mutation != null) {
            this.mutation.addTypenameFields();
        }
        if (this.subscription != null) {
            this.subscription.addTypenameFields();
        }
        for (Fragment f : this.fragments) {
            f.addTypenameFields();
        }
    }

    private void finishRequestPreparation() throws GraphQLRequestPreparationException {
        this.AddScalarFieldToEmptyNonScalarField(this.query);
        this.AddScalarFieldToEmptyNonScalarField(this.mutation);
        this.AddScalarFieldToEmptyNonScalarField(this.subscription);
        this.addTypenameFields();
    }

    private void AddScalarFieldToEmptyNonScalarField(QueryField field) throws GraphQLRequestPreparationException {
        block7: {
            if (field == null || field.isScalar()) break block7;
            if (field.fields.size() == 0 && field.fragments.size() == 0 && field.inlineFragments.size() == 0) {
                if (field.clazz.isInterface()) {
                    for (Method m : field.clazz.getDeclaredMethods()) {
                        GraphQLScalar graphQLScalar;
                        if (!m.getName().startsWith("get") || (graphQLScalar = m.getAnnotation(GraphQLScalar.class)) == null) continue;
                        field.fields.add(new QueryField(field.clazz, graphQLScalar.fieldName()));
                    }
                } else {
                    for (Field f : field.clazz.getDeclaredFields()) {
                        GraphQLScalar graphQLScalar = f.getAnnotation(GraphQLScalar.class);
                        if (graphQLScalar == null) continue;
                        field.fields.add(new QueryField(field.clazz, graphQLScalar.fieldName()));
                    }
                }
            } else {
                for (QueryField f : field.fields) {
                    this.AddScalarFieldToEmptyNonScalarField(f);
                }
            }
        }
    }

    public String buildRequest(Map<String, Object> params) throws GraphQLRequestExecutionException {
        StringBuilder sb = new StringBuilder("{\"query\":\"");
        for (Fragment fragment : this.fragments) {
            fragment.appendToGraphQLRequests(sb, params);
        }
        if (this.query != null) {
            this.query.appendToGraphQLRequests(sb, params, true);
        }
        if (this.mutation != null) {
            this.mutation.appendToGraphQLRequests(sb, params, true);
        }
        if (this.subscription != null) {
            this.subscription.appendToGraphQLRequests(sb, params, true);
        }
        sb.append("\",\"variables\":null,\"operationName\":null}");
        return sb.toString();
    }

    protected abstract String getGraphQLClassesPackageName();

    protected abstract QueryField getQueryContext() throws GraphQLRequestPreparationException;

    protected abstract QueryField getMutationContext() throws GraphQLRequestPreparationException;

    protected abstract QueryField getSubscriptionContext() throws GraphQLRequestPreparationException;

    public QueryField getQuery() {
        return this.query;
    }

    public QueryField getMutation() {
        return this.mutation;
    }

    public QueryField getSubscription() {
        return this.subscription;
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public static GraphQLConfiguration getStaticConfiguration() {
        return staticConfiguration;
    }

    public static void setStaticConfiguration(GraphQLConfiguration staticConfiguration) {
        AbstractGraphQLRequest.staticConfiguration = staticConfiguration;
    }

    public GraphQLConfiguration getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    public void setInstanceConfiguration(GraphQLConfiguration instanceConfiguration) {
        this.instanceConfiguration = instanceConfiguration;
    }
}

