/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.QueryExecutor;
import com.graphql_java_generator.client.QueryExecutorImpl;
import com.graphql_java_generator.client.QueryExecutorSpringReactiveImpl;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.netty.http.client.HttpClient;

public class GraphQLConfiguration {
    final QueryExecutor executor;

    public GraphQLConfiguration(QueryExecutor executor) {
        this.executor = executor;
    }

    public GraphQLConfiguration(String graphqlEndpoint) {
        this.executor = new QueryExecutorSpringReactiveImpl(graphqlEndpoint, null, GraphQLConfiguration.getWebClient(graphqlEndpoint, null, new ExchangeFilterFunction[0]), GraphQLConfiguration.getWebSocketClient(null), null, null);
    }

    public static WebClient getWebClient(String graphqlEndpoint, HttpClient httpClient, ExchangeFilterFunction ... filters) {
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(graphqlEndpoint).defaultHeader("Content-Type", new String[]{"application/json"}).defaultUriVariables(Collections.singletonMap("url", graphqlEndpoint));
        if (httpClient != null) {
            webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        }
        if (filters != null) {
            for (ExchangeFilterFunction filter : filters) {
                if (filter == null) continue;
                webClientBuilder.filter(filter);
            }
        }
        return webClientBuilder.build();
    }

    public static WebSocketClient getWebSocketClient(HttpClient httpClient) {
        if (httpClient == null) {
            return new ReactorNettyWebSocketClient(HttpClient.create());
        }
        return new ReactorNettyWebSocketClient(httpClient);
    }

    @Deprecated
    public GraphQLConfiguration(String graphqlEndpoint, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        this.executor = new QueryExecutorImpl(graphqlEndpoint, sslContext, hostnameVerifier);
    }

    @Deprecated
    public GraphQLConfiguration(String graphqlEndpoint, Client client) {
        this.executor = new QueryExecutorImpl(graphqlEndpoint, client);
    }

    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }
}

