/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.AbstractQuery;
import com.groupbyinc.api.model.AbstractRecord;
import com.groupbyinc.api.model.AbstractResults;
import com.groupbyinc.api.model.RefinementsResult;
import com.groupbyinc.api.request.AbstractRequest;
import com.groupbyinc.common.http.HttpEntity;
import com.groupbyinc.common.http.HttpResponse;
import com.groupbyinc.common.http.client.config.RequestConfig;
import com.groupbyinc.common.http.client.methods.CloseableHttpResponse;
import com.groupbyinc.common.http.client.methods.HttpPost;
import com.groupbyinc.common.http.client.methods.HttpUriRequest;
import com.groupbyinc.common.http.conn.HttpClientConnectionManager;
import com.groupbyinc.common.http.entity.StringEntity;
import com.groupbyinc.common.http.impl.client.CloseableHttpClient;
import com.groupbyinc.common.http.impl.client.HttpClientBuilder;
import com.groupbyinc.common.http.impl.conn.PoolingHttpClientConnectionManager;
import com.groupbyinc.common.util.io.Charsets;
import com.groupbyinc.common.util.io.IOUtils;
import com.groupbyinc.common.util.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public abstract class AbstractBridge<RQ extends AbstractRequest<RQ>, Q extends AbstractQuery<RQ, Q>, D extends AbstractRecord<D>, R extends AbstractResults<D, R>> {
    public static final String CLUSTER = "/cluster";
    protected static final String COLON = ":";
    protected static final String HTTP = "http://";
    protected static final String HTTPS = "https://";
    private static final Logger LOG = Logger.getLogger(AbstractBridge.class.getName());
    private static final String SEARCH = "/search";
    private static final String REFINEMENTS = "/refinements";
    private static final String REFINEMENT_SEARCH = "/refinement";
    private static final String BODY = "\nbody:\n";
    private static final String EXCEPTION_FROM_BRIDGE = "Exception from bridge: ";
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(15000).setConnectionRequestTimeout(15000).setSocketTimeout(30000).build();
    private final String bridgeUrl;
    private final String bridgeRefinementsUrl;
    private final String bridgeRefinementSearchUrl;
    private final String bridgeClusterUrl;
    protected String clientKey;
    private CloseableHttpClient httpClient;
    private long retryTimeout = 80L;

    public AbstractBridge(String clientKey, String baseUrl) {
        this(clientKey, baseUrl, true);
    }

    public AbstractBridge(String clientKey, String baseUrl, boolean compressResponse) {
        try {
            new URI(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid url: " + baseUrl);
        }
        this.clientKey = clientKey;
        this.createClient(compressResponse);
        this.bridgeUrl = baseUrl + SEARCH;
        this.bridgeRefinementsUrl = this.bridgeUrl + REFINEMENTS;
        this.bridgeRefinementSearchUrl = baseUrl + REFINEMENT_SEARCH;
        this.bridgeClusterUrl = baseUrl + CLUSTER;
    }

    public String getBridgeUrl() {
        return this.bridgeUrl;
    }

    public String getBridgeRefinementsUrl() {
        return this.bridgeRefinementsUrl;
    }

    public String getClusterBridgeUrl() {
        return this.bridgeClusterUrl;
    }

    private void createClient(boolean compressResponse) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        HttpClientBuilder b = HttpClientBuilder.create();
        if (!compressResponse) {
            b.disableContentCompression();
        }
        this.httpClient = b.setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(REQUEST_CONFIG).build();
    }

    protected abstract R map(InputStream var1, boolean var2);

    protected abstract RefinementsResult mapRefinements(InputStream var1, boolean var2);

    public R search(Q query) throws IOException {
        InputStream data = this.fireRequest(this.getBridgeUrl(), ((AbstractQuery)query).getBridgeJson(this.clientKey), ((AbstractQuery)query).isReturnBinary());
        return this.map(data, ((AbstractQuery)query).isReturnBinary());
    }

    protected RefinementsResult refinements(Q query, String navigationName) throws IOException {
        InputStream data = this.fireRequest(this.getBridgeRefinementsUrl(), ((AbstractQuery)query).getBridgeRefinementsJson(this.clientKey, navigationName), ((AbstractQuery)query).isReturnBinary());
        return this.mapRefinements(data, ((AbstractQuery)query).isReturnBinary());
    }

    protected InputStream fireRequest(String url, String body, boolean returnBinary) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpResponse response = this.postToBridge(httpPost, body);
        InputStream data = response.getEntity().getContent();
        if (response.getStatusLine().getStatusCode() != 200) {
            String status = response.getStatusLine().toString();
            byte[] bytes = IOUtils.toByteArray((InputStream)data);
            IOUtils.closeQuietly((InputStream)data);
            this.handleErrorStatus(status, bytes, returnBinary);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleErrorStatus(String status, byte[] bytes, boolean returnBinary) throws IOException {
        StringBuilder msg = new StringBuilder();
        try {
            String errors = ((AbstractResults)this.map(new ByteArrayInputStream(bytes), returnBinary)).getErrors();
            if (StringUtils.isNotBlank((CharSequence)errors)) {
                msg.append(", ").append(errors);
            }
        }
        catch (Exception e) {
            LOG.warning("unable to parse error from response.");
        }
        finally {
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg.append(BODY).append(StringUtils.toString((byte[])bytes, (String)Charsets.UTF_8.name()));
            }
        }
        throw new IOException(EXCEPTION_FROM_BRIDGE + status + msg.toString());
    }

    private HttpResponse postToBridge(HttpPost httpPost, String bridgeJson) throws IOException {
        StringEntity entity = new StringEntity(bridgeJson, Charset.forName("UTF-8"));
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        boolean successful = false;
        int tries = 0;
        SocketException lastError = null;
        while (!successful && tries < 3) {
            try {
                response = this.httpClient.execute((HttpUriRequest)httpPost);
                successful = true;
            }
            catch (SocketException e) {
                try {
                    Thread.sleep(this.retryTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.warning("Connection failed, retrying");
                lastError = e;
                ++tries;
                httpPost.reset();
            }
        }
        if (tries < 3) {
            return response;
        }
        throw new IOException("Tried to connect three times to: " + httpPost.getURI(), lastError);
    }

    public void shutdown() {
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }
}

