/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.util;

import com.groupbyinc.api.AbstractQuery;
import com.groupbyinc.api.model.Navigation;
import com.groupbyinc.api.model.Refinement;
import com.groupbyinc.api.model.refinement.RefinementValue;
import com.groupbyinc.api.parser.ParserException;
import com.groupbyinc.api.request.AbstractRequest;
import com.groupbyinc.common.http.client.utils.URIBuilder;
import com.groupbyinc.common.util.collections4.MapUtils;
import com.groupbyinc.common.util.lang3.ArrayUtils;
import com.groupbyinc.common.util.lang3.StringUtils;
import com.groupbyinc.util.UrlEncoder;
import com.groupbyinc.util.UrlReplacement;
import com.groupbyinc.util.UrlReplacementRule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractUrlBeautifier<RQ extends AbstractRequest<RQ>, Q extends AbstractQuery<RQ, Q>> {
    public static final String PARAM_REPLACEMENT = "z";
    public static final String SEARCH_NAVIGATION_NAME = "search";
    private static final String REFINEMENTS_PARAM_DEFAULT = "refinements";
    private static final String ID = "id";
    private static final Pattern idPattern = Pattern.compile("(?:\\A|.*&)id=([^&]*).*");
    private final Navigation SEARCH_NAVIGATION = new Navigation().setDisplayName("");
    private List<UrlReplacementRule> replacementRules = new ArrayList<UrlReplacementRule>();
    private LinkedHashMap<String, Navigation> tokenToName = new LinkedHashMap();
    private LinkedHashMap<String, Navigation> nameToToken = new LinkedHashMap();
    private List<Navigation> remainingMappings = new ArrayList<Navigation>();
    private String refinementsQueryParameterName = "refinements";
    private String append = null;

    protected AbstractUrlBeautifier() {
    }

    protected abstract Q createQuery();

    public String toUrl(String searchString, String existingRefinements) throws UrlBeautificationException {
        StringBuilder pathSegmentLookup = new StringBuilder("/");
        Q query = this.createQuery();
        if (StringUtils.isNotBlank((CharSequence)searchString)) {
            ((AbstractQuery)query).setQuery(searchString);
        }
        URIBuilder uri = new URIBuilder();
        uri.setPath("");
        ((AbstractQuery)query).addRefinementsByString(existingRefinements);
        Map<String, Navigation> navigations = this.getDistinctRefinements(query);
        this.addRefinements(((AbstractQuery)query).getQuery(), navigations, pathSegmentLookup, uri);
        this.addReferenceBlock(pathSegmentLookup, uri);
        this.addAppend(uri);
        this.addUnmappedRefinements(navigations, uri);
        String uriString = uri.toString();
        return uriString.startsWith("null") ? uriString.substring(4) : uriString;
    }

    private Map<String, Navigation> getDistinctRefinements(Q query) {
        Map<String, Navigation> navigations = ((AbstractQuery)query).getNavigations();
        for (Navigation n : navigations.values()) {
            HashSet<String> names = new HashSet<String>();
            Iterator<Refinement> iterator = n.getRefinements().iterator();
            while (iterator.hasNext()) {
                Refinement refinement = iterator.next();
                String name = n.getName() + refinement.toTildeString();
                if (!names.contains(name)) {
                    names.add(name);
                    continue;
                }
                iterator.remove();
            }
        }
        return navigations;
    }

    private void addUnmappedRefinements(Map<String, Navigation> navigations, URIBuilder uri) {
        if (MapUtils.isNotEmpty(navigations)) {
            Q query = this.createQuery();
            Map<String, Navigation> distinctRefinements = this.getDistinctRefinements(query);
            for (Map.Entry<String, Navigation> entry : navigations.entrySet()) {
                Navigation n = distinctRefinements.get(entry.getKey());
                if (n == null) {
                    distinctRefinements.put(entry.getKey(), entry.getValue());
                    continue;
                }
                n.getRefinements().addAll(entry.getValue().getRefinements());
            }
            String refinements = ((AbstractQuery)query).getRefinementString();
            if (StringUtils.isNotBlank((CharSequence)refinements)) {
                uri.addParameter(this.refinementsQueryParameterName, ((AbstractQuery)query).getRefinementString());
            }
        }
    }

    private void addAppend(URIBuilder uri) {
        if (StringUtils.isNotBlank((CharSequence)this.append)) {
            uri.setPath(uri.getPath() + this.append);
        }
    }

    private void addSearchString(String searchString, StringBuilder reference, URIBuilder pUri) {
        if (StringUtils.isNotBlank((CharSequence)searchString)) {
            pUri.setPath(pUri.getPath() + "/" + UrlEncoder.encode(searchString));
            reference.append(this.SEARCH_NAVIGATION.getDisplayName());
        }
    }

    private void addReferenceBlock(StringBuilder reference, URIBuilder uri) {
        if (reference.length() > 1) {
            uri.setPath(uri.getPath() + reference.toString());
        }
    }

    private void addRefinements(String pSearchString, Map<String, Navigation> navigations, StringBuilder pathSegmentLookup, URIBuilder uri) throws UrlBeautificationException {
        int indexOffSet = StringUtils.length((CharSequence)uri.getPath()) + 1;
        ArrayList<UrlReplacement> replacements = new ArrayList<UrlReplacement>();
        for (Navigation m : this.remainingMappings) {
            if (m == this.SEARCH_NAVIGATION && StringUtils.isNotBlank((CharSequence)pSearchString)) {
                pSearchString = this.applyReplacementRule(m, pSearchString, indexOffSet, replacements);
                indexOffSet += pSearchString.length() + 1;
                this.addSearchString(pSearchString, pathSegmentLookup, uri);
                continue;
            }
            Navigation n = navigations.get(m.getName());
            if (n == null) continue;
            Iterator<Refinement> ri = n.getRefinements().iterator();
            while (ri.hasNext()) {
                Refinement r = ri.next();
                switch (r.getType()) {
                    case Value: {
                        pathSegmentLookup.append(this.getToken(n.getName()));
                        RefinementValue rv = (RefinementValue)r;
                        rv.setValue(this.applyReplacementRule(n, rv.getValue(), indexOffSet, replacements));
                        String encodedRefValue = "/" + UrlEncoder.encode(rv.getValue());
                        indexOffSet += rv.getValue().length() + 1;
                        uri.setPath(uri.getPath() + encodedRefValue);
                        ri.remove();
                        break;
                    }
                    case Range: {
                        throw new UrlBeautificationException("You should not map ranges into URLs.");
                    }
                }
            }
            if (!n.getRefinements().isEmpty()) continue;
            navigations.remove(n.getName());
        }
        if (!replacements.isEmpty()) {
            uri.addParameter(PARAM_REPLACEMENT, UrlReplacement.buildQueryString(replacements));
        }
    }

    public Q fromUrl(String uri) throws UrlBeautificationException {
        Q query = this.fromUrl(uri, null);
        if (query == null) {
            throw new IllegalStateException("URL reference block is invalid, could not convert to query");
        }
        return query;
    }

    public Q fromUrl(String url, Q defaultQuery) throws UrlBeautificationException {
        Object[] queryParams;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new UrlBeautificationException("Unable to parse url", e);
        }
        String urlQueryString = uri.getQuery();
        if (StringUtils.isNotBlank((CharSequence)urlQueryString) && idPattern.matcher(urlQueryString).matches()) {
            Matcher m = idPattern.matcher(urlQueryString);
            m.find();
            return ((AbstractQuery)this.createQuery()).addValueRefinement(ID, m.group(1));
        }
        Q query = this.createQuery();
        String replacementUrlQueryString = this.getReplacementQuery(uri.getRawQuery());
        List<String> pathSegments = new ArrayList<String>();
        String uriPath = uri.getPath();
        if (StringUtils.isNotBlank((CharSequence)this.append) && uriPath.endsWith(this.append)) {
            uriPath = uriPath.substring(0, uriPath.length() - this.append.length());
        }
        pathSegments.addAll(Arrays.asList(uriPath.split("/")));
        String pathSegmentLookup = this.lastSegment(pathSegments);
        if (pathSegments.size() > pathSegmentLookup.length()) {
            this.removeUnusedPathSegments(pathSegments, pathSegmentLookup);
        } else if (pathSegments.size() < pathSegmentLookup.length()) {
            return defaultQuery;
        }
        try {
            pathSegments = this.applyReplacementToPathSegment(pathSegments, UrlReplacement.parseQueryString(replacementUrlQueryString));
        }
        catch (ParserException e) {
            throw new UrlBeautificationException("Replacement Query is malformed, returning default query", e);
        }
        while (pathSegments.size() > 0) {
            this.addRefinement(pathSegments, query, pathSegmentLookup);
        }
        if (StringUtils.isNotBlank((CharSequence)urlQueryString) && ArrayUtils.isNotEmpty((Object[])(queryParams = urlQueryString.split("\\&")))) {
            for (Object keyValue : queryParams) {
                if (!((String)keyValue).startsWith(this.refinementsQueryParameterName + "=")) continue;
                String v = ((String)keyValue).substring(this.refinementsQueryParameterName.length());
                ((AbstractQuery)query).addRefinementsByString(v);
                break;
            }
        }
        return query;
    }

    private void removeUnusedPathSegments(List<String> pathSegments, String pathSegmentLookup) {
        while (pathSegments.size() > pathSegmentLookup.length()) {
            pathSegments.remove(0);
        }
    }

    private String lastSegment(List<String> pathSegments) {
        return pathSegments.remove(pathSegments.size() - 1);
    }

    private void addRefinement(List<String> pathSegments, Q query, String referenceBlock) {
        String token = String.valueOf(referenceBlock.charAt(referenceBlock.length() - pathSegments.size()));
        if (token.equals(this.SEARCH_NAVIGATION.getDisplayName())) {
            ((AbstractQuery)query).setQuery(pathSegments.remove(0));
        } else if (this.getFieldName(token) != null) {
            ((AbstractQuery)query).addValueRefinement(this.getFieldName(token), pathSegments.remove(0));
        } else {
            pathSegments.remove(0);
        }
    }

    private String getFieldName(String token) {
        Navigation mapping = this.tokenToName.get(token);
        return mapping == null ? null : mapping.getName();
    }

    private String getToken(String name) {
        Navigation mapping = this.nameToToken.get(name);
        return mapping == null ? null : mapping.getDisplayName();
    }

    public void setSearchMapping(char pToken) {
        this.SEARCH_NAVIGATION.setName(SEARCH_NAVIGATION_NAME);
        this.SEARCH_NAVIGATION.setDisplayName(String.valueOf(pToken));
        this.addMapping(this.SEARCH_NAVIGATION);
    }

    private void setValues(Navigation pMapping, String pName, String pToken) {
        pMapping.setName(pName);
        pMapping.setDisplayName(pToken);
    }

    public void addRefinementMapping(char pToken, String pName) {
        Navigation mapping = new Navigation();
        this.setValues(mapping, pName, String.valueOf(pToken));
        this.addMapping(mapping);
    }

    private void addMapping(Navigation mapping) {
        String name = mapping.getName();
        String token = mapping.getDisplayName();
        if (token.length() != 1 || StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalStateException("Token length must be one");
        }
        if (token.matches("[aoeuiAOEUIyY]")) {
            throw new IllegalStateException("Vowels are not allowed to avoid Dictionary words appearing");
        }
        if (this.tokenToName.containsKey(token)) {
            throw new IllegalStateException("This token: " + token + " is already mapped to: " + this.tokenToName.get(token).getName());
        }
        this.tokenToName.put(token, mapping);
        this.nameToToken.put(name, mapping);
        this.remainingMappings.add(mapping);
    }

    public void clearSavedFields() {
        this.append = null;
        this.tokenToName = new LinkedHashMap();
        this.nameToToken = new LinkedHashMap();
        this.remainingMappings = new ArrayList<Navigation>();
    }

    public String getAppend() {
        return this.append;
    }

    public void setAppend(String pAppend) {
        this.append = pAppend;
    }

    public String getRefinementsQueryParameterName() {
        return this.refinementsQueryParameterName;
    }

    public void setRefinementsQueryParameterName(String pRefinementsQueryParameterName) {
        this.refinementsQueryParameterName = pRefinementsQueryParameterName;
    }

    public void addReplacementRule(char pTarget, Character pReplacement) {
        this.addReplacementRule(pTarget, pReplacement, null);
    }

    public void addReplacementRule(char pTarget, Character pReplacement, String pRefinementName) {
        if (!Character.valueOf(pTarget).equals(pReplacement)) {
            this.replacementRules.add(new UrlReplacementRule(pTarget, pReplacement, pRefinementName));
        }
    }

    private String getReplacementQuery(String pQuery) {
        if (StringUtils.isNotBlank((CharSequence)pQuery)) {
            for (String token : pQuery.split("&")) {
                if (!token.startsWith("z=")) continue;
                return UrlEncoder.decode(token.substring(2));
            }
        }
        return "";
    }

    private List<String> applyReplacementToPathSegment(List<String> pPathSegments, List<UrlReplacement> pReplacements) {
        if (pPathSegments.isEmpty()) {
            return pPathSegments;
        }
        ArrayList<String> replacedPathSegments = new ArrayList<String>(pPathSegments.size());
        int indexOffSet = 1;
        for (String pathSegment : pPathSegments) {
            StringBuilder decodedPathSegment = new StringBuilder(UrlEncoder.decode(pathSegment));
            for (UrlReplacement replacement : pReplacements) {
                replacement.apply(decodedPathSegment, indexOffSet);
            }
            replacedPathSegments.add(decodedPathSegment.toString());
            indexOffSet += decodedPathSegment.length() + 1;
        }
        return replacedPathSegments;
    }

    private String applyReplacementRule(Navigation pNavigation, String pValue, int pIndexOffSet, List<UrlReplacement> pReplacements) {
        StringBuilder urlBuilder = new StringBuilder(pValue);
        for (UrlReplacementRule replacementRule : this.replacementRules) {
            replacementRule.apply(urlBuilder, pIndexOffSet, pNavigation.getName(), pReplacements);
        }
        return urlBuilder.toString();
    }

    public static class UrlBeautificationException
    extends Exception {
        public UrlBeautificationException(String message) {
            super(message);
        }

        public UrlBeautificationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

