/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.model.CustomUrlParam;
import com.groupbyinc.api.model.Navigation;
import com.groupbyinc.api.model.Refinement;
import com.groupbyinc.api.model.refinement.RefinementRange;
import com.groupbyinc.api.model.refinement.RefinementValue;
import com.groupbyinc.api.request.AbstractRequest;
import com.groupbyinc.api.request.RefinementsRequest;
import com.groupbyinc.api.request.RestrictNavigation;
import com.groupbyinc.api.request.SelectedRefinement;
import com.groupbyinc.api.request.Sort;
import com.groupbyinc.api.request.refinement.SelectedRefinementRange;
import com.groupbyinc.api.request.refinement.SelectedRefinementValue;
import com.groupbyinc.common.apache.commons.collections4.CollectionUtils;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.jackson.Mappers;
import com.groupbyinc.common.jregex.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractQuery<R extends AbstractRequest<R>, Q extends AbstractQuery<R, Q>> {
    private static final String DOTS = "\\.\\.";
    public static final Pattern REFINEMENTS_SPLITTER_PATTERN = new Pattern("~((?=[\\w.]*[=:]))");
    public static final String[] EMPTY_REFINEMENTS = new String[0];
    private String query;
    private int skip = 0;
    private int pageSize = 10;
    private String collection;
    private String area;
    private String biasingProfile;
    private String language;
    private List<CustomUrlParam> customUrlParams = new ArrayList<CustomUrlParam>();
    private LinkedHashMap<String, Navigation> navigations = new LinkedHashMap();
    private List<String> fields = new ArrayList<String>();
    private List<String> orFields = new ArrayList<String>();
    private boolean pruneRefinements = true;
    private boolean returnBinary = true;
    private boolean disableAutocorrection = false;
    protected RestrictNavigation restrictNavigation;

    private static <R extends AbstractRequest<R>> String requestToJson(R request) {
        try {
            return Mappers.writeValueAsString(request);
        }
        catch (IllegalArgumentException e) {
            return "{}";
        }
    }

    private static <R extends AbstractRequest<R>> String requestToJson(RefinementsRequest<R> request) {
        try {
            return Mappers.writeValueAsString(request);
        }
        catch (IllegalArgumentException e) {
            return "{}";
        }
    }

    protected abstract R generateRequest();

    protected abstract RefinementsRequest<R> populateRefinementRequest();

    protected static Sort convertSort(com.groupbyinc.api.model.Sort sort) {
        Sort convertedSort = null;
        if (sort != null) {
            convertedSort = new Sort().setField(sort.getField());
            switch (sort.getOrder()) {
                case Ascending: {
                    convertedSort.setOrder(Sort.Order.Ascending);
                    break;
                }
                case Descending: {
                    convertedSort.setOrder(Sort.Order.Descending);
                }
            }
        }
        return convertedSort;
    }

    private List<SelectedRefinement> generateSelectedRefinements(LinkedHashMap<String, Navigation> navigations) {
        ArrayList<SelectedRefinement> refinements = new ArrayList<SelectedRefinement>();
        for (Navigation n : navigations.values()) {
            for (Refinement r : n.getRefinements()) {
                switch (r.getType()) {
                    case Range: {
                        RefinementRange rr = (RefinementRange)r;
                        refinements.add((SelectedRefinement)((SelectedRefinementRange)new SelectedRefinementRange().setNavigationName(n.getName())).setLow(rr.getLow()).setHigh(rr.getHigh()).setExclude(rr.getExclude()));
                        break;
                    }
                    case Value: {
                        RefinementValue rv = (RefinementValue)r;
                        refinements.add((SelectedRefinement)((SelectedRefinementValue)new SelectedRefinementValue().setNavigationName(n.getName())).setValue(rv.getValue()).setExclude(rv.getExclude()));
                        break;
                    }
                }
            }
        }
        return refinements;
    }

    private R populateRequest(String clientKey) {
        R request = this.generateRequest();
        ((AbstractRequest)request).setClientKey(clientKey);
        ((AbstractRequest)request).setArea(this.area);
        ((AbstractRequest)request).setCollection(this.collection);
        ((AbstractRequest)request).setQuery(this.query);
        ((AbstractRequest)request).setFields(this.fields);
        ((AbstractRequest)request).setOrFields(this.orFields);
        ((AbstractRequest)request).setLanguage(this.language);
        ((AbstractRequest)request).setBiasingProfile(this.biasingProfile);
        ((AbstractRequest)request).setPageSize(this.pageSize);
        ((AbstractRequest)request).setSkip(this.skip);
        ((AbstractRequest)request).setCustomUrlParams(this.getCustomUrlParams());
        ((AbstractRequest)request).setRefinements(this.generateSelectedRefinements(this.navigations));
        ((AbstractRequest)request).setRestrictNavigation(this.convertRestrictNavigation());
        if (!this.pruneRefinements) {
            ((AbstractRequest)request).setPruneRefinements(false);
        }
        if (this.returnBinary) {
            ((AbstractRequest)request).setReturnBinary(true);
        }
        if (this.disableAutocorrection) {
            ((AbstractRequest)request).setDisableAutocorrection(true);
        }
        return request;
    }

    private RestrictNavigation convertRestrictNavigation() {
        return this.restrictNavigation == null ? null : new RestrictNavigation().setName(this.restrictNavigation.getName()).setCount(this.restrictNavigation.getCount());
    }

    public String getBridgeJson(String clientKey) {
        R request = this.populateRequest(clientKey);
        return AbstractQuery.requestToJson(request);
    }

    public String getBridgeRefinementsJson(String clientKey, String navigationName) {
        RefinementsRequest<R> request = this.populateRefinementRequest();
        request.setOriginalQuery(this.populateRequest(clientKey));
        request.setNavigationName(navigationName);
        return AbstractQuery.requestToJson(request);
    }

    public String getQuery() {
        return this.query;
    }

    public Q setQuery(String query) {
        this.query = query;
        return (Q)this;
    }

    public String getSubCollection() {
        return this.collection;
    }

    public Q setSubCollection(String subCollection) {
        this.collection = subCollection;
        return (Q)this;
    }

    public String getCollection() {
        return this.collection;
    }

    public Q setCollection(String collection) {
        this.collection = collection;
        return (Q)this;
    }

    public String getArea() {
        return this.area;
    }

    public Q setArea(String area) {
        this.area = area;
        return (Q)this;
    }

    public String getRefinementString() {
        if (CollectionUtils.isNotEmpty(this.navigations.values())) {
            StringBuilder result = new StringBuilder();
            for (Navigation n : this.navigations.values()) {
                for (Refinement r : n.getRefinements()) {
                    result.append("~").append(n.getName()).append(r.toTildeString());
                }
            }
            if (result.length() > 0) {
                return result.toString();
            }
        }
        return null;
    }

    public String getCustomUrlParamsString() {
        if (CollectionUtils.isEmpty(this.customUrlParams)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (CustomUrlParam customUrlParam : this.customUrlParams) {
            result.append("~").append(customUrlParam.getKey()).append("=").append(customUrlParam.getValue());
        }
        return result.toString();
    }

    public List<CustomUrlParam> getCustomUrlParams() {
        return this.customUrlParams;
    }

    protected String getBridgeJsonRefinementSearch(String clientKey) {
        R request = this.generateRequest();
        ((AbstractRequest)request).setClientKey(clientKey);
        ((AbstractRequest)request).setCollection(this.collection);
        ((AbstractRequest)request).setArea(this.area);
        ((AbstractRequest)request).setRefinementQuery(this.query);
        return AbstractQuery.requestToJson(request);
    }

    protected String[] splitRefinements(String refinementString) {
        return StringUtils.isBlank((CharSequence)refinementString) ? EMPTY_REFINEMENTS : REFINEMENTS_SPLITTER_PATTERN.tokenizer(refinementString).split();
    }

    public Q addRefinementsByString(String refinementString) {
        String[] filterStrings;
        if (refinementString == null) {
            return (Q)this;
        }
        for (String filterString : filterStrings = this.splitRefinements(refinementString)) {
            Refinement refinement;
            if (StringUtils.isBlank((CharSequence)filterString) || "=".equals(filterString)) continue;
            int colon = filterString.indexOf(":");
            int equals = filterString.indexOf("=");
            boolean isRange = colon != -1 && equals == -1;
            String[] nameValue = filterString.split("[:=]", 2);
            if (isRange) {
                RefinementRange rr = new RefinementRange();
                if (nameValue[1].endsWith("..")) {
                    rr.setLow(nameValue[1].split(DOTS)[0]);
                    rr.setHigh("");
                } else if (nameValue[1].startsWith("..")) {
                    rr.setLow("");
                    rr.setHigh(nameValue[1].split(DOTS)[1]);
                } else {
                    String[] lowHigh = nameValue[1].split(DOTS);
                    rr.setLow(lowHigh[0]);
                    rr.setHigh(lowHigh[1]);
                }
                refinement = rr;
            } else {
                refinement = new RefinementValue();
                refinement.setValue(nameValue[1]);
            }
            if (!StringUtils.isNotBlank((CharSequence)nameValue[0])) continue;
            this.addRefinement(nameValue[0], refinement);
        }
        return (Q)this;
    }

    public Q addCustomUrlParam(CustomUrlParam customUrlParam) {
        this.customUrlParams.add(customUrlParam);
        return (Q)this;
    }

    public Q addCustomUrlParam(String key, String value) {
        this.customUrlParams.add(new CustomUrlParam().setKey(key).setValue(value));
        return (Q)this;
    }

    public Q addCustomUrlParamsByString(String values) {
        String[] params;
        if (values == null) {
            return (Q)this;
        }
        for (String value : params = values.split("&")) {
            String[] keyValue;
            if (!StringUtils.isNotBlank((CharSequence)value) || (keyValue = value.split("=")).length != 2 || !StringUtils.isNotBlank((CharSequence)keyValue[0]) || !StringUtils.isNotBlank((CharSequence)keyValue[1])) continue;
            this.customUrlParams.add(new CustomUrlParam().setKey(keyValue[0]).setValue(keyValue[1]));
        }
        return (Q)this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    private Q addField(List<String> fields, String ... name) {
        if (name == null) {
            return (Q)this;
        }
        Collections.addAll(fields, name);
        return (Q)this;
    }

    public Q addFields(String ... name) {
        return this.addField(this.fields, name);
    }

    public List<String> getOrFields() {
        return this.orFields;
    }

    public Q addOrField(String ... name) {
        return this.addField(this.orFields, name);
    }

    public Q addRangeRefinement(String navigationName, String low, String high) {
        return this.addRangeRefinement(navigationName, low, high, false);
    }

    public Q addRangeRefinement(String navigationName, String low, String high, boolean exclude) {
        return this.addRefinement(navigationName, (Refinement)new RefinementRange().setLow(low).setHigh(high).setExclude(exclude));
    }

    public Q addValueRefinement(String navigationName, String value) {
        return this.addValueRefinement(navigationName, value, false);
    }

    public Q addValueRefinement(String navigationName, String value, boolean exclude) {
        return this.addRefinement(navigationName, (Refinement)new RefinementValue().setValue(value).setExclude(exclude));
    }

    private Q addRefinement(String navigationName, Refinement refinement) {
        Navigation navigation = this.navigations.get(navigationName);
        if (navigation == null) {
            navigation = new Navigation().setName(navigationName);
            navigation.setRange(refinement instanceof RefinementRange);
            this.navigations.put(navigationName, navigation);
        }
        navigation.getRefinements().add(refinement);
        return (Q)this;
    }

    public long getSkip() {
        return this.skip;
    }

    public Q setSkip(int skip) {
        this.skip = skip;
        return (Q)this;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public Q setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return (Q)this;
    }

    public Map<String, Navigation> getNavigations() {
        return this.navigations;
    }

    public boolean isReturnBinary() {
        return this.returnBinary;
    }

    public Q setReturnBinary(boolean returnBinary) {
        this.returnBinary = returnBinary;
        return (Q)this;
    }

    public String getBiasingProfile() {
        return this.biasingProfile;
    }

    public Q setBiasingProfile(String biasingProfile) {
        this.biasingProfile = biasingProfile;
        return (Q)this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Q setLanguage(String language) {
        this.language = language;
        return (Q)this;
    }

    public boolean isPruneRefinements() {
        return this.pruneRefinements;
    }

    public Q setPruneRefinements(boolean pruneRefinements) {
        this.pruneRefinements = pruneRefinements;
        return (Q)this;
    }

    public boolean isAutocorrectionDisabled() {
        return this.disableAutocorrection;
    }

    public Q setDisableAutocorrection(boolean disableAutocorrection) {
        this.disableAutocorrection = disableAutocorrection;
        return (Q)this;
    }

    public Q setRestrictNavigation(RestrictNavigation restrictNavigation) {
        this.restrictNavigation = restrictNavigation;
        return (Q)this;
    }

    public Q setRestrictNavigation(String name, int count) {
        this.restrictNavigation = new RestrictNavigation().setName(name).setCount(count);
        return (Q)this;
    }
}

