/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl.client;

import com.groupbyinc.common.http.HttpException;
import com.groupbyinc.common.http.HttpHost;
import com.groupbyinc.common.http.HttpRequest;
import com.groupbyinc.common.http.annotation.ThreadSafe;
import com.groupbyinc.common.http.client.ClientProtocolException;
import com.groupbyinc.common.http.client.config.RequestConfig;
import com.groupbyinc.common.http.client.methods.CloseableHttpResponse;
import com.groupbyinc.common.http.client.methods.Configurable;
import com.groupbyinc.common.http.client.methods.HttpExecutionAware;
import com.groupbyinc.common.http.client.methods.HttpRequestWrapper;
import com.groupbyinc.common.http.client.protocol.HttpClientContext;
import com.groupbyinc.common.http.conn.ClientConnectionManager;
import com.groupbyinc.common.http.conn.ClientConnectionRequest;
import com.groupbyinc.common.http.conn.HttpClientConnectionManager;
import com.groupbyinc.common.http.conn.ManagedClientConnection;
import com.groupbyinc.common.http.conn.routing.HttpRoute;
import com.groupbyinc.common.http.conn.scheme.SchemeRegistry;
import com.groupbyinc.common.http.impl.DefaultConnectionReuseStrategy;
import com.groupbyinc.common.http.impl.client.CloseableHttpClient;
import com.groupbyinc.common.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.groupbyinc.common.http.impl.execchain.MinimalClientExec;
import com.groupbyinc.common.http.params.BasicHttpParams;
import com.groupbyinc.common.http.params.HttpParams;
import com.groupbyinc.common.http.protocol.BasicHttpContext;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.protocol.HttpRequestExecutor;
import com.groupbyinc.common.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

