/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl.entity;

import com.groupbyinc.common.http.Header;
import com.groupbyinc.common.http.HttpEntity;
import com.groupbyinc.common.http.HttpException;
import com.groupbyinc.common.http.HttpMessage;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.entity.BasicHttpEntity;
import com.groupbyinc.common.http.entity.ContentLengthStrategy;
import com.groupbyinc.common.http.impl.io.ChunkedInputStream;
import com.groupbyinc.common.http.impl.io.ContentLengthInputStream;
import com.groupbyinc.common.http.impl.io.IdentityInputStream;
import com.groupbyinc.common.http.io.SessionInputBuffer;
import com.groupbyinc.common.http.util.Args;
import java.io.IOException;

@Deprecated
@Immutable
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inbuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inbuffer, message);
    }
}

