/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.databind.deser.std;

import com.groupbyinc.common.jackson.core.JsonParser;
import com.groupbyinc.common.jackson.core.JsonProcessingException;
import com.groupbyinc.common.jackson.core.JsonToken;
import com.groupbyinc.common.jackson.databind.DeserializationContext;
import com.groupbyinc.common.jackson.databind.JsonDeserializer;
import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.deser.std.BaseNodeDeserializer;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    private static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class);
    }

    public static JsonDeserializer<? extends JsonNode> getDeserializer(Class<?> nodeClass) {
        if (nodeClass == ObjectNode.class) {
            return ObjectDeserializer.getInstance();
        }
        if (nodeClass == ArrayNode.class) {
            return ArrayDeserializer.getInstance();
        }
        return instance;
    }

    @Override
    public JsonNode getNullValue(DeserializationContext ctxt) {
        return NullNode.getInstance();
    }

    @Override
    @Deprecated
    public JsonNode getNullValue() {
        return NullNode.getInstance();
    }

    @Override
    public JsonNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 1: {
                return this.deserializeObject(p, ctxt, ctxt.getNodeFactory());
            }
            case 3: {
                return this.deserializeArray(p, ctxt, ctxt.getNodeFactory());
            }
        }
        return this.deserializeAny(p, ctxt, ctxt.getNodeFactory());
    }

    static final class ArrayDeserializer
    extends BaseNodeDeserializer<ArrayNode> {
        private static final long serialVersionUID = 1L;
        protected static final ArrayDeserializer _instance = new ArrayDeserializer();

        protected ArrayDeserializer() {
            super(ArrayNode.class);
        }

        public static ArrayDeserializer getInstance() {
            return _instance;
        }

        @Override
        public ArrayNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.isExpectedStartArrayToken()) {
                return this.deserializeArray(jp, ctxt, ctxt.getNodeFactory());
            }
            throw ctxt.mappingException(ArrayNode.class);
        }
    }

    static final class ObjectDeserializer
    extends BaseNodeDeserializer<ObjectNode> {
        private static final long serialVersionUID = 1L;
        protected static final ObjectDeserializer _instance = new ObjectDeserializer();

        protected ObjectDeserializer() {
            super(ObjectNode.class);
        }

        public static ObjectDeserializer getInstance() {
            return _instance;
        }

        @Override
        public ObjectNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
                return this.deserializeObject(jp, ctxt, ctxt.getNodeFactory());
            }
            if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                return this.deserializeObject(jp, ctxt, ctxt.getNodeFactory());
            }
            throw ctxt.mappingException(ObjectNode.class);
        }
    }
}

