/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.collections4.collection;

import com.groupbyinc.common.util.collections4.Predicate;
import com.groupbyinc.common.util.collections4.collection.AbstractCollectionDecorator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedCollection<E>
extends AbstractCollectionDecorator<E> {
    private static final long serialVersionUID = -5259182142076705162L;
    protected final Predicate<? super E> predicate;

    public static <T> PredicatedCollection<T> predicatedCollection(Collection<T> coll, Predicate<? super T> predicate) {
        return new PredicatedCollection<T>(coll, predicate);
    }

    protected PredicatedCollection(Collection<E> coll, Predicate<? super E> predicate) {
        super(coll);
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        this.predicate = predicate;
        for (E item : coll) {
            this.validate(item);
        }
    }

    protected void validate(E object) {
        if (!this.predicate.evaluate(object)) {
            throw new IllegalArgumentException("Cannot add Object '" + object + "' - Predicate '" + this.predicate + "' rejected it");
        }
    }

    @Override
    public boolean add(E object) {
        this.validate(object);
        return this.decorated().add(object);
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        for (E item : coll) {
            this.validate(item);
        }
        return this.decorated().addAll(coll);
    }
}

