/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.collections4.iterators;

import com.groupbyinc.common.util.collections4.iterators.EmptyIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyIteratorChain<E>
implements Iterator<E> {
    private int callCounter = 0;
    private boolean chainExhausted = false;
    private Iterator<? extends E> currentIterator = null;
    private Iterator<? extends E> lastUsedIterator = null;

    protected abstract Iterator<? extends E> nextIterator(int var1);

    private void updateCurrentIterator() {
        if (this.callCounter == 0) {
            this.currentIterator = this.nextIterator(++this.callCounter);
            if (this.currentIterator == null) {
                this.currentIterator = EmptyIterator.emptyIterator();
                this.chainExhausted = true;
            }
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && !this.chainExhausted) {
            Iterator<E> nextIterator;
            if ((nextIterator = this.nextIterator(++this.callCounter)) != null) {
                this.currentIterator = nextIterator;
                continue;
            }
            this.chainExhausted = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        if (this.currentIterator == null) {
            this.updateCurrentIterator();
        }
        this.lastUsedIterator.remove();
    }
}

