/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.AbstractBridge;
import com.groupbyinc.api.Query;
import com.groupbyinc.api.model.AbstractRecord;
import com.groupbyinc.api.model.Record;
import com.groupbyinc.api.model.RefinementsResult;
import com.groupbyinc.api.model.Results;
import com.groupbyinc.api.request.Request;
import com.groupbyinc.common.jackson.core.Version;
import com.groupbyinc.common.jackson.databind.Module;
import com.groupbyinc.common.jackson.databind.module.SimpleModule;
import com.groupbyinc.common.jackson.util.Mappers;
import java.io.IOException;
import java.io.InputStream;

public class Bridge
extends AbstractBridge<Request, Query, Record, Results> {
    public static Module RECORD_MAPPER = new SimpleModule("RecordModule", new Version(1, 0, 0, null, null, null)).addAbstractTypeMapping(AbstractRecord.class, Record.class);

    public Bridge(String clientKey, String bridgeHost, int bridgePort) {
        this(clientKey, bridgeHost, bridgePort, false);
    }

    public Bridge(String clientKey, String bridgeHost, int bridgePort, boolean secure) {
        this(clientKey, (secure ? "https://" : "http://") + bridgeHost + ":" + bridgePort);
    }

    protected Bridge(String clientKey, String baseUrl) {
        super(clientKey, baseUrl);
    }

    @Override
    protected Results map(InputStream data, boolean returnBinary) {
        return Mappers.readValue(data, Results.class, returnBinary, RECORD_MAPPER);
    }

    @Override
    protected RefinementsResult mapRefinements(InputStream data, boolean returnBinary) {
        return Mappers.readValue(data, RefinementsResult.class, returnBinary, RECORD_MAPPER);
    }

    public Results searchCluster(Query query) throws IOException {
        InputStream response = this.fireRequest(this.getClusterBridgeUrl(), query.getBridgeJson(this.clientKey), query.isReturnBinary());
        return this.map(response, query.isReturnBinary());
    }
}

