/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.apache.commons.collections4.functors;

import com.groupbyinc.common.util.apache.commons.collections4.Closure;
import com.groupbyinc.common.util.apache.commons.collections4.functors.FunctorUtils;
import com.groupbyinc.common.util.apache.commons.collections4.functors.NOPClosure;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedClosure<E>
implements Closure<E>,
Serializable {
    private static final long serialVersionUID = -3520677225766901240L;
    private final Closure<? super E>[] iClosures;

    public static <E> Closure<E> chainedClosure(Closure<? super E> ... closures) {
        FunctorUtils.validate(closures);
        if (closures.length == 0) {
            return NOPClosure.nopClosure();
        }
        return new ChainedClosure<E>(closures);
    }

    public static <E> Closure<E> chainedClosure(Collection<Closure<E>> closures) {
        if (closures == null) {
            throw new IllegalArgumentException("Closure collection must not be null");
        }
        if (closures.size() == 0) {
            return NOPClosure.nopClosure();
        }
        Closure[] cmds = new Closure[closures.size()];
        int i = 0;
        for (Closure<E> closure : closures) {
            cmds[i++] = closure;
        }
        FunctorUtils.validate(cmds);
        return new ChainedClosure<E>(false, cmds);
    }

    private ChainedClosure(boolean clone, Closure<? super E> ... closures) {
        this.iClosures = clone ? FunctorUtils.copy(closures) : closures;
    }

    public ChainedClosure(Closure<? super E> ... closures) {
        this(true, closures);
    }

    @Override
    public void execute(E input) {
        for (Closure<E> closure : this.iClosures) {
            closure.execute(input);
        }
    }

    public Closure<? super E>[] getClosures() {
        return FunctorUtils.copy(this.iClosures);
    }
}

