/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.apache.commons.collections4.functors;

import com.groupbyinc.common.util.apache.commons.collections4.Closure;
import com.groupbyinc.common.util.apache.commons.collections4.Transformer;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureTransformer<T>
implements Transformer<T, T>,
Serializable {
    private static final long serialVersionUID = 478466901448617286L;
    private final Closure<? super T> iClosure;

    public static <T> Transformer<T, T> closureTransformer(Closure<? super T> closure) {
        if (closure == null) {
            throw new IllegalArgumentException("Closure must not be null");
        }
        return new ClosureTransformer<T>(closure);
    }

    public ClosureTransformer(Closure<? super T> closure) {
        this.iClosure = closure;
    }

    @Override
    public T transform(T input) {
        this.iClosure.execute(input);
        return input;
    }

    public Closure<? super T> getClosure() {
        return this.iClosure;
    }
}

