/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.apache.commons.collections4.iterators;

import com.groupbyinc.common.util.apache.commons.collections4.ResettableIterator;
import com.groupbyinc.common.util.apache.commons.collections4.iterators.ListIteratorWrapper;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorIterable<E>
implements Iterable<E> {
    private final Iterator<? extends E> iterator;
    private final Iterator<E> typeSafeIterator;

    private static <E> Iterator<E> createTypesafeIterator(final Iterator<? extends E> iterator) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public IteratorIterable(Iterator<? extends E> iterator) {
        this(iterator, false);
    }

    public IteratorIterable(Iterator<? extends E> iterator, boolean multipleUse) {
        this.iterator = multipleUse && !(iterator instanceof ResettableIterator) ? new ListIteratorWrapper<E>(iterator) : iterator;
        this.typeSafeIterator = IteratorIterable.createTypesafeIterator(this.iterator);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.iterator instanceof ResettableIterator) {
            ((ResettableIterator)this.iterator).reset();
        }
        return this.typeSafeIterator;
    }
}

