/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.apache.http.impl.cookie;

import com.groupbyinc.common.util.apache.http.annotation.Immutable;
import com.groupbyinc.common.util.apache.http.cookie.CookieSpec;
import com.groupbyinc.common.util.apache.http.cookie.CookieSpecFactory;
import com.groupbyinc.common.util.apache.http.cookie.CookieSpecProvider;
import com.groupbyinc.common.util.apache.http.impl.cookie.BestMatchSpec;
import com.groupbyinc.common.util.apache.http.params.HttpParams;
import com.groupbyinc.common.util.apache.http.protocol.HttpContext;
import java.util.Collection;

@Immutable
public class BestMatchSpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    private final String[] datepatterns;
    private final boolean oneHeader;

    public BestMatchSpecFactory(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public BestMatchSpecFactory() {
        this(null, false);
    }

    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            boolean singleHeader = params.getBooleanParameter("http.protocol.single-cookie-header", false);
            return new BestMatchSpec(patterns, singleHeader);
        }
        return new BestMatchSpec();
    }

    public CookieSpec create(HttpContext context) {
        return new BestMatchSpec(this.datepatterns, this.oneHeader);
    }
}

