/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.apache.http.message;

import com.groupbyinc.common.util.apache.http.Header;
import com.groupbyinc.common.util.apache.http.HeaderElement;
import com.groupbyinc.common.util.apache.http.ParseException;
import com.groupbyinc.common.util.apache.http.annotation.Immutable;
import com.groupbyinc.common.util.apache.http.message.BasicHeaderValueParser;
import com.groupbyinc.common.util.apache.http.message.BasicLineFormatter;
import com.groupbyinc.common.util.apache.http.util.Args;
import java.io.Serializable;

@Immutable
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5427236326487562174L;
    private final String name;
    private final String value;

    public BasicHeader(String name, String value) {
        this.name = Args.notNull(name, "Name");
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatHeader(null, this).toString();
    }

    public HeaderElement[] getElements() throws ParseException {
        if (this.value != null) {
            return BasicHeaderValueParser.parseElements(this.value, null);
        }
        return new HeaderElement[0];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

