/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jregex.util.io;

import com.groupbyinc.common.jregex.MatchResult;
import com.groupbyinc.common.jregex.Pattern;
import com.groupbyinc.common.jregex.RETokenizer;
import com.groupbyinc.common.jregex.Replacer;
import com.groupbyinc.common.jregex.Substitution;
import com.groupbyinc.common.jregex.TextBuffer;
import com.groupbyinc.common.jregex.util.io.PathElementEnumerator;
import com.groupbyinc.common.jregex.util.io.PathElementMask;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class PathPattern
extends Pattern {
    private static final int RESERVED = 1;
    private static int GRP_NO = 2;
    private static final int ANY_G = GRP_NO++;
    private static final int FS_G = GRP_NO++;
    private static final int STAR_G = GRP_NO++;
    private static final int QMARK_G = GRP_NO++;
    private static final int SPCHAR_G = GRP_NO++;
    private static final int NONROOT_G = GRP_NO++;
    private static final String fsChars = "/\\" + File.separator;
    private static final String fsClass = "[" + fsChars + "]";
    private static final String nfsClass = "[^" + fsChars + "]";
    private static final String fName = nfsClass + "+";
    private static final Pattern fs = new Pattern(fsClass);
    private static final Pattern spCharPattern = new Pattern(PathPattern.grp(NONROOT_G, "^(?!" + fsClass + ")") + "|" + PathPattern.grp(ANY_G, fsClass + "?\\*\\*" + fsClass + "?") + "|" + PathPattern.grp(FS_G, fsClass) + "|" + PathPattern.grp(STAR_G, "\\*") + "|" + PathPattern.grp(QMARK_G, "\\?") + "|" + PathPattern.grp(SPCHAR_G, "[.()\\{\\}+|^$\\[\\]\\\\]"));
    private static final Replacer spCharProcessor = new Replacer(spCharPattern, new Substitution(){

        public void appendSubstitution(MatchResult mr, TextBuffer dest) {
            if (mr.isCaptured(FS_G)) {
                dest.append(fsClass);
            } else if (mr.isCaptured(ANY_G)) {
                dest.append("(?:(?:");
                dest.append(fsClass);
                dest.append("|^)((?:");
                dest.append(fName);
                dest.append("(?:");
                dest.append(fsClass);
                dest.append(fName);
                dest.append(")*)?))?");
                dest.append("(?:");
                dest.append(fsClass);
                dest.append("|$)");
            } else if (mr.isCaptured(STAR_G)) {
                dest.append("(");
                dest.append(nfsClass);
                dest.append("*)");
            } else if (mr.isCaptured(QMARK_G)) {
                dest.append("(");
                dest.append(nfsClass);
                dest.append(")");
            } else if (mr.isCaptured(SPCHAR_G)) {
                dest.append("\\");
                mr.getGroup(SPCHAR_G, dest);
            } else if (mr.isCaptured(NONROOT_G)) {
                dest.append("(?:\\.");
                dest.append(fsClass);
                dest.append(")?");
            }
        }
    });
    private String str;
    private String root;
    private File rootf;
    private PathElementMask queue;
    private PathElementMask last;

    private static final String grp(int gno, String s) {
        return "({" + gno + "}" + s + ")";
    }

    public PathPattern(String ptn) {
        this(ptn, 0);
    }

    public PathPattern(String ptn, boolean icase) {
        this(ptn, icase ? 1 : 0);
    }

    public PathPattern(String path, int flags) {
        this(null, path, flags);
    }

    public PathPattern(File dir, String path, boolean icase) {
        this(null, path, icase ? 1 : 0);
    }

    public PathPattern(File dir, String path, int flags) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("empty path not allowed");
        }
        this.str = path;
        RETokenizer tok = new RETokenizer(fs.matcher(path), true);
        String s = tok.nextToken();
        if (s.equals("")) {
            if (dir != null) {
                this.rootf = dir;
            } else {
                this.root = "/";
            }
        } else {
            if (dir != null) {
                this.rootf = dir;
            } else {
                this.root = ".";
            }
            this.addElement(PathPattern.newMask(s, flags, tok.hasMore()));
        }
        while (tok.hasMore()) {
            s = tok.nextToken();
            boolean hasMore = tok.hasMore();
            if (s.equals("")) {
                if (!hasMore) break;
                throw new IllegalArgumentException("\"//\" not allowed");
            }
            this.addElement(PathPattern.newMask(s, flags, hasMore));
        }
        this.compile(spCharProcessor.replace(path), flags);
    }

    private void addElement(PathElementMask mask) {
        if (this.queue == null) {
            this.queue = this.last = mask;
        } else {
            this.last = this.last.next = mask;
        }
    }

    public Enumeration enumerateFiles() {
        PathElementEnumerator fe = this.queue.newEnumerator();
        fe.setDir(this.rootf != null ? this.rootf : new File(this.root));
        return fe;
    }

    public File[] files() {
        Enumeration e = this.enumerateFiles();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    public String[] names() {
        return null;
    }

    public File directory() {
        return null;
    }

    private static PathElementMask newMask(String s, int flags, boolean dirsOnly) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Error: empty path element not allowed");
        }
        if (s.indexOf(42) < 0 && s.indexOf(63) < 0) {
            if ((flags & 1) == 0 || s.indexOf(58) >= 0) {
                return PathElementMask.fixedMask(s, dirsOnly);
            }
            return PathElementMask.regularMask(s, flags, dirsOnly);
        }
        if (s.equals("*")) {
            return PathElementMask.anyFile(dirsOnly);
        }
        if (s.equals("**")) {
            return PathElementMask.anyPath(dirsOnly);
        }
        return PathElementMask.regularMask(s, flags, dirsOnly);
    }

    public String toString() {
        return this.str;
    }
}

