/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.builder.BaseRequestBuilder;
import com.groupbyinc.api.config.ConnectionConfiguration;
import com.groupbyinc.common.apache.http.client.config.RequestConfig;
import com.groupbyinc.common.apache.http.client.methods.CloseableHttpResponse;
import com.groupbyinc.common.apache.http.client.methods.HttpPost;
import com.groupbyinc.common.apache.http.client.methods.HttpRequestBase;
import com.groupbyinc.common.apache.http.entity.StringEntity;
import com.groupbyinc.common.apache.http.impl.client.CloseableHttpClient;
import com.groupbyinc.common.apache.http.impl.client.HttpClientBuilder;
import com.groupbyinc.common.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.groupbyinc.common.jackson.Mappers;
import com.groupbyinc.common.util.exception.GroupByUtilException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class Client
implements AutoCloseable {
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOG = Logger.getLogger(Client.class.getName());
    private final ConnectionConfiguration config;
    private final RequestConfig requestConfig;
    private CloseableHttpClient httpClient;
    private String urlOverride;

    public Client() {
        this(null);
    }

    public Client(String url) {
        this(url, true, new ConnectionConfiguration());
    }

    private Client(String url, boolean compressResponse, ConnectionConfiguration config) {
        if (url != null) {
            try {
                new URI(url);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Invalid url: " + url);
            }
        }
        this.urlOverride = url;
        this.config = config;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectTimeout()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).setSocketTimeout(config.getSocketTimeout()).build();
        this.createClient();
    }

    private void createClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.config.getMaxConnections());
        cm.setDefaultMaxPerRoute(this.config.getMaxConnectionsPerRoute());
        this.httpClient = HttpClientBuilder.create().setConnectionManager(cm).setDefaultRequestConfig(this.requestConfig).build();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public <T, R> CloseableHttpResponse jsonPost(BaseRequestBuilder<T, R> request) {
        return this.httpPost(APPLICATION_JSON, request, Collections.singletonMap("Accept", APPLICATION_JSON));
    }

    public <T, R> CloseableHttpResponse httpPost(String contentType, BaseRequestBuilder<T, R> request, Map<String, String> additionalHeaders) {
        String url = this.urlOverride != null ? this.urlOverride : request.getUrl();
        HttpPost httpRequest = new HttpPost(url);
        additionalHeaders.forEach(httpRequest::addHeader);
        StringEntity entity = new StringEntity(Mappers.writeValueAsString(request.build()), StandardCharsets.UTF_8);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", contentType + ";charset=" + StandardCharsets.UTF_8);
        return this.httpExecute(httpRequest);
    }

    private CloseableHttpResponse httpExecute(HttpRequestBase request) {
        try {
            return this.httpClient.execute(request);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            throw new GroupByUtilException(e.getMessage(), e);
        }
    }

    public <T, R> R send(BaseRequestBuilder<T, R> request) throws IOException {
        CloseableHttpResponse webResponse = this.jsonPost(request);
        InputStream data = webResponse.getEntity().getContent();
        return Mappers.readValue(data, request.getResultType(), false);
    }
}

