/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Lists;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"keys/0"})
public class KeysFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("keys", in, JsonNodeType.OBJECT, JsonNodeType.ARRAY);
        if (in.isObject()) {
            List<String> keys = Lists.newArrayList(in.fieldNames());
            Collections.sort(keys);
            ArrayNode result = scope.getObjectMapper().createArrayNode();
            for (String key : keys) {
                result.add(new TextNode(key));
            }
            return Collections.singletonList(result);
        }
        if (in.isArray()) {
            ArrayNode result = scope.getObjectMapper().createArrayNode();
            for (int i = 0; i < in.size(); ++i) {
                result.add(new IntNode(i));
            }
            return Collections.singletonList(result);
        }
        throw new IllegalStateException();
    }
}

