/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.annotation.JsonIgnoreProperties;
import com.groupbyinc.common.jackson.annotation.JsonProperty;
import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.BooleanNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.OnigUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import com.groupbyinc.common.jackson.jq.internal.misc.UnicodeUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.joni.Matcher;
import org.joni.Region;

@BuiltinFunction(value={"_match_impl/3"})
public class _MatchImplFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("_match_impl/3", in, JsonNodeType.STRING);
        byte[] ibytes = in.asText().getBytes(StandardCharsets.UTF_8);
        int[] cindex = UnicodeUtils.UTF8CharIndex(ibytes);
        List<JsonNode> regexTuple = args.get(0).apply(scope, in);
        List<JsonNode> modifiersTuple = args.get(1).apply(scope, in);
        List<JsonNode> testTuple = args.get(2).apply(scope, in);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode regex : regexTuple) {
            Preconditions.checkArgumentType("_match_impl/3", 1, regex, JsonNodeType.STRING);
            for (JsonNode modifiers : modifiersTuple) {
                Preconditions.checkArgumentType("_match_impl/3", 2, modifiers, JsonNodeType.STRING, JsonNodeType.NULL);
                for (JsonNode test : testTuple) {
                    Preconditions.checkArgumentType("_match_impl/3", 3, test, JsonNodeType.BOOLEAN);
                    OnigUtils.Pattern p = new OnigUtils.Pattern(regex.asText(), modifiers.isNull() ? null : modifiers.asText());
                    out.add(_MatchImplFunction.match(scope.getObjectMapper(), p, ibytes, cindex, test.asBoolean()));
                }
            }
        }
        return out;
    }

    private static JsonNode match(ObjectMapper mapper, OnigUtils.Pattern pattern, byte[] ibytes, int[] cindex, boolean test) {
        Matcher m = pattern.regex.matcher(ibytes);
        if (test) {
            boolean match = m.search(0, ibytes.length, 0) >= 0;
            return BooleanNode.valueOf(match);
        }
        ArrayNode matches = mapper.createArrayNode();
        int offset = 0;
        while (m.search(offset, ibytes.length, 0) >= 0) {
            MatchObject obj = new MatchObject();
            obj.offset = cindex[m.getBegin()];
            obj.length = cindex[m.getEnd()] - cindex[m.getBegin()];
            obj.string = new String(ibytes, m.getBegin(), m.getEnd() - m.getBegin());
            Region regions = m.getRegion();
            if (regions != null && m.getEnd() != m.getBegin()) {
                for (int i = 1; i < regions.numRegs; ++i) {
                    CaptureObject capture = new CaptureObject();
                    if (regions.beg[i] >= 0) {
                        capture.offset = cindex[regions.beg[i]];
                        capture.length = cindex[regions.end[i]] - cindex[regions.beg[i]];
                        capture.string = new String(ibytes, regions.beg[i], regions.end[i] - regions.beg[i], StandardCharsets.UTF_8);
                    } else {
                        capture.offset = -1;
                        capture.length = 0;
                        capture.string = null;
                    }
                    capture.name = pattern.names[i];
                    obj.captures.add(capture);
                }
            }
            matches.add((JsonNode)mapper.valueToTree(obj));
            offset = m.getEnd() == offset ? ++offset : m.getEnd();
            if (pattern.global && offset != ibytes.length) continue;
        }
        return matches;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class MatchObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="captures")
        public List<CaptureObject> captures = new ArrayList<CaptureObject>();

        MatchObject() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CaptureObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="name")
        public String name;

        private CaptureObject() {
        }
    }
}

