/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.matcher.matchers;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.misc.Functional;
import com.groupbyinc.common.jackson.jq.internal.misc.Pair;
import com.groupbyinc.common.jackson.jq.internal.tree.matcher.PatternMatcher;
import java.util.List;
import java.util.Stack;

public class ArrayMatcher
implements PatternMatcher {
    private List<PatternMatcher> matchers;

    public ArrayMatcher(List<PatternMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public void match(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, boolean emit) throws JsonQueryException {
        if (!in.isArray() && !in.isNull()) {
            throw JsonQueryTypeException.format("Cannot index %s with number", new Object[]{in.getNodeType()});
        }
        for (int i = 0; i < this.matchers.size(); ++i) {
            PatternMatcher matcher = this.matchers.get(i);
            JsonNode item = in.get(i);
            matcher.match(scope, item != null ? item : NullNode.getInstance(), out, accumulate, emit && i == this.matchers.size() - 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (PatternMatcher matcher : this.matchers) {
            sb.append(sep);
            sb.append(matcher);
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }
}

