package com.groupbyinc.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.groupbyinc.api.interfaces.MatchStrategyInterface;
import com.groupbyinc.api.interfaces.PartialMatchRuleInterface;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @internal
 */
public class MatchStrategy implements MatchStrategyInterface {

  @JsonProperty private String name;
  @JsonProperty private List<PartialMatchRule> rules = new ArrayList<PartialMatchRule>();

  public List<PartialMatchRule> getRules() {
    return rules;
  }

  @JsonIgnore
  public com.groupbyinc.api.model.MatchStrategy setRules(PartialMatchRule... rules) {
    CollectionUtils.addAll(this.rules, rules);
    return this;
  }

  @JsonSetter
  public com.groupbyinc.api.model.MatchStrategy setRules(List<PartialMatchRule> rules) {
    this.rules = rules;
    return this;
  }

  @Override
  @JsonIgnore
  public void addRule(PartialMatchRuleInterface rule) {
    rules.add(new PartialMatchRule().setTerms(rule.getTerms()).setTermsGreaterThan(rule.getTermsGreaterThan()).setMustMatch(rule.getMustMatch()).setPercentage(rule.getPercentage()));
  }

  public String getName() {
    return name;
  }

  public com.groupbyinc.api.model.MatchStrategy setName(String name) {
    this.name = name;
    return this;
  }
}
