package com.groupbyinc.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.groupbyinc.api.model.zone.ContentZone;
import com.groupbyinc.api.model.zone.RecordZone;
import com.groupbyinc.api.model.zone.RichContentZone;

/**
 * @internal
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonSubTypes({
    @JsonSubTypes.Type(value = ContentZone.class, name = "Content"), //
    @JsonSubTypes.Type(value = RecordZone.class, name = "Record"), //
    @JsonSubTypes.Type(value = RichContentZone.class, name = "Rich_Content")})
public abstract class Zone<Z extends com.groupbyinc.api.model.Zone<Z>> {

  public enum Type {
    Content,
    Record,
    Rich_Content
  }

  @JsonProperty("_id") private String id;
  private String name;

  /**
   * <code>
   * Zones support the following content types:
   *
   *     Content, Record, Rich_Content
   *
   * </code>
   *
   * @return The type of zone.
   */
  @JsonTypeId
  public abstract Type getType();

  /**
   * @return ID is a MD5 hash of the name.
   */
  public String getId() {
    return id;
  }

  /**
   * @param id Set the ID.
   * @return
   */
  @SuppressWarnings("unchecked")
  public Z setId(String id) {
    this.id = id;
    return (Z) this;
  }

  /**
   * @return The name of the zone.
   */
  public String getName() {
    return name;
  }

  /**
   * @param name Set the name
   * @return
   */
  @SuppressWarnings("unchecked")
  public Z setName(String name) {
    this.name = name;
    return (Z) this;
  }
}
