package com.groupbyinc.api.model.sort;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.groupbyinc.api.model.Sort;
import com.groupbyinc.util.defaults.FieldSortOrderDefault;

/**
 * <code>
 * Object that specifies sort field and direction
 * </code>
 */
public class FieldSort implements Sort {

  public static final com.groupbyinc.api.model.sort.FieldSort RELEVANCE = new com.groupbyinc.api.model.sort.FieldSort().setField("_relevance");

  private String field;

  @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = FieldSortOrderDefault.class) private Order order = Order.Ascending;

  public String getField() {
    return field;
  }

  /**
   *
   * @param field
   *      The source field name to sort by.
   * @return
   */
  public com.groupbyinc.api.model.sort.FieldSort setField(String field) {
    this.field = field;
    return this;
  }

  /**
   *
   * @return The order Ascending or Descending
   */
  public Order getOrder() {
    return order;
  }

  /**
   * <code>
   *     Order in which the field will be applied.  Takes either
   *     `Ascending` or `Descending`
   * </code>
   * @param order
   * @return
   */
  public com.groupbyinc.api.model.sort.FieldSort setOrder(Order order) {
    this.order = order;
    return this;
  }
}
