package com.groupbyinc.api.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.groupbyinc.api.model.CustomUrlParam;
import com.groupbyinc.common.security.AesContent;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Request object for the api to send search service requests
 *
 * @internal
 */
public class Request {

  private String clientKey;
  private String collection;
  private String area;
  private String sessionId;
  private String visitorId;
  private String biasingProfile;
  private String language;
  private String query;
  private String refinementQuery;
  private String matchStrategyName;
  private Biasing biasing;
  private RestrictNavigation restrictNavigation;
  private MatchStrategy matchStrategy;
  private Integer skip;
  private Integer pageSize;
  private Boolean returnBinary;
  private Boolean disableAutocorrection;
  private AesContent securedPayload;
  @JsonIgnore private Map<String, String> queryUrlParams = new HashMap<String, String>();
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  private List<Sort> sort = new ArrayList<Sort>();
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<String> fields = new ArrayList<String>();
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<String> orFields = new ArrayList<String>();
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<SelectedRefinement> refinements = new ArrayList<SelectedRefinement>();
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<CustomUrlParam> customUrlParams = new ArrayList<CustomUrlParam>();
  @JsonInclude(JsonInclude.Include.NON_DEFAULT) private Boolean wildcardSearchEnabled = false;
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<String> includedNavigations = new ArrayList<String>();
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<String> excludedNavigations = new ArrayList<String>();
  @JsonInclude(JsonInclude.Include.NON_EMPTY) private List<Navigation> navigations = new ArrayList<Navigation>();
  private Boolean pruneRefinements = true;

  public String getClientKey() {
    return clientKey;
  }

  public com.groupbyinc.api.request.Request setClientKey(String clientKey) {
    this.clientKey = clientKey;
    return this;
  }

  public String getArea() {
    return area;
  }

  public com.groupbyinc.api.request.Request setArea(String area) {
    this.area = area;
    return this;
  }

  public String getCollection() {
    return collection;
  }

  public com.groupbyinc.api.request.Request setCollection(String collection) {
    this.collection = collection;
    return this;
  }

  public String getSessionId() {
    return sessionId;
  }

  public com.groupbyinc.api.request.Request setSessionId(String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  public String getVisitorId() {
    return visitorId;
  }

  public com.groupbyinc.api.request.Request setVisitorId(String visitorId) {
    this.visitorId = visitorId;
    return this;
  }

  public String getQuery() {
    return query;
  }

  public com.groupbyinc.api.request.Request setQuery(String query) {
    this.query = query;
    return this;
  }

  public Integer getSkip() {
    return skip;
  }

  public com.groupbyinc.api.request.Request setSkip(Integer skip) {
    this.skip = skip;
    return this;
  }

  public Integer getPageSize() {
    return pageSize;
  }

  public com.groupbyinc.api.request.Request setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  public List<CustomUrlParam> getCustomUrlParams() {
    return customUrlParams;
  }

  public com.groupbyinc.api.request.Request setCustomUrlParams(List<CustomUrlParam> customUrlParams) {
    this.customUrlParams = customUrlParams;
    return this;
  }

  public List<String> getFields() {
    return fields;
  }

  public com.groupbyinc.api.request.Request setFields(List<String> fields) {
    this.fields = fields;
    return this;
  }

  public List<String> getOrFields() {
    return orFields;
  }

  public com.groupbyinc.api.request.Request setOrFields(List<String> orFields) {
    this.orFields = orFields;
    return this;
  }

  public String getBiasingProfile() {
    return biasingProfile;
  }

  public com.groupbyinc.api.request.Request setBiasingProfile(String biasingProfile) {
    this.biasingProfile = biasingProfile;
    return this;
  }

  public List<Sort> getSort() {
    return sort;
  }

  @JsonIgnore
  public com.groupbyinc.api.request.Request setSort(Sort... sort) {
    CollectionUtils.addAll(this.sort, sort);
    return this;
  }

  @JsonSetter
  public com.groupbyinc.api.request.Request setSort(List<Sort> sort) {
    this.sort = sort;
    return this;
  }

  public String getLanguage() {
    return language;
  }

  public com.groupbyinc.api.request.Request setLanguage(String language) {
    this.language = language;
    return this;
  }

  public Boolean getPruneRefinements() {
    return pruneRefinements;
  }

  public com.groupbyinc.api.request.Request setPruneRefinements(Boolean pruneRefinements) {
    this.pruneRefinements = pruneRefinements;
    return this;
  }

  public Boolean getReturnBinary() {
    return returnBinary;
  }

  public com.groupbyinc.api.request.Request setReturnBinary(Boolean returnBinary) {
    this.returnBinary = returnBinary;
    return this;
  }

  public Boolean getDisableAutocorrection() {
    return disableAutocorrection;
  }

  public com.groupbyinc.api.request.Request setDisableAutocorrection(Boolean disableAutocorrection) {
    this.disableAutocorrection = disableAutocorrection;
    return this;
  }

  public List<SelectedRefinement> getRefinements() {
    return refinements;
  }

  public com.groupbyinc.api.request.Request setRefinements(List<SelectedRefinement> refinements) {
    this.refinements = refinements;
    return this;
  }

  public String getRefinementQuery() {
    return refinementQuery;
  }

  public com.groupbyinc.api.request.Request setRefinementQuery(String refinementQuery) {
    this.refinementQuery = refinementQuery;
    return this;
  }

  public RestrictNavigation getRestrictNavigation() {
    return restrictNavigation;
  }

  public com.groupbyinc.api.request.Request setRestrictNavigation(RestrictNavigation restrictNavigation) {
    this.restrictNavigation = restrictNavigation;
    return this;
  }

  public Boolean isWildcardSearchEnabled() {
    return wildcardSearchEnabled;
  }

  public com.groupbyinc.api.request.Request setWildcardSearchEnabled(Boolean wildcardSearchEnabled) {
    this.wildcardSearchEnabled = wildcardSearchEnabled;
    return this;
  }

  public MatchStrategy getMatchStrategy() {
    return matchStrategy;
  }

  public com.groupbyinc.api.request.Request setMatchStrategy(MatchStrategy matchStrategy) {
    this.matchStrategy = matchStrategy;
    return this;
  }

  public List<String> getIncludedNavigations() {
    return includedNavigations;
  }

  public com.groupbyinc.api.request.Request setIncludedNavigations(List<String> includedNavigations) {
    this.includedNavigations = includedNavigations;
    return this;
  }

  public List<String> getExcludedNavigations() {
    return excludedNavigations;
  }

  public com.groupbyinc.api.request.Request setExcludedNavigations(List<String> excludedNavigations) {
    this.excludedNavigations = excludedNavigations;
    return this;
  }

  public Biasing getBiasing() {
    return biasing;
  }

  public com.groupbyinc.api.request.Request setBiasing(Biasing biasing) {
    this.biasing = biasing;
    return this;
  }

  public String getMatchStrategyName() {
    return matchStrategyName;
  }

  public com.groupbyinc.api.request.Request setMatchStrategyName(String matchStrategyName) {
    this.matchStrategyName = matchStrategyName;
    return this;
  }

  public Map<String, String> getQueryUrlParams() {
    return queryUrlParams;
  }

  public com.groupbyinc.api.request.Request setQueryUrlParams(Map<String, String> queryUrlParams) {
    this.queryUrlParams = queryUrlParams;
    return this;
  }

  public AesContent getSecuredPayload() {
    return securedPayload;
  }

  public com.groupbyinc.api.request.Request setSecuredPayload(AesContent securedPayload) {
    this.securedPayload = securedPayload;
    return this;
  }

  public List<Navigation> getNavigations() {
    return navigations;
  }

  public com.groupbyinc.api.request.Request setNavigations(List<Navigation> navigations) {
    this.navigations = navigations;
    return this;
  }
}
